/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePlugin;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DeviceRuntimeSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.YarnRuntimeType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DeviceMappingManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DevicePluginAdapter;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.ShellWrapper;

public class DeviceResourceHandlerImpl
implements ResourceHandler {
    static final Log LOG = LogFactory.getLog(DeviceResourceHandlerImpl.class);
    private final String resourceName;
    private final DevicePlugin devicePlugin;
    private final DeviceMappingManager deviceMappingManager;
    private final CGroupsHandler cGroupsHandler;
    private final PrivilegedOperationExecutor privilegedOperationExecutor;
    private final DevicePluginAdapter devicePluginAdapter;
    private final Context nmContext;
    private ShellWrapper shellWrapper;
    public static final String EXCLUDED_DEVICES_CLI_OPTION = "--excluded_devices";
    public static final String ALLOWED_DEVICES_CLI_OPTION = "--allowed_devices";
    public static final String CONTAINER_ID_CLI_OPTION = "--container_id";

    public DeviceResourceHandlerImpl(String resName, DevicePluginAdapter devPluginAdapter, DeviceMappingManager devMappingManager, CGroupsHandler cgHandler, PrivilegedOperationExecutor operation, Context ctx) {
        this.devicePluginAdapter = devPluginAdapter;
        this.resourceName = resName;
        this.devicePlugin = devPluginAdapter.getDevicePlugin();
        this.cGroupsHandler = cgHandler;
        this.privilegedOperationExecutor = operation;
        this.deviceMappingManager = devMappingManager;
        this.nmContext = ctx;
        this.shellWrapper = new ShellWrapper();
    }

    @VisibleForTesting
    public DeviceResourceHandlerImpl(String resName, DevicePluginAdapter devPluginAdapter, DeviceMappingManager devMappingManager, CGroupsHandler cgHandler, PrivilegedOperationExecutor operation, Context ctx, ShellWrapper shell) {
        this.devicePluginAdapter = devPluginAdapter;
        this.resourceName = resName;
        this.devicePlugin = devPluginAdapter.getDevicePlugin();
        this.cGroupsHandler = cgHandler;
        this.privilegedOperationExecutor = operation;
        this.deviceMappingManager = devMappingManager;
        this.nmContext = ctx;
        this.shellWrapper = shell;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        Set<Device> availableDevices = null;
        try {
            availableDevices = this.devicePlugin.getDevices();
        }
        catch (Exception e) {
            throw new ResourceHandlerException("Exception thrown from plugin's \"getDevices\"" + e.getMessage());
        }
        if (availableDevices == null) {
            LOG.error((Object)("Bootstrap " + this.resourceName + " failed. Null value got from plugin's getDevices method"));
            return null;
        }
        this.deviceMappingManager.addDeviceSet(this.resourceName, availableDevices);
        this.cGroupsHandler.initializeCGroupController(CGroupsHandler.CGroupController.DEVICES);
        return null;
    }

    @Override
    public synchronized List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        DeviceRuntimeSpec spec;
        String containerIdStr = container.getContainerId().toString();
        DeviceMappingManager.DeviceAllocation allocation = this.deviceMappingManager.assignDevices(this.resourceName, container);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Allocated to " + containerIdStr + ": " + allocation));
        }
        try {
            spec = this.devicePlugin.onDevicesAllocated(allocation.getAllowed(), YarnRuntimeType.RUNTIME_DEFAULT);
        }
        catch (Exception e) {
            throw new ResourceHandlerException("Exception thrown from plugin's \"onDeviceAllocated\"" + e.getMessage());
        }
        if (spec != null) {
            LOG.warn((Object)"Runtime spec in non-Docker container is not supported yet!");
        }
        this.cGroupsHandler.createCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
        if (!DockerLinuxContainerRuntime.isDockerContainerRequested(this.nmContext.getConf(), container.getLaunchContext().getEnvironment())) {
            this.tryIsolateDevices(allocation, containerIdStr);
            ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
            ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CGroupsHandler.CGroupController.DEVICES, containerIdStr)));
            return ret;
        }
        return null;
    }

    private void tryIsolateDevices(DeviceMappingManager.DeviceAllocation allocation, String containerIdStr) throws ResourceHandlerException {
        try {
            int minorNumber;
            int majorNumber;
            PrivilegedOperation privilegedOperation = new PrivilegedOperation(PrivilegedOperation.OperationType.DEVICE, Arrays.asList(CONTAINER_ID_CLI_OPTION, containerIdStr));
            boolean needNativeDeviceOperation = false;
            ArrayList<String> devNumbers = new ArrayList<String>();
            if (!allocation.getDenied().isEmpty()) {
                for (Device deniedDevice : allocation.getDenied()) {
                    majorNumber = deniedDevice.getMajorNumber();
                    minorNumber = deniedDevice.getMinorNumber();
                    DeviceType devType = this.getDeviceType(deniedDevice);
                    if (devType == null) continue;
                    devNumbers.add(devType.getName() + "-" + majorNumber + ":" + minorNumber + "-rwm");
                }
                if (devNumbers.size() != 0) {
                    privilegedOperation.appendArgs(Arrays.asList(EXCLUDED_DEVICES_CLI_OPTION, StringUtils.join((CharSequence)",", devNumbers)));
                    needNativeDeviceOperation = true;
                }
            }
            if (!allocation.getAllowed().isEmpty()) {
                devNumbers.clear();
                for (Device allowedDevice : allocation.getAllowed()) {
                    majorNumber = allowedDevice.getMajorNumber();
                    minorNumber = allowedDevice.getMinorNumber();
                    if (majorNumber == -1 || minorNumber == -1) continue;
                    devNumbers.add(majorNumber + ":" + minorNumber);
                }
                if (devNumbers.size() > 0) {
                    privilegedOperation.appendArgs(Arrays.asList(ALLOWED_DEVICES_CLI_OPTION, StringUtils.join((CharSequence)",", devNumbers)));
                    needNativeDeviceOperation = true;
                }
            }
            if (needNativeDeviceOperation) {
                this.privilegedOperationExecutor.executePrivilegedOperation(privilegedOperation, true);
            }
        }
        catch (PrivilegedOperationException e) {
            this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
            LOG.warn((Object)"Could not update cgroup for container", (Throwable)((Object)e));
            throw new ResourceHandlerException((Throwable)((Object)e));
        }
    }

    @Override
    public synchronized List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        this.deviceMappingManager.recoverAssignedDevices(this.resourceName, containerId);
        return null;
    }

    @Override
    public synchronized List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.deviceMappingManager.cleanupAssignedDevices(this.resourceName, containerId);
        this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return DeviceResourceHandlerImpl.class.getName() + "{" + "resourceName='" + this.resourceName + '\'' + ", devicePlugin=" + this.devicePlugin + ", devicePluginAdapter=" + this.devicePluginAdapter + '}';
    }

    public DeviceType getDeviceType(Device device) {
        DeviceType deviceType;
        String devName = device.getDevPath();
        if (devName.isEmpty()) {
            LOG.warn((Object)"Empty device path provided, try to get device type from major:minor device number");
            int major = device.getMajorNumber();
            int minor = device.getMinorNumber();
            if (major == -1 && minor == -1) {
                LOG.warn((Object)"Non device number provided, cannot decide the device type");
                return null;
            }
            return this.getDeviceTypeFromDeviceNumber(device.getMajorNumber(), device.getMinorNumber());
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Try to get device type from device path: " + devName));
            }
            String output = this.shellWrapper.getDeviceFileType(devName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("stat output:" + output));
            }
            deviceType = output.startsWith("c") ? DeviceType.CHAR : DeviceType.BLOCK;
        }
        catch (IOException e) {
            String msg = "Failed to get device type from stat " + devName;
            LOG.warn((Object)msg);
            return null;
        }
        return deviceType;
    }

    public DeviceType getDeviceTypeFromDeviceNumber(int major, int minor) {
        if (this.shellWrapper.existFile("/sys/dev/block/" + major + ":" + minor)) {
            return DeviceType.BLOCK;
        }
        return DeviceType.CHAR;
    }

    private static enum DeviceType {
        BLOCK("b"),
        CHAR("c");

        private final String name;

        private DeviceType(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }
    }
}

