/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSGroupsAdmin2
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsAdmin2.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsAdmin2.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsAdmin2.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsAdmin2.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testRegionMove() throws Exception {
        Object server;
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 6);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(this.tableName);
        String targetRegion = null;
        Iterator<ServerName> iterator = assignMap.keySet().iterator();
        while (iterator.hasNext() && (targetRegion = assignMap.get(server = iterator.next()).size() > 0 ? assignMap.get(server).get(0) : null) == null) {
        }
        ServerName tmpTargetServer = null;
        for (ServerName server2 : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            if (newGroup.containsServer(server2.getAddress())) continue;
            tmpTargetServer = server2;
            break;
        }
        final ServerName targetServer = tmpTargetServer;
        rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), newGroup.getName());
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.admin.getRegions(targetServer).size() <= 0;
            }
        });
        TEST_UTIL.getAdmin().move(Bytes.toBytes((String)RegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)targetRegion))), targetServer);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName) != null && TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() == 6 && TestRSGroupsBase.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.REGIONS_IN_TRANSITION)).getRegionStatesInTransition().size() < 1;
            }
        });
        for (RegionInfo region : admin.getRegions(targetServer)) {
            if (!targetRegion.equals(region.getRegionNameAsString())) continue;
            Assert.fail((String)"Target server opened region");
        }
    }

    @Test
    public void testRegionServerMove() throws IOException, InterruptedException {
        int initNumGroups = rsGroupAdmin.listRSGroups().size();
        RSGroupInfo appInfo = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        RSGroupInfo adminInfo = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        RSGroupInfo dInfo = rsGroupAdmin.getRSGroupInfo("default");
        Assert.assertEquals((long)(initNumGroups + 2), (long)rsGroupAdmin.listRSGroups().size());
        Assert.assertEquals((long)1L, (long)adminInfo.getServers().size());
        Assert.assertEquals((long)1L, (long)appInfo.getServers().size());
        Assert.assertEquals((long)(this.getNumServers() - 2), (long)dInfo.getServers().size());
        rsGroupAdmin.moveServers(appInfo.getServers(), "default");
        rsGroupAdmin.removeRSGroup(appInfo.getName());
        rsGroupAdmin.moveServers(adminInfo.getServers(), "default");
        rsGroupAdmin.removeRSGroup(adminInfo.getName());
        Assert.assertEquals((long)rsGroupAdmin.listRSGroups().size(), (long)initNumGroups);
    }

    @Test
    public void testMoveServers() throws Exception {
        this.addGroup("bar", 3);
        rsGroupAdmin.addRSGroup("foo");
        RSGroupInfo barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        RSGroupInfo fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)3L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), "foo");
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            String exp = "Source RSGroup for server foo:9999 does not exist.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        LOG.info("moving servers " + barGroup.getServers() + " to group foo");
        rsGroupAdmin.moveServers(barGroup.getServers(), fooGroup.getName());
        barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)3L, (long)fooGroup.getServers().size());
        LOG.info("moving servers " + fooGroup.getServers() + " to group default");
        rsGroupAdmin.moveServers(fooGroup.getServers(), "default");
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getNumServers() == TestRSGroupsBase.rsGroupAdmin.getRSGroupInfo("default").getServers().size();
            }
        });
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        LOG.info("Remove group " + barGroup.getName());
        rsGroupAdmin.removeRSGroup(barGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(barGroup.getName()));
        LOG.info("Remove group " + fooGroup.getName());
        rsGroupAdmin.removeRSGroup(fooGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(fooGroup.getName()));
    }

    @Test
    public void testRemoveServers() throws Exception {
        String msg;
        String exp;
        LOG.info("testRemoveServers");
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 3);
        Iterator iterator = newGroup.getServers().iterator();
        ServerName targetServer = this.getServerName((Address)iterator.next());
        try {
            rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Online servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            exp = "Server " + targetServer.getAddress() + " is an online server, not allowed to remove.";
            msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        NUM_DEAD_SERVERS = cluster.getClusterMetrics().getDeadServerNames().size();
        try {
            LOG.info("stopping server " + targetServer.getServerName());
            admin.stopRegionServer(targetServer.getAddress().toString());
            ++NUM_DEAD_SERVERS;
        }
        catch (Exception ex) {
            // empty catch block
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !TestRSGroupsBase.master.getServerManager().areDeadServersInProgress() && TestRSGroupsBase.cluster.getClusterMetrics().getDeadServerNames().size() == TestRSGroupsBase.NUM_DEAD_SERVERS;
            }
        });
        try {
            rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Dead servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            exp = "Server " + targetServer.getAddress() + " is on the dead servers list," + " Maybe it will come back again, not allowed to remove.";
            msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        ArrayList<ServerName> serversToDecommission = new ArrayList<ServerName>();
        targetServer = this.getServerName((Address)iterator.next());
        Assert.assertTrue((boolean)master.getServerManager().getOnlineServers().containsKey(targetServer));
        serversToDecommission.add(targetServer);
        admin.decommissionRegionServers(serversToDecommission, true);
        Assert.assertEquals((long)1L, (long)admin.listDecommissionedRegionServers().size());
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertFalse((boolean)newGroupServers.contains(targetServer.getAddress()));
        Assert.assertEquals((long)2L, (long)newGroupServers.size());
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.observer.preRemoveServersCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.observer.postRemoveServersCalled);
    }

    @Test
    public void testMoveServersAndTables() throws Exception {
        String msg;
        Object exp;
        LOG.info("testMoveServersAndTables");
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() >= 5;
            }
        });
        ServerName targetServer = null;
        for (ServerName server : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            if (newGroup.containsServer(server.getAddress()) || rsGroupAdmin.getRSGroupInfo("master").containsServer(server.getAddress())) continue;
            targetServer = server;
            break;
        }
        LOG.debug("Print group info : " + rsGroupAdmin.listRSGroups());
        int oldDefaultGroupServerSize = rsGroupAdmin.getRSGroupInfo("default").getServers().size();
        int oldDefaultGroupTableSize = rsGroupAdmin.getRSGroupInfo("default").getTables().size();
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), (Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            exp = "Source RSGroup for server foo:9999 does not exist.";
            msg = "Expected '" + (String)exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains((CharSequence)exp));
        }
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), (Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), "default");
            Assert.fail((String)"servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            exp = "Target RSGroup default is same as source default RSGroup.";
            msg = "Expected '" + (String)exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains((CharSequence)exp));
        }
        Assert.assertEquals((long)oldDefaultGroupServerSize, (long)rsGroupAdmin.getRSGroupInfo("default").getServers().size());
        Assert.assertEquals((long)oldDefaultGroupTableSize, (long)rsGroupAdmin.getRSGroupInfo("default").getTables().size());
        Assert.assertEquals((long)1L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers().size());
        Assert.assertEquals((long)0L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().size());
        List<String> regionList = this.getTableRegionMap().get(this.tableName);
        for (String region : regionList) {
            TEST_UTIL.getAdmin().move(Bytes.toBytes((String)RegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)region))), targetServer);
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName) != null && TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() == 5 && TestRSGroupsAdmin2.this.getTableServerRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() == 1 && TestRSGroupsBase.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.REGIONS_IN_TRANSITION)).getRegionStatesInTransition().size() < 1;
            }
        });
        Assert.assertEquals((long)5L, (long)this.getTableServerRegionMap().get(this.tableName).get(targetServer).size());
        LOG.info("moving server and table to newGroup");
        rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), (Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(this.tableName).getName());
        Set defaultServers = rsGroupAdmin.getRSGroupInfo("default").getServers();
        Assert.assertFalse((boolean)defaultServers.contains(targetServer.getAddress()));
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertTrue((boolean)newGroupServers.contains(targetServer.getAddress()));
        SortedSet defaultTables = rsGroupAdmin.getRSGroupInfo("default").getTables();
        Assert.assertFalse((boolean)defaultTables.contains(this.tableName));
        SortedSet newGroupTables = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables();
        Assert.assertTrue((boolean)newGroupTables.contains(this.tableName));
        Assert.assertEquals((long)5L, (long)this.getTableServerRegionMap().get(this.tableName).get(targetServer).size());
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.observer.preMoveServersAndTables);
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.observer.postMoveServersAndTables);
    }

    @Test
    public void testMoveServersFromDefaultGroup() throws Exception {
        rsGroupAdmin.addRSGroup("foo");
        RSGroupInfo fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        RSGroupInfo defaultGroup = rsGroupAdmin.getRSGroupInfo("default");
        try {
            rsGroupAdmin.moveServers(defaultGroup.getServers(), fooGroup.getName());
            Assert.fail((String)"should keep at least one server in 'default' RSGroup.");
        }
        catch (ConstraintException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("should keep at least one server in 'default' RSGroup."));
        }
        if (defaultGroup.getServers().size() > 1) {
            Address serverInDefaultGroup = (Address)defaultGroup.getServers().iterator().next();
            LOG.info("moving server " + serverInDefaultGroup + " from group default to group " + fooGroup.getName());
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{serverInDefaultGroup}), fooGroup.getName());
        }
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        LOG.info("moving servers " + fooGroup.getServers() + " to group default");
        rsGroupAdmin.moveServers(fooGroup.getServers(), "default");
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getNumServers() == TestRSGroupsBase.rsGroupAdmin.getRSGroupInfo("default").getServers().size();
            }
        });
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        LOG.info("Remove group " + fooGroup.getName());
        rsGroupAdmin.removeRSGroup(fooGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(fooGroup.getName()));
    }
}

