/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.RSGroupableBalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestRSGroupBasedLoadBalancer
extends RSGroupableBalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupBasedLoadBalancer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupBasedLoadBalancer.class);
    private static RSGroupBasedLoadBalancer loadBalancer;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        servers = TestRSGroupBasedLoadBalancer.generateServers(7);
        groupMap = TestRSGroupBasedLoadBalancer.constructGroupInfo(servers, groups);
        tableDescs = TestRSGroupBasedLoadBalancer.constructTableDesc(true);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regions.slop", "0");
        conf.set("hbase.rsgroup.grouploadbalancer.class", SimpleLoadBalancer.class.getCanonicalName());
        loadBalancer = new RSGroupBasedLoadBalancer();
        loadBalancer.setRsGroupInfoManager(TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager());
        loadBalancer.setMasterServices(TestRSGroupBasedLoadBalancer.getMockedMaster());
        loadBalancer.setConf(conf);
        loadBalancer.initialize();
    }

    @Test
    public void testBalanceCluster() throws Exception {
        boolean[] perTableBalancerConfigs;
        for (boolean isByTable : perTableBalancerConfigs = new boolean[]{true, false}) {
            Configuration conf = loadBalancer.getConf();
            conf.setBoolean("hbase.master.loadbalance.bytable", isByTable);
            loadBalancer.setConf(conf);
            Map<ServerName, List<RegionInfo>> servers = this.mockClusterServers();
            ArrayListMultimap<String, ServerAndLoad> list = this.convertToGroupBasedMap(servers);
            LOG.info("Mock Cluster :  " + this.printStats(list));
            HashMap LoadOfAllTable = this.mockClusterServersWithTables(servers);
            List plans = loadBalancer.balanceCluster((Map)LoadOfAllTable);
            ArrayListMultimap<String, ServerAndLoad> balancedCluster = this.reconcile(list, plans);
            LOG.info("Mock Balance : " + this.printStats(balancedCluster));
            this.assertClusterAsBalanced(balancedCluster);
        }
    }

    @Test
    public void testBulkAssignment() throws Exception {
        List<RegionInfo> regions = this.randomRegions(25);
        Map assignments = loadBalancer.roundRobinAssignment(regions, servers);
        loadBalancer.roundRobinAssignment(regions, Collections.emptyList());
        Assert.assertTrue((assignments.keySet().size() == servers.size() ? 1 : 0) != 0);
        for (ServerName sn : assignments.keySet()) {
            List regionAssigned = (List)assignments.get(sn);
            for (RegionInfo region : regionAssigned) {
                TableName tableName = region.getTable();
                String groupName = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)groupName));
                RSGroupInfo gInfo = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroup(groupName);
                Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(sn.getAddress()));
            }
        }
        ArrayListMultimap<String, ServerAndLoad> loadMap = this.convertToGroupBasedMap(assignments);
        this.assertClusterAsBalanced(loadMap);
    }

    @Test
    public void testRetainAssignment() throws Exception {
        Map<ServerName, List<RegionInfo>> currentAssignments = this.mockClusterServers();
        HashMap<RegionInfo, ServerName> inputForTest = new HashMap<RegionInfo, ServerName>();
        for (ServerName sn : currentAssignments.keySet()) {
            for (RegionInfo region : currentAssignments.get(sn)) {
                inputForTest.put(region, sn);
            }
        }
        inputForTest.put(this.randomRegions(1).get(0), null);
        Map newAssignment = loadBalancer.retainAssignment(inputForTest, servers);
        this.assertRetainedAssignment(inputForTest, servers, newAssignment);
    }

    @Test
    public void testRoundRobinAssignment() throws Exception {
        ArrayList onlineServers = new ArrayList(servers.size());
        onlineServers.addAll(servers);
        List<RegionInfo> regions = this.randomRegions(25);
        int bogusRegion = 0;
        for (RegionInfo region : regions) {
            String group = (String)tableMap.get(region.getTable());
            if (!"dg3".equals(group) && !"dg4".equals(group)) continue;
            ++bogusRegion;
        }
        HashSet offlineServers = new HashSet();
        offlineServers.addAll(((RSGroupInfo)groupMap.get("dg3")).getServers());
        offlineServers.addAll(((RSGroupInfo)groupMap.get("dg4")).getServers());
        Iterator it = onlineServers.iterator();
        while (it.hasNext()) {
            ServerName server = (ServerName)it.next();
            Address address = server.getAddress();
            if (!offlineServers.contains(address)) continue;
            it.remove();
        }
        Map assignments = loadBalancer.roundRobinAssignment(regions, onlineServers);
        Assert.assertEquals((long)bogusRegion, (long)((List)assignments.get(LoadBalancer.BOGUS_SERVER_NAME)).size());
    }
}

