/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CustomResourceType;

@XmlRootElement(name="CustomResourceInfo")
@XmlAccessorType(value=XmlAccessType.NONE)
public class CustomResourceInfo {
    @XmlElement
    public long memMB;
    @XmlElement
    public long vcore;
    private Resource resource;
    @XmlElement
    public ArrayList<CustomResourceType> customResourceTypeList = new ArrayList();

    public CustomResourceInfo() {
    }

    public void reBuild() {
        if (this.resource == null) {
            this.resource = Resource.newInstance((long)this.getMemMB(), (int)((int)this.getVcore()));
        }
    }

    public CustomResourceInfo(Resource r) {
        this.memMB = r.getMemorySize();
        this.vcore = r.getVirtualCores();
        this.resource = Resource.newInstance((Resource)r);
        if (this.customResourceTypeList == null) {
            this.customResourceTypeList = new ArrayList();
        }
        for (ResourceInformation ri : r.getResources()) {
            if (ri.getName().equals(ResourceInformation.MEMORY_MB.getName()) || ri.getName().equals(ResourceInformation.VCORES.getName()) || ri.getValue() == 0L) continue;
            this.customResourceTypeList.add(new CustomResourceType(ri.getName(), ri.getValue()));
        }
    }

    public ArrayList<CustomResourceType> getCustomResourceTypeList() {
        return this.customResourceTypeList;
    }

    public Resource getResource() {
        return this.resource;
    }

    public long getMemMB() {
        return this.memMB;
    }

    public long getVcore() {
        return this.vcore;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

