/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerHealthInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueAclInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueAclsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;

@XmlRootElement(name="capacityScheduler")
@XmlType(name="capacityScheduler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CapacitySchedulerInfo
extends SchedulerInfo {
    protected float capacity;
    protected float usedCapacity;
    protected float maxCapacity;
    protected String queueName;
    protected CapacitySchedulerQueueInfoList queues;
    protected QueueCapacitiesInfo capacities;
    protected CapacitySchedulerHealthInfo health;
    protected ResourceInfo maximumAllocation;
    protected QueueAclsInfo queueAcls;
    protected int queuePriority;
    protected String orderingPolicyInfo;
    @XmlTransient
    static final float EPSILON = 1.0E-8f;

    public CapacitySchedulerInfo() {
    }

    public CapacitySchedulerInfo(CSQueue parent, CapacityScheduler cs) {
        QueueAclInfo queueAcl;
        this.queueName = parent.getQueueName();
        this.usedCapacity = parent.getUsedCapacity() * 100.0f;
        this.capacity = parent.getCapacity() * 100.0f;
        float max = parent.getMaximumCapacity();
        if (max < 1.0E-8f || max > 1.0f) {
            max = 1.0f;
        }
        this.maxCapacity = max * 100.0f;
        this.capacities = new QueueCapacitiesInfo(parent.getQueueCapacities(), parent.getQueueResourceQuotas(), false);
        this.queues = this.getQueues(cs, parent);
        this.health = new CapacitySchedulerHealthInfo(cs);
        this.maximumAllocation = new ResourceInfo(parent.getMaximumAllocation());
        CapacitySchedulerConfiguration conf = cs.getConfiguration();
        this.queueAcls = new QueueAclsInfo();
        for (Map.Entry<AccessType, AccessControlList> e : conf.getAcls(this.queueName).entrySet()) {
            queueAcl = new QueueAclInfo(e.getKey().toString(), e.getValue().getAclString());
            this.queueAcls.add(queueAcl);
        }
        String aclApplicationMaxPriority = "acl_" + StringUtils.toLowerCase((String)AccessType.APPLICATION_MAX_PRIORITY.toString());
        String priorityAcls = conf.get(parent.getQueuePath() + aclApplicationMaxPriority, "*");
        queueAcl = new QueueAclInfo(AccessType.APPLICATION_MAX_PRIORITY.toString(), priorityAcls);
        this.queueAcls.add(queueAcl);
        this.queuePriority = parent.getPriority().getPriority();
        if (parent instanceof ParentQueue) {
            this.orderingPolicyInfo = ((ParentQueue)parent).getQueueOrderingPolicy().getConfigName();
        }
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getUsedCapacity() {
        return this.usedCapacity;
    }

    public QueueCapacitiesInfo getCapacities() {
        return this.capacities;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public ResourceInfo getMaximumAllocation() {
        return this.maximumAllocation;
    }

    public QueueAclsInfo getQueueAcls() {
        return this.queueAcls;
    }

    public int getPriority() {
        return this.queuePriority;
    }

    public String getOrderingPolicyInfo() {
        return this.orderingPolicyInfo;
    }

    public CapacitySchedulerQueueInfoList getQueues() {
        return this.queues;
    }

    protected CapacitySchedulerQueueInfoList getQueues(CapacityScheduler cs, CSQueue parent) {
        CapacitySchedulerQueueInfoList queuesInfo = new CapacitySchedulerQueueInfoList();
        ArrayList childQueues = new ArrayList();
        ArrayList<CSQueue> childLeafQueues = new ArrayList<CSQueue>();
        ArrayList<CSQueue> childNonLeafQueues = new ArrayList<CSQueue>();
        for (CSQueue queue : parent.getChildQueues()) {
            if (queue instanceof LeafQueue) {
                childLeafQueues.add(queue);
                continue;
            }
            childNonLeafQueues.add(queue);
        }
        childQueues.addAll(childLeafQueues);
        childQueues.addAll(childNonLeafQueues);
        for (CSQueue queue : childQueues) {
            CapacitySchedulerQueueInfo info;
            if (queue instanceof LeafQueue) {
                info = new CapacitySchedulerLeafQueueInfo(cs, (LeafQueue)queue);
            } else {
                info = new CapacitySchedulerQueueInfo(cs, queue);
                info.queues = this.getQueues(cs, queue);
            }
            queuesInfo.addToQueueInfoList(info);
        }
        return queuesInfo;
    }
}

