/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeLookupPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodePolicySpec;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSorter;

public class MultiNodeSortingManager<N extends SchedulerNode>
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(MultiNodeSortingManager.class);
    private RMContext rmContext;
    private Map<String, MultiNodeSorter<N>> runningMultiNodeSorters;
    private Set<MultiNodePolicySpec> policySpecs = new HashSet<MultiNodePolicySpec>();
    private Configuration conf;
    private boolean multiNodePlacementEnabled;

    public MultiNodeSortingManager() {
        super("MultiNodeSortingManager");
        this.runningMultiNodeSorters = new ConcurrentHashMap<String, MultiNodeSorter<N>>();
    }

    public void serviceInit(Configuration configuration) throws Exception {
        LOG.info((Object)("Initializing NodeSortingService=" + this.getName()));
        super.serviceInit(configuration);
        this.conf = configuration;
    }

    public void serviceStart() throws Exception {
        LOG.info((Object)("Starting NodeSortingService=" + this.getName()));
        this.createAllPolicies();
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        for (MultiNodeSorter<N> sorter : this.runningMultiNodeSorters.values()) {
            sorter.stop();
        }
        super.serviceStop();
    }

    private void createAllPolicies() {
        if (!this.multiNodePlacementEnabled) {
            return;
        }
        for (MultiNodePolicySpec policy : this.policySpecs) {
            MultiNodeSorter mon = new MultiNodeSorter(this.rmContext, policy);
            mon.init(this.conf);
            mon.start();
            this.runningMultiNodeSorters.put(policy.getPolicyName(), mon);
        }
    }

    public MultiNodeSorter<N> getMultiNodePolicy(String name) {
        return this.runningMultiNodeSorters.get(name);
    }

    public void setRMContext(RMContext context) {
        this.rmContext = context;
    }

    public void registerMultiNodePolicyNames(boolean isMultiNodePlacementEnabled, Set<MultiNodePolicySpec> multiNodePlacementPolicies) {
        this.policySpecs.addAll(multiNodePlacementPolicies);
        this.multiNodePlacementEnabled = isMultiNodePlacementEnabled;
        LOG.info((Object)("MultiNode scheduling is '" + this.multiNodePlacementEnabled + "', and configured policies are " + StringUtils.join(this.policySpecs.iterator(), (String)",")));
    }

    public Iterator<N> getMultiNodeSortIterator(Collection<N> nodes, String partition, String policyName) {
        if (policyName == null) {
            LOG.warn((Object)"Multi Node scheduling is enabled, however invalid class is configured. Valid sorting policy has to be configured in yarn.scheduler.capacity.<queue>.multi-node-sorting.policy");
            return IteratorUtils.singletonIterator(nodes.iterator().next());
        }
        MultiNodeSorter<N> multiNodeSorter = this.getMultiNodePolicy(policyName);
        if (multiNodeSorter == null) {
            LOG.warn((Object)("MultiNode policy '" + policyName + "' is configured, however " + "yarn.scheduler.capacity.multi-node-placement-enabled is false"));
            return IteratorUtils.singletonIterator(nodes.iterator().next());
        }
        MultiNodeLookupPolicy<N> policy = multiNodeSorter.getMultiNodeLookupPolicy();
        if (!multiNodeSorter.isSorterThreadRunning()) {
            policy.addAndRefreshNodesSet(nodes, partition);
        }
        return policy.getPreferredNodeIterator(nodes, partition);
    }
}

