/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMappingEntity;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;

public final class QueuePlacementRuleUtils {
    public static final String CURRENT_USER_MAPPING = "%user";
    public static final String PRIMARY_GROUP_MAPPING = "%primary_group";
    public static final String SECONDARY_GROUP_MAPPING = "%secondary_group";

    private QueuePlacementRuleUtils() {
    }

    public static void validateQueueMappingUnderParentQueue(CSQueue parentQueue, String parentQueueName, String leafQueueName) throws IOException {
        if (parentQueue == null) {
            throw new IOException("mapping contains invalid or non-leaf queue [" + leafQueueName + "] and invalid parent queue [" + parentQueueName + "]");
        }
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IOException("mapping contains leaf queue [" + leafQueueName + "] and invalid parent queue which " + "does not have auto creation of leaf queues enabled [" + parentQueueName + "]");
        }
        if (!parentQueue.getQueueName().equals(parentQueueName)) {
            throw new IOException("mapping contains invalid or non-leaf queue [" + leafQueueName + "] and invalid parent queue " + "which does not match existing leaf queue's parent : [" + parentQueueName + "] does not match [ " + parentQueue.getQueueName() + "]");
        }
    }

    public static QueueMappingEntity validateAndGetAutoCreatedQueueMapping(CapacitySchedulerQueueManager queueManager, QueueMappingEntity mapping, QueuePath queuePath) throws IOException {
        if (queuePath.hasParentQueue()) {
            QueuePlacementRuleUtils.validateQueueMappingUnderParentQueue(queueManager.getQueue(queuePath.getParentQueue()), queuePath.getParentQueue(), queuePath.getLeafQueue());
            return new QueueMappingEntity(mapping.getSource(), queuePath.getLeafQueue(), queuePath.getParentQueue());
        }
        return null;
    }

    public static QueueMappingEntity validateAndGetQueueMapping(CapacitySchedulerQueueManager queueManager, CSQueue queue, QueueMappingEntity mapping, QueuePath queuePath) throws IOException {
        if (!(queue instanceof LeafQueue)) {
            throw new IOException("mapping contains invalid or non-leaf queue : " + mapping.getQueue());
        }
        if (queue instanceof AutoCreatedLeafQueue && queue.getParent() instanceof ManagedParentQueue) {
            QueueMappingEntity newMapping = QueuePlacementRuleUtils.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping == null) {
                throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
            }
            return newMapping;
        }
        return mapping;
    }

    public static boolean isStaticQueueMapping(QueueMappingEntity mapping) {
        return !mapping.getQueue().contains(CURRENT_USER_MAPPING) && !mapping.getQueue().contains(PRIMARY_GROUP_MAPPING) && !mapping.getQueue().contains(SECONDARY_GROUP_MAPPING);
    }

    public static QueuePath extractQueuePath(String queueName) throws IOException {
        int parentQueueNameEndIndex = queueName.lastIndexOf(".");
        if (parentQueueNameEndIndex > -1) {
            String parentQueue = queueName.substring(0, parentQueueNameEndIndex).trim();
            String leafQueue = queueName.substring(parentQueueNameEndIndex + 1).trim();
            return new QueuePath(parentQueue, leafQueue);
        }
        return new QueuePath(queueName);
    }

    public static ApplicationPlacementContext getPlacementContext(QueueMappingEntity mapping) {
        return QueuePlacementRuleUtils.getPlacementContext(mapping, mapping.getQueue());
    }

    public static ApplicationPlacementContext getPlacementContext(QueueMappingEntity mapping, String leafQueueName) {
        if (!StringUtils.isEmpty((String)mapping.getParentQueue())) {
            return new ApplicationPlacementContext(leafQueueName, mapping.getParentQueue());
        }
        return new ApplicationPlacementContext(leafQueueName);
    }
}

