/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

public class QueueMappingEntity {
    private String source;
    private String queue;
    private String parentQueue;
    public static final String DELIMITER = ":";

    public QueueMappingEntity(String source, String queue) {
        this.source = source;
        this.queue = queue;
        this.parentQueue = null;
    }

    public QueueMappingEntity(String source, String queue, String parentQueue) {
        this.source = source;
        this.queue = queue;
        this.parentQueue = parentQueue;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getParentQueue() {
        return this.parentQueue;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueueMappingEntity) {
            QueueMappingEntity other = (QueueMappingEntity)obj;
            return other.source.equals(this.source) && other.queue.equals(this.queue);
        }
        return false;
    }

    public String toString() {
        return this.source + DELIMITER + (this.parentQueue != null ? this.parentQueue + "." + this.queue : this.queue);
    }
}

