/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMDelegatedNodeLabelsUpdater;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceProfilesManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.monitor.RMAppLifetimeMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSortingManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.ProxyCAManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMActiveServiceContext {
    private static final Log LOG = LogFactory.getLog(RMActiveServiceContext.class);
    private final ConcurrentMap<ApplicationId, RMApp> applications;
    private final ConcurrentMap<NodeId, RMNode> nodes;
    private final ConcurrentMap<NodeId, RMNode> inactiveNodes;
    private final ConcurrentMap<ApplicationId, ByteBuffer> systemCredentials;
    private boolean isWorkPreservingRecoveryEnabled;
    private AMLivelinessMonitor amLivelinessMonitor;
    private AMLivelinessMonitor amFinishingMonitor;
    private RMStateStore stateStore;
    private ContainerAllocationExpirer containerAllocationExpirer;
    private DelegationTokenRenewer delegationTokenRenewer;
    private AMRMTokenSecretManager amRMTokenSecretManager;
    private RMContainerTokenSecretManager containerTokenSecretManager;
    private NMTokenSecretManagerInRM nmTokenSecretManager;
    private ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager;
    private ClientRMService clientRMService;
    private RMDelegationTokenSecretManager rmDelegationTokenSecretManager;
    private ResourceScheduler scheduler;
    private ReservationSystem reservationSystem;
    private NodesListManager nodesListManager;
    private ResourceTrackerService resourceTrackerService;
    private ApplicationMasterService applicationMasterService;
    private RMNodeLabelsManager nodeLabelManager;
    private RMDelegatedNodeLabelsUpdater rmDelegatedNodeLabelsUpdater;
    private long epoch;
    private Clock systemClock;
    private long schedulerRecoveryStartTime;
    private long schedulerRecoveryWaitTime;
    private boolean printLog;
    private boolean isSchedulerReady;
    private PlacementManager queuePlacementManager;
    private RMAppLifetimeMonitor rmAppLifetimeMonitor;
    private QueueLimitCalculator queueLimitCalculator;
    private AllocationTagsManager allocationTagsManager;
    private PlacementConstraintManager placementConstraintManager;
    private ResourceProfilesManager resourceProfilesManager;
    private MultiNodeSortingManager<SchedulerNode> multiNodeSortingManager;
    private ProxyCAManager proxyCAManager;

    public RMActiveServiceContext() {
        this.applications = new ConcurrentHashMap<ApplicationId, RMApp>();
        this.nodes = new ConcurrentHashMap<NodeId, RMNode>();
        this.inactiveNodes = new ConcurrentHashMap<NodeId, RMNode>();
        this.systemCredentials = new ConcurrentHashMap<ApplicationId, ByteBuffer>();
        this.stateStore = null;
        this.systemClock = SystemClock.getInstance();
        this.schedulerRecoveryStartTime = 0L;
        this.schedulerRecoveryWaitTime = 0L;
        this.printLog = true;
        this.isSchedulerReady = false;
        this.queuePlacementManager = null;
        this.queuePlacementManager = new PlacementManager();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMActiveServiceContext(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager, ResourceScheduler scheduler) {
        block2: {
            this();
            this.setContainerAllocationExpirer(containerAllocationExpirer);
            this.setAMLivelinessMonitor(amLivelinessMonitor);
            this.setAMFinishingMonitor(amFinishingMonitor);
            this.setDelegationTokenRenewer(delegationTokenRenewer);
            this.setAMRMTokenSecretManager(appTokenSecretManager);
            this.setContainerTokenSecretManager(containerTokenSecretManager);
            this.setNMTokenSecretManager(nmTokenSecretManager);
            this.setClientToAMTokenSecretManager(clientToAMTokenSecretManager);
            this.setScheduler(scheduler);
            NullRMStateStore nullStore = new NullRMStateStore();
            nullStore.setRMDispatcher(rmDispatcher);
            try {
                nullStore.init((Configuration)new YarnConfiguration());
                this.setStateStore(nullStore);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setStateStore(RMStateStore store) {
        this.stateStore = store;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ClientRMService getClientRMService() {
        return this.clientRMService;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ApplicationMasterService getApplicationMasterService() {
        return this.applicationMasterService;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTrackerService;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMStateStore getStateStore() {
        return this.stateStore;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
        return this.applications;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ConcurrentMap<NodeId, RMNode> getRMNodes() {
        return this.nodes;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ConcurrentMap<NodeId, RMNode> getInactiveRMNodes() {
        return this.inactiveNodes;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ContainerAllocationExpirer getContainerAllocationExpirer() {
        return this.containerAllocationExpirer;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public AMLivelinessMonitor getAMLivelinessMonitor() {
        return this.amLivelinessMonitor;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public AMLivelinessMonitor getAMFinishingMonitor() {
        return this.amFinishingMonitor;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public DelegationTokenRenewer getDelegationTokenRenewer() {
        return this.delegationTokenRenewer;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public AMRMTokenSecretManager getAMRMTokenSecretManager() {
        return this.amRMTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.containerTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public NMTokenSecretManagerInRM getNMTokenSecretManager() {
        return this.nmTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ResourceScheduler getScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ReservationSystem getReservationSystem() {
        return this.reservationSystem;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public NodesListManager getNodesListManager() {
        return this.nodesListManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.clientToAMTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setClientRMService(ClientRMService clientRMService) {
        this.clientRMService = clientRMService;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMDelegationTokenSecretManager getRMDelegationTokenSecretManager() {
        return this.rmDelegationTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setRMDelegationTokenSecretManager(RMDelegationTokenSecretManager delegationTokenSecretManager) {
        this.rmDelegationTokenSecretManager = delegationTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setContainerAllocationExpirer(ContainerAllocationExpirer containerAllocationExpirer) {
        this.containerAllocationExpirer = containerAllocationExpirer;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setAMLivelinessMonitor(AMLivelinessMonitor amLivelinessMonitor) {
        this.amLivelinessMonitor = amLivelinessMonitor;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setAMFinishingMonitor(AMLivelinessMonitor amFinishingMonitor) {
        this.amFinishingMonitor = amFinishingMonitor;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setContainerTokenSecretManager(RMContainerTokenSecretManager containerTokenSecretManager) {
        this.containerTokenSecretManager = containerTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setNMTokenSecretManager(NMTokenSecretManagerInRM nmTokenSecretManager) {
        this.nmTokenSecretManager = nmTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setScheduler(ResourceScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setReservationSystem(ReservationSystem reservationSystem) {
        this.reservationSystem = reservationSystem;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setDelegationTokenRenewer(DelegationTokenRenewer delegationTokenRenewer) {
        this.delegationTokenRenewer = delegationTokenRenewer;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setClientToAMTokenSecretManager(ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this.clientToAMTokenSecretManager = clientToAMTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setAMRMTokenSecretManager(AMRMTokenSecretManager amRMTokenSecretManager) {
        this.amRMTokenSecretManager = amRMTokenSecretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setNodesListManager(NodesListManager nodesListManager) {
        this.nodesListManager = nodesListManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setApplicationMasterService(ApplicationMasterService applicationMasterService) {
        this.applicationMasterService = applicationMasterService;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setResourceTrackerService(ResourceTrackerService resourceTrackerService) {
        this.resourceTrackerService = resourceTrackerService;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setWorkPreservingRecoveryEnabled(boolean enabled) {
        this.isWorkPreservingRecoveryEnabled = enabled;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public boolean isWorkPreservingRecoveryEnabled() {
        return this.isWorkPreservingRecoveryEnabled;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public long getEpoch() {
        return this.epoch;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMNodeLabelsManager getNodeLabelManager() {
        return this.nodeLabelManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setNodeLabelManager(RMNodeLabelsManager mgr) {
        this.nodeLabelManager = mgr;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public AllocationTagsManager getAllocationTagsManager() {
        return this.allocationTagsManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setAllocationTagsManager(AllocationTagsManager allocationTagsManager) {
        this.allocationTagsManager = allocationTagsManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public PlacementConstraintManager getPlacementConstraintManager() {
        return this.placementConstraintManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setPlacementConstraintManager(PlacementConstraintManager placementConstraintManager) {
        this.placementConstraintManager = placementConstraintManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMDelegatedNodeLabelsUpdater getRMDelegatedNodeLabelsUpdater() {
        return this.rmDelegatedNodeLabelsUpdater;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setRMDelegatedNodeLabelsUpdater(RMDelegatedNodeLabelsUpdater nodeLablesUpdater) {
        this.rmDelegatedNodeLabelsUpdater = nodeLablesUpdater;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public MultiNodeSortingManager<SchedulerNode> getMultiNodeSortingManager() {
        return this.multiNodeSortingManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setMultiNodeSortingManager(MultiNodeSortingManager<SchedulerNode> multiNodeSortingManager) {
        this.multiNodeSortingManager = multiNodeSortingManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setSchedulerRecoveryStartAndWaitTime(long waitTime) {
        this.schedulerRecoveryStartTime = this.systemClock.getTime();
        this.schedulerRecoveryWaitTime = waitTime;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public boolean isSchedulerReadyForAllocatingContainers() {
        if (this.isSchedulerReady) {
            return this.isSchedulerReady;
        }
        boolean bl = this.isSchedulerReady = this.systemClock.getTime() - this.schedulerRecoveryStartTime > this.schedulerRecoveryWaitTime;
        if (!this.isSchedulerReady && this.printLog) {
            LOG.info((Object)"Skip allocating containers. Scheduler is waiting for recovery.");
            this.printLog = false;
        }
        if (this.isSchedulerReady) {
            LOG.info((Object)"Scheduler recovery is done. Start allocating new containers.");
        }
        return this.isSchedulerReady;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setSystemClock(Clock clock) {
        this.systemClock = clock;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ConcurrentMap<ApplicationId, ByteBuffer> getSystemCredentialsForApps() {
        return this.systemCredentials;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public PlacementManager getQueuePlacementManager() {
        return this.queuePlacementManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setQueuePlacementManager(PlacementManager placementMgr) {
        this.queuePlacementManager = placementMgr;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setRMAppLifetimeMonitor(RMAppLifetimeMonitor lifetimeMonitor) {
        this.rmAppLifetimeMonitor = lifetimeMonitor;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMAppLifetimeMonitor getRMAppLifetimeMonitor() {
        return this.rmAppLifetimeMonitor;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public QueueLimitCalculator getNodeManagerQueueLimitCalculator() {
        return this.queueLimitCalculator;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setContainerQueueLimitCalculator(QueueLimitCalculator limitCalculator) {
        this.queueLimitCalculator = limitCalculator;
    }

    public ResourceProfilesManager getResourceProfilesManager() {
        return this.resourceProfilesManager;
    }

    public void setResourceProfilesManager(ResourceProfilesManager resourceProfilesManager) {
        this.resourceProfilesManager = resourceProfilesManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ProxyCAManager getProxyCAManager() {
        return this.proxyCAManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setProxyCAManager(ProxyCAManager proxyCAManager) {
        this.proxyCAManager = proxyCAManager;
    }
}

