/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.base.Supplier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;

public class TestShell
extends Assert {
    @Rule
    public Timeout testTimeout = new Timeout(30000);
    @Rule
    public TestName methodName = new TestName();
    private File rootTestDir = GenericTestUtils.getTestDir();
    private File methodDir;

    @Before
    public void setup() {
        this.rootTestDir.mkdirs();
        TestShell.assertTrue((String)("Not a directory " + this.rootTestDir), (boolean)this.rootTestDir.isDirectory());
        this.methodDir = new File(this.rootTestDir, this.methodName.getMethodName());
    }

    @Test
    public void testInterval() throws IOException {
        this.testInterval(-153722867280912L);
        this.testInterval(0L);
        this.testInterval(10L);
        this.testInterval(Time.now() / 60000L + 60L);
    }

    private void assertInString(String string, String search) {
        TestShell.assertNotNull((String)"Empty String", (Object)string);
        if (!string.contains(search)) {
            TestShell.fail((String)("Did not find \"" + search + "\" in " + string));
        }
    }

    @Test
    public void testShellCommandExecutorToString() throws Throwable {
        Shell.ShellCommandExecutor sce = new Shell.ShellCommandExecutor(new String[]{"ls", "..", "arg 2"});
        String command = sce.toString();
        this.assertInString(command, "ls");
        this.assertInString(command, " .. ");
        this.assertInString(command, "\"arg 2\"");
    }

    @Test
    public void testShellCommandTimeout() throws Throwable {
        Assume.assumeFalse((boolean)Shell.WINDOWS);
        String rootDir = this.rootTestDir.getAbsolutePath();
        File shellFile = new File(rootDir, "timeout.sh");
        String timeoutCommand = "sleep 4; echo \"hello\"";
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(shellFile));){
            writer.println(timeoutCommand);
            writer.close();
        }
        FileUtil.setExecutable((File)shellFile, (boolean)true);
        Shell.ShellCommandExecutor shexc = new Shell.ShellCommandExecutor(new String[]{shellFile.getAbsolutePath()}, null, null, 100L);
        try {
            shexc.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        shellFile.delete();
        TestShell.assertTrue((String)"Script did not timeout", (boolean)shexc.isTimedOut());
    }

    @Test
    @Ignore(value="Test fails due to environmental issues")
    public void testEnvVarsWithInheritance() throws Exception {
        Assume.assumeFalse((boolean)Shell.WINDOWS);
        this.testEnvHelper(true);
    }

    @Test
    public void testEnvVarsWithoutInheritance() throws Exception {
        Assume.assumeFalse((boolean)Shell.WINDOWS);
        this.testEnvHelper(false);
    }

    private void testEnvHelper(boolean inheritParentEnv) throws Exception {
        HashMap<String, String> customEnv = new HashMap<String, String>();
        customEnv.put("AAA" + System.currentTimeMillis(), "AAA");
        customEnv.put("BBB" + System.currentTimeMillis(), "BBB");
        customEnv.put("CCC" + System.currentTimeMillis(), "CCC");
        Shell.ShellCommandExecutor command = new Shell.ShellCommandExecutor(new String[]{"env"}, null, customEnv, 0L, inheritParentEnv);
        command.execute();
        String[] varsArr = command.getOutput().split("\n");
        HashMap<String, String> vars = new HashMap<String, String>();
        for (String var : varsArr) {
            int eqIndex = var.indexOf(61);
            vars.put(var.substring(0, eqIndex), var.substring(eqIndex + 1));
        }
        HashMap<String, String> expectedEnv = new HashMap<String, String>();
        expectedEnv.putAll(customEnv);
        if (inheritParentEnv) {
            expectedEnv.putAll(System.getenv());
        }
        TestShell.assertEquals(expectedEnv, vars);
    }

    private static int countTimerThreads() {
        ThreadInfo[] infos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        int count = 0;
        block0: for (ThreadInfo info : infos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), 20)) {
            if (info == null) continue;
            for (StackTraceElement elem : info.getStackTrace()) {
                if (!elem.getClassName().contains("Timer")) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Test
    public void testShellCommandTimerLeak() throws Exception {
        String[] quickCommand = new String[]{"/bin/sleep", "100"};
        int timersBefore = TestShell.countTimerThreads();
        System.err.println("before: " + timersBefore);
        for (int i = 0; i < 10; ++i) {
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(quickCommand, null, null, 1L);
            try {
                shexec.execute();
                TestShell.fail((String)"Bad command should throw exception");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread.sleep(1000L);
        int timersAfter = TestShell.countTimerThreads();
        System.err.println("after: " + timersAfter);
        TestShell.assertEquals((long)timersBefore, (long)timersAfter);
    }

    @Test
    public void testGetCheckProcessIsAliveCommand() throws Exception {
        String anyPid = "9999";
        Object[] checkProcessAliveCommand = Shell.getCheckProcessIsAliveCommand((String)anyPid);
        Object[] expectedCommand = Shell.WINDOWS ? new String[]{Shell.getWinUtilsPath(), "task", "isAlive", anyPid} : (Shell.isSetsidAvailable ? new String[]{"bash", "-c", "kill -0 -- -'" + anyPid + "'"} : new String[]{"bash", "-c", "kill -0 '" + anyPid + "'"});
        Assert.assertArrayEquals((Object[])expectedCommand, (Object[])checkProcessAliveCommand);
    }

    @Test
    public void testGetSignalKillCommand() throws Exception {
        String anyPid = "9999";
        int anySignal = 9;
        Object[] checkProcessAliveCommand = Shell.getSignalKillCommand((int)anySignal, (String)anyPid);
        Object[] expectedCommand = Shell.WINDOWS ? new String[]{Shell.getWinUtilsPath(), "task", "kill", anyPid} : (Shell.isSetsidAvailable ? new String[]{"bash", "-c", "kill -9 -- -'" + anyPid + "'"} : new String[]{"bash", "-c", "kill -9 '" + anyPid + "'"});
        Assert.assertArrayEquals((Object[])expectedCommand, (Object[])checkProcessAliveCommand);
    }

    private void testInterval(long interval) throws IOException {
        Command command = new Command(interval);
        command.run();
        TestShell.assertEquals((long)1L, (long)command.getRunCount());
        command.run();
        if (interval > 0L) {
            TestShell.assertEquals((long)1L, (long)command.getRunCount());
        } else {
            TestShell.assertEquals((long)2L, (long)command.getRunCount());
        }
    }

    @Test
    public void testHadoopHomeUnset() throws Throwable {
        this.assertHomeResolveFailed(null, "unset");
    }

    @Test
    public void testHadoopHomeEmpty() throws Throwable {
        this.assertHomeResolveFailed("", "HADOOP_HOME or hadoop.home.dir set to an empty string");
    }

    @Test
    public void testHadoopHomeEmptyDoubleQuotes() throws Throwable {
        this.assertHomeResolveFailed("\"\"", "HADOOP_HOME or hadoop.home.dir set to an empty string");
    }

    @Test
    public void testHadoopHomeEmptySingleQuote() throws Throwable {
        this.assertHomeResolveFailed("\"", "HADOOP_HOME or hadoop.home.dir set to an empty string");
    }

    @Test
    public void testHadoopHomeValid() throws Throwable {
        File f = Shell.checkHadoopHomeInner((String)this.rootTestDir.getCanonicalPath());
        TestShell.assertEquals((Object)this.rootTestDir, (Object)f);
    }

    @Test
    public void testHadoopHomeValidQuoted() throws Throwable {
        File f = Shell.checkHadoopHomeInner((String)('\"' + this.rootTestDir.getCanonicalPath() + '\"'));
        TestShell.assertEquals((Object)this.rootTestDir, (Object)f);
    }

    @Test
    public void testHadoopHomeNoDir() throws Throwable {
        this.assertHomeResolveFailed(this.methodDir.getCanonicalPath(), "does not exist");
    }

    @Test
    public void testHadoopHomeNotADir() throws Throwable {
        File touched = this.touch(this.methodDir);
        try {
            this.assertHomeResolveFailed(touched.getCanonicalPath(), "is not a directory.");
        }
        finally {
            FileUtils.deleteQuietly((File)touched);
        }
    }

    @Test
    public void testHadoopHomeRelative() throws Throwable {
        this.assertHomeResolveFailed("./target", "is not an absolute path.");
    }

    @Test
    public void testBinDirMissing() throws Throwable {
        FileNotFoundException ex = this.assertWinutilsResolveFailed(this.methodDir, "does not exist");
        this.assertInString(ex.toString(), "Hadoop bin directory");
    }

    @Test
    public void testHadoopBinNotADir() throws Throwable {
        File bin = new File(this.methodDir, "bin");
        this.touch(bin);
        try {
            this.assertWinutilsResolveFailed(this.methodDir, "is not a directory.");
        }
        finally {
            FileUtils.deleteQuietly((File)this.methodDir);
        }
    }

    @Test
    public void testBinWinUtilsFound() throws Throwable {
        try {
            File bin = new File(this.methodDir, "bin");
            File winutils = new File(bin, "winutils.exe");
            this.touch(winutils);
            TestShell.assertEquals((Object)winutils.getCanonicalPath(), (Object)Shell.getQualifiedBinInner((File)this.methodDir, (String)"winutils.exe").getCanonicalPath());
        }
        finally {
            FileUtils.deleteQuietly((File)this.methodDir);
        }
    }

    @Test
    public void testBinWinUtilsNotAFile() throws Throwable {
        try {
            File bin = new File(this.methodDir, "bin");
            File winutils = new File(bin, "winutils.exe");
            winutils.mkdirs();
            this.assertWinutilsResolveFailed(this.methodDir, "Not an executable file");
        }
        finally {
            FileUtils.deleteDirectory((File)this.methodDir);
        }
    }

    @Test
    public void testNoWinutilsOnUnix() throws Throwable {
        block4: {
            Assume.assumeFalse((boolean)Shell.WINDOWS);
            try {
                Shell.getWinUtilsFile();
            }
            catch (FileNotFoundException ex) {
                this.assertExContains(ex, "Not a Windows system");
            }
            try {
                Shell.getWinUtilsPath();
            }
            catch (RuntimeException ex) {
                this.assertExContains(ex, "Not a Windows system");
                if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) break block4;
                throw ex;
            }
        }
    }

    private File touch(File path) throws IOException {
        path.getParentFile().mkdirs();
        FileUtils.writeByteArrayToFile((File)path, (byte[])new byte[0]);
        return path;
    }

    private FileNotFoundException assertHomeResolveFailed(String path, String expectedText) throws Exception {
        try {
            File f = Shell.checkHadoopHomeInner((String)path);
            TestShell.fail((String)("Expected an exception with the text `" + expectedText + "`" + " -but got the path " + f));
            return null;
        }
        catch (FileNotFoundException ex) {
            this.assertExContains(ex, expectedText);
            return ex;
        }
    }

    private FileNotFoundException assertWinutilsResolveFailed(File hadoopHome, String expectedText) throws Exception {
        try {
            File f = Shell.getQualifiedBinInner((File)hadoopHome, (String)"winutils.exe");
            TestShell.fail((String)("Expected an exception with the text `" + expectedText + "`" + " -but got the path " + f));
            return null;
        }
        catch (FileNotFoundException ex) {
            this.assertExContains(ex, expectedText);
            return ex;
        }
    }

    private void assertExContains(Exception ex, String expectedText) throws Exception {
        if (!ex.toString().contains(expectedText)) {
            throw ex;
        }
    }

    @Test
    public void testBashQuote() {
        TestShell.assertEquals((Object)"'foobar'", (Object)Shell.bashQuote((String)"foobar"));
        TestShell.assertEquals((Object)"'foo'\\''bar'", (Object)Shell.bashQuote((String)"foo'bar"));
        TestShell.assertEquals((Object)"''\\''foo'\\''bar'\\'''", (Object)Shell.bashQuote((String)"'foo'bar'"));
    }

    @Test(timeout=120000L)
    public void testDestroyAllShellProcesses() throws Throwable {
        Assume.assumeFalse((boolean)Shell.WINDOWS);
        StringBuffer sleepCommand = new StringBuffer();
        sleepCommand.append("sleep 200");
        String[] shellCmd = new String[]{"bash", "-c", sleepCommand.toString()};
        final Shell.ShellCommandExecutor shexc1 = new Shell.ShellCommandExecutor(shellCmd);
        final Shell.ShellCommandExecutor shexc2 = new Shell.ShellCommandExecutor(shellCmd);
        Thread shellThread1 = new Thread(){

            @Override
            public void run() {
                try {
                    shexc1.execute();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread shellThread2 = new Thread(){

            @Override
            public void run() {
                try {
                    shexc2.execute();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        shellThread1.start();
        shellThread2.start();
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                return shexc1.getProcess() != null;
            }
        }, 10, 10000);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                return shexc2.getProcess() != null;
            }
        }, 10, 10000);
        Shell.destroyAllShellProcesses();
        shexc1.getProcess().waitFor();
        shexc2.getProcess().waitFor();
    }

    @Test
    public void testIsJavaVersionAtLeast() {
        TestShell.assertTrue((boolean)Shell.isJavaVersionAtLeast((int)8));
    }

    @Test
    public void testIsBashSupported() throws InterruptedIOException {
        Assume.assumeTrue((String)"Bash is not supported", (boolean)Shell.checkIsBashSupported());
    }

    private static class Command
    extends Shell {
        private int runCount = 0;

        private Command(long interval) {
            super(interval);
        }

        protected String[] getExecString() {
            String[] stringArray;
            if (WINDOWS) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "cmd.exe";
                stringArray2[1] = "/c";
                stringArray2[2] = "echo";
                stringArray = stringArray2;
                stringArray2[3] = "hello";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "echo";
                stringArray = stringArray3;
                stringArray3[1] = "hello";
            }
            return stringArray;
        }

        protected void parseExecResult(BufferedReader lines) throws IOException {
            ++this.runCount;
        }

        public int getRunCount() {
            return this.runCount;
        }
    }
}

