/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;

public abstract class HadoopTestBase
extends Assert {
    public static final String PROPERTY_TEST_DEFAULT_TIMEOUT = "test.default.timeout";
    public static final int TEST_DEFAULT_TIMEOUT_VALUE = 100000;
    @Rule
    public Timeout defaultTimeout = HadoopTestBase.retrieveTestTimeout();
    @Rule
    public TestName methodName = new TestName();

    public static Timeout retrieveTestTimeout() {
        int millis;
        String propval = System.getProperty(PROPERTY_TEST_DEFAULT_TIMEOUT, Integer.toString(100000));
        try {
            millis = Integer.parseInt(propval);
        }
        catch (NumberFormatException e) {
            millis = 100000;
        }
        return new Timeout((long)millis, TimeUnit.MILLISECONDS);
    }

    protected String getMethodName() {
        return this.methodName.getMethodName();
    }

    @BeforeClass
    public static void nameTestThread() {
        Thread.currentThread().setName("JUnit");
    }

    @Before
    public void nameThreadToMethod() {
        Thread.currentThread().setName("JUnit-" + this.getMethodName());
    }
}

