/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestArrayWritable {
    @Test
    public void testThrowUndefinedValueException() throws IOException {
        Text[] elements = new Text[]{new Text("zero"), new Text("one"), new Text("two")};
        TextArrayWritable sourceArray = new TextArrayWritable();
        sourceArray.set((Writable[])elements);
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        sourceArray.write((DataOutput)out);
        TextArrayWritable destArray = new TextArrayWritable();
        in.reset(out.getData(), out.getLength());
        destArray.readFields((DataInput)in);
        Writable[] destElements = destArray.get();
        Assert.assertTrue((destElements.length == elements.length ? 1 : 0) != 0);
        for (int i = 0; i < elements.length; ++i) {
            Assert.assertEquals((Object)destElements[i], (Object)elements[i]);
        }
    }

    @Test
    public void testArrayWritableToArray() {
        Text[] elements = new Text[]{new Text("zero"), new Text("one"), new Text("two")};
        TextArrayWritable arrayWritable = new TextArrayWritable();
        arrayWritable.set((Writable[])elements);
        Object array = arrayWritable.toArray();
        Assert.assertTrue((String)"TestArrayWritable testArrayWritableToArray error!!! ", (boolean)(array instanceof Text[]));
        Text[] destElements = (Text[])array;
        for (int i = 0; i < elements.length; ++i) {
            Assert.assertEquals((Object)destElements[i], (Object)elements[i]);
        }
    }

    @Test
    public void testNullArgument() {
        try {
            Class valueClass = null;
            new ArrayWritable(valueClass);
            Assert.fail((String)"testNullArgument error !!!");
        }
        catch (IllegalArgumentException valueClass) {
        }
        catch (Exception e) {
            Assert.fail((String)"testNullArgument error !!!");
        }
    }

    @Test
    public void testArrayWritableStringConstructor() {
        Object[] original = new String[]{"test1", "test2", "test3"};
        ArrayWritable arrayWritable = new ArrayWritable((String[])original);
        Assert.assertEquals((String)"testArrayWritableStringConstructor class error!!!", UTF8.class, (Object)arrayWritable.getValueClass());
        Assert.assertArrayEquals((String)"testArrayWritableStringConstructor toString error!!!", (Object[])original, (Object[])arrayWritable.toStrings());
    }

    static class TextArrayWritable
    extends ArrayWritable {
        public TextArrayWritable() {
            super(Text.class);
        }
    }
}

