/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHAAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(TestHAAdmin.class);
    private HAAdmin tool;
    private ByteArrayOutputStream errOutBytes = new ByteArrayOutputStream();
    private ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
    private String errOutput;
    private String output;

    @Before
    public void setup() throws IOException {
        this.tool = new HAAdmin(){

            protected HAServiceTarget resolveTarget(String target) {
                return new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, new InetSocketAddress("dummy", 12345));
            }
        };
        this.tool.setConf(new Configuration());
        this.tool.errOut = new PrintStream(this.errOutBytes);
        this.tool.out = new PrintStream(this.outBytes);
    }

    private void assertOutputContains(String string) {
        if (!this.errOutput.contains(string) && !this.output.contains(string)) {
            Assert.fail((String)("Expected output to contain '" + string + "' but err_output was:\n" + this.errOutput + "\n and output was: \n" + this.output));
        }
    }

    @Test
    public void testAdminUsage() throws Exception {
        Assert.assertEquals((Object)-1, (Object)this.runTool(new String[0]));
        this.assertOutputContains("Usage:");
        this.assertOutputContains("-transitionToActive");
        Assert.assertEquals((Object)-1, (Object)this.runTool("badCommand"));
        this.assertOutputContains("Bad command 'badCommand'");
        Assert.assertEquals((Object)-1, (Object)this.runTool("-badCommand"));
        this.assertOutputContains("badCommand: Unknown");
        Assert.assertEquals((Object)-1, (Object)this.runTool("-transitionToActive"));
        this.assertOutputContains("transitionToActive: incorrect number of arguments");
        Assert.assertEquals((Object)-1, (Object)this.runTool("-transitionToActive", "x", "y"));
        this.assertOutputContains("transitionToActive: incorrect number of arguments");
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover"));
        this.assertOutputContains("failover: incorrect arguments");
        this.assertOutputContains("failover: incorrect arguments");
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "foo:1234"));
        this.assertOutputContains("failover: incorrect arguments");
    }

    @Test
    public void testHelp() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-help"));
        Assert.assertEquals((Object)0, (Object)this.runTool("-help", "transitionToActive"));
        this.assertOutputContains("Transitions the service into Active");
    }

    private Object runTool(String ... args) throws Exception {
        this.errOutBytes.reset();
        this.outBytes.reset();
        LOG.info("Running: HAAdmin " + Joiner.on((String)" ").join((Object[])args));
        int ret = this.tool.run(args);
        this.errOutput = new String(this.errOutBytes.toByteArray(), Charsets.UTF_8);
        this.output = new String(this.outBytes.toByteArray(), Charsets.UTF_8);
        LOG.info("Err_output:\n" + this.errOutput + "\nOutput:\n" + this.output);
        return ret;
    }
}

