/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.HttpFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpFileSystem {
    @Test
    public void testHttpFileSystem() throws IOException, URISyntaxException, InterruptedException {
        Configuration conf = new Configuration(false);
        conf.set("fs.http.impl", HttpFileSystem.class.getCanonicalName());
        String data = "foo";
        try (MockWebServer server = new MockWebServer();){
            server.enqueue(new MockResponse().setBody("foo"));
            server.start();
            URI uri = URI.create(String.format("http://%s:%d", server.getHostName(), server.getPort()));
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            try (FSDataInputStream is = fs.open(new Path(new URL(uri.toURL(), "/foo").toURI()), 4096);){
                byte[] buf = new byte["foo".length()];
                IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
                Assert.assertEquals((Object)"foo", (Object)new String(buf, StandardCharsets.UTF_8));
            }
            RecordedRequest req = server.takeRequest();
            Assert.assertEquals((Object)"/foo", (Object)req.getPath());
        }
    }
}

