/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.StatUtils;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRawLocalFileSystemContract
extends FileSystemContractBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestRawLocalFileSystemContract.class);
    private static final Path TEST_BASE_DIR = new Path(GenericTestUtils.getTempPath(""));

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)conf).getRawFileSystem();
    }

    @Override
    protected boolean renameSupported() {
        return false;
    }

    @Override
    protected boolean rootDirTestEnabled() {
        return false;
    }

    @Override
    public String getDefaultWorkingDirectory() {
        return this.fs.getWorkingDirectory().toUri().getPath();
    }

    @Override
    protected Path getTestBaseDir() {
        return TEST_BASE_DIR;
    }

    @Override
    protected boolean filesystemIsCaseSensitive() {
        return !Shell.WINDOWS && !Shell.MAC;
    }

    @Test
    public void testPermission() throws Exception {
        Assume.assumeTrue((String)"No native library", (boolean)NativeCodeLoader.isNativeCodeLoaded());
        Path testDir = this.getTestBaseDir();
        String testFilename = "teststat2File";
        Path path = new Path(testDir, testFilename);
        RawLocalFileSystem rfs = new RawLocalFileSystem();
        Configuration conf = new Configuration();
        rfs.initialize(rfs.getUri(), conf);
        rfs.createNewFile(path);
        File file = rfs.pathToFile(path);
        long defaultBlockSize = rfs.getDefaultBlockSize(path);
        RawLocalFileSystem.DeprecatedRawLocalFileStatus fsNIO = new RawLocalFileSystem.DeprecatedRawLocalFileStatus(file, defaultBlockSize, (FileSystem)rfs);
        fsNIO.loadPermissionInfoByNativeIO();
        RawLocalFileSystem.DeprecatedRawLocalFileStatus fsnonNIO = new RawLocalFileSystem.DeprecatedRawLocalFileStatus(file, defaultBlockSize, (FileSystem)rfs);
        fsnonNIO.loadPermissionInfoByNonNativeIO();
        Assert.assertEquals((Object)fsNIO.getOwner(), (Object)fsnonNIO.getOwner());
        Assert.assertEquals((Object)fsNIO.getGroup(), (Object)fsnonNIO.getGroup());
        Assert.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
        LOG.info("owner: {}, group: {}, permission: {}, isSticky: {}", new Object[]{fsNIO.getOwner(), fsNIO.getGroup(), fsNIO.getPermission(), fsNIO.getPermission().getStickyBit()});
        StatUtils.setPermissionFromProcess("644", file.getPath());
        fsNIO.loadPermissionInfoByNativeIO();
        fsnonNIO.loadPermissionInfoByNonNativeIO();
        Assert.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
        Assert.assertEquals((long)644L, (long)fsNIO.getPermission().toOctal());
        Assert.assertFalse((boolean)fsNIO.getPermission().getStickyBit());
        Assert.assertFalse((boolean)fsnonNIO.getPermission().getStickyBit());
        if (!Shell.WINDOWS) {
            StatUtils.setPermissionFromProcess("1644", file.getPath());
            fsNIO.loadPermissionInfoByNativeIO();
            fsnonNIO.loadPermissionInfoByNonNativeIO();
            Assert.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
            Assert.assertEquals((long)1644L, (long)fsNIO.getPermission().toOctal());
            Assert.assertEquals((Object)true, (Object)fsNIO.getPermission().getStickyBit());
            Assert.assertEquals((Object)true, (Object)fsnonNIO.getPermission().getStickyBit());
            StatUtils.setPermissionFromProcess("-t", file.getPath());
            fsNIO.loadPermissionInfoByNativeIO();
            fsnonNIO.loadPermissionInfoByNonNativeIO();
            Assert.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
            Assert.assertEquals((long)644L, (long)fsNIO.getPermission().toOctal());
            Assert.assertEquals((Object)false, (Object)fsNIO.getPermission().getStickyBit());
            Assert.assertEquals((Object)false, (Object)fsnonNIO.getPermission().getStickyBit());
        }
    }
}

