/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileContextMainOperationsBaseTest {
    protected static final Logger LOG = LoggerFactory.getLogger(FileContextMainOperationsBaseTest.class);
    private static String TEST_DIR_AAA2 = "test/hadoop2/aaa";
    private static String TEST_DIR_AAA = "test/hadoop/aaa";
    private static String TEST_DIR_AXA = "test/hadoop/axa";
    private static String TEST_DIR_AXX = "test/hadoop/axx";
    private static int numBlocks = 2;
    public Path localFsRootPath;
    protected final FileContextTestHelper fileContextTestHelper = this.createFileContextHelper();
    protected static FileContext fc;
    private static final PathFilter DEFAULT_FILTER;
    private static final PathFilter TEST_X_FILTER;
    private static final byte[] data;

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper();
    }

    @Before
    public void setUp() throws Exception {
        File testBuildData = GenericTestUtils.getRandomizedTestDir();
        Path rootPath = new Path(testBuildData.getAbsolutePath(), "root-uri");
        this.localFsRootPath = rootPath.makeQualified(LocalFileSystem.NAME, null);
        fc.mkdir(this.getTestRootPath(fc, "test"), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        if (fc != null) {
            Path testRoot = this.fileContextTestHelper.getAbsoluteTestRootPath(fc);
            LOG.info("Deleting test root path {}", (Object)testRoot);
            try {
                fc.delete(testRoot, true);
            }
            catch (Exception e) {
                LOG.error("Error when deleting test root path " + testRoot, (Throwable)e);
            }
            try {
                fc.delete(this.localFsRootPath, true);
            }
            catch (Exception e) {
                LOG.error("Error when deleting localFsRootPath " + this.localFsRootPath, (Throwable)e);
            }
        }
    }

    protected Path getDefaultWorkingDirectory() throws IOException {
        return this.getTestRootPath(fc, "/user/" + System.getProperty("user.name")).makeQualified(fc.getDefaultFileSystem().getUri(), fc.getWorkingDirectory());
    }

    protected boolean renameSupported() {
        return true;
    }

    protected IOException unwrapException(IOException e) {
        return e;
    }

    @Test
    public void testFsStatus() throws Exception {
        FsStatus fsStatus = fc.getFsStatus(null);
        Assert.assertNotNull((Object)fsStatus);
        Assert.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        Path workDir = new Path(this.fileContextTestHelper.getAbsoluteTestRootPath(fc), new Path("test"));
        fc.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fc.getWorkingDirectory());
        fc.setWorkingDirectory(new Path("."));
        Assert.assertEquals((Object)workDir, (Object)fc.getWorkingDirectory());
        fc.setWorkingDirectory(new Path(".."));
        Assert.assertEquals((Object)workDir.getParent(), (Object)fc.getWorkingDirectory());
        workDir = new Path(this.fileContextTestHelper.getAbsoluteTestRootPath(fc), new Path("test"));
        fc.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fc.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        fc.setWorkingDirectory(relativeDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fc.getWorkingDirectory());
        absoluteDir = this.getTestRootPath(fc, "test/existingDir2");
        fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        fc.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fc.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        fc.create(absolutePath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        fc.open(new Path("foo")).close();
        fc.mkdir(new Path("newDir"), FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, new Path(absoluteDir, "newDir")));
        absoluteDir = this.getTestRootPath(fc, "nonexistingPath");
        try {
            fc.setWorkingDirectory(absoluteDir);
            Assert.fail((String)"cd to non existing dir should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        absoluteDir = new Path(this.localFsRootPath, "existingDir");
        fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        fc.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fc.getWorkingDirectory());
        Path aRegularFile = new Path("aRegularFile");
        this.createFile(aRegularFile);
        try {
            fc.setWorkingDirectory(aRegularFile);
            Assert.fail((String)"An IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testDir = this.getTestRootPath(fc, "test/hadoop");
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, testDir));
        fc.mkdir(testDir, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, testDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, testDir));
        fc.mkdir(testDir, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, testDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, testDir));
        Path parentDir = testDir.getParent();
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, parentDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, parentDir));
        Path grandparentDir = parentDir.getParent();
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, grandparentDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, grandparentDir));
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.getTestRootPath(fc, "test/hadoop");
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDir));
        fc.mkdir(testDir, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, testDir));
        this.createFile(this.getTestRootPath(fc, "test/hadoop/file"));
        Path testSubDir = this.getTestRootPath(fc, "test/hadoop/file/subdir");
        try {
            fc.mkdir(testSubDir, FsPermission.getDefault(), true);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path testDeepSubDir = this.getTestRootPath(fc, "test/hadoop/file/deep/sub/dir");
        try {
            fc.mkdir(testDeepSubDir, FsPermission.getDefault(), true);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDeepSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fc.getFileStatus(this.getTestRootPath(fc, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fc.listStatus(this.getTestRootPath(fc, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, "test/hadoop/a"), this.getTestRootPath(fc, "test/hadoop/b"), this.getTestRootPath(fc, "test/hadoop/c/1")};
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDirs[0]));
        for (Path path : testDirs) {
            fc.mkdir(path, FsPermission.getDefault(), true);
        }
        FileStatus[] paths = fc.util().listStatus(this.getTestRootPath(fc, "test"));
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)this.getTestRootPath(fc, "test/hadoop"), (Object)paths[0].getPath());
        paths = fc.util().listStatus(this.getTestRootPath(fc, "test/hadoop"));
        Assert.assertEquals((long)3L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop/a"), paths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop/b"), paths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop/c"), paths));
        paths = fc.util().listStatus(this.getTestRootPath(fc, "test/hadoop/a"));
        Assert.assertEquals((long)0L, (long)paths.length);
        RemoteIterator pathsIterator = fc.listStatus(this.getTestRootPath(fc, "test"));
        Assert.assertEquals((Object)this.getTestRootPath(fc, "test/hadoop"), (Object)((FileStatus)pathsIterator.next()).getPath());
        Assert.assertFalse((boolean)pathsIterator.hasNext());
        pathsIterator = fc.listStatus(this.getTestRootPath(fc, "test/hadoop"));
        FileStatus[] subdirs = new FileStatus[3];
        int i = 0;
        while (i < 3 && pathsIterator.hasNext()) {
            subdirs[i++] = (FileStatus)pathsIterator.next();
        }
        Assert.assertFalse((boolean)pathsIterator.hasNext());
        Assert.assertTrue((i == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop/a"), subdirs));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop/b"), subdirs));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop/c"), subdirs));
        pathsIterator = fc.listStatus(this.getTestRootPath(fc, "test/hadoop/a"));
        Assert.assertFalse((boolean)pathsIterator.hasNext());
    }

    @Test
    public void testListFiles() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, "test/dir1"), this.getTestRootPath(fc, "test/dir1/dir1"), this.getTestRootPath(fc, "test/dir2")};
        Path[] testFiles = new Path[]{new Path(testDirs[0], "file1"), new Path(testDirs[0], "file2"), new Path(testDirs[1], "file2"), new Path(testDirs[2], "file1")};
        for (Path path : testDirs) {
            fc.mkdir(path, FsPermission.getDefault(), true);
        }
        for (Path p : testFiles) {
            FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
            out.writeByte(0);
            out.close();
        }
        RemoteIterator filesIterator = fc.util().listFiles(this.getTestRootPath(fc, "test"), true);
        LocatedFileStatus[] fileStats = new LocatedFileStatus[testFiles.length];
        for (int i = 0; i < fileStats.length; ++i) {
            Assert.assertTrue((boolean)filesIterator.hasNext());
            fileStats[i] = (LocatedFileStatus)filesIterator.next();
        }
        Assert.assertFalse((boolean)filesIterator.hasNext());
        for (Path p : testFiles) {
            Assert.assertTrue((boolean)this.containsPath(p, (FileStatus[])fileStats));
        }
    }

    @Test
    public void testListStatusFilterWithNoMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA2), this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().listStatus(this.getTestRootPath(fc, "test"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testListStatusFilterWithSomeMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().listStatus(this.getTestRootPath(fc, "test/hadoop"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusNonExistentFile() throws Exception {
        FileStatus[] paths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoopfsdf"));
        Assert.assertNull((Object)paths);
        paths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoopfsdf/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
        paths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoopfsdf/xyz*/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusWithNoMatchesInPath() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusSomeMatchesInDirectories() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop*"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop"), paths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, "test/hadoop2"), paths));
    }

    @Test
    public void testGlobStatusWithMultipleWildCardMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop*/*"));
        Assert.assertEquals((long)4L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AAA), paths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXX), paths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AAA2), paths));
    }

    @Test
    public void testGlobStatusWithMultipleMatchesOfSingleChar() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/ax?"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXX), paths));
    }

    @Test
    public void testGlobStatusFilterWithEmptyPathResults() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/?"), DEFAULT_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithSomePathMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/*"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultipleWildCardMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/a??"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathMatchesAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/*"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithNoMatchingPathsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/?"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathWildcardsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(fc, TEST_DIR_AAA), this.getTestRootPath(fc, TEST_DIR_AXA), this.getTestRootPath(fc, TEST_DIR_AXX), this.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(this.getTestRootPath(fc, "test/hadoop/a??"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(this.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    @Test
    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(FileContextTestHelper.getDefaultBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(FileContextTestHelper.getDefaultBlockSize());
    }

    @Test
    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        int blockSize = FileContextTestHelper.getDefaultBlockSize();
        this.writeReadAndDelete(blockSize + blockSize / 2);
    }

    @Test
    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(FileContextTestHelper.getDefaultBlockSize() * 2);
    }

    private void writeReadAndDelete(int len) throws IOException {
        Path path = this.getTestRootPath(fc, "test/hadoop/file");
        fc.mkdir(path.getParent(), FsPermission.getDefault(), true);
        FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.repFac((short)1), Options.CreateOpts.blockSize((long)FileContextTestHelper.getDefaultBlockSize())});
        out.write(data, 0, len);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileContextTestHelper.exists(fc, path));
        Assert.assertEquals((String)"Length", (long)len, (long)fc.getFileStatus(path).getLen());
        FSDataInputStream in = fc.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        Assert.assertEquals((long)len, (long)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)data[i], (long)buf[i]);
        }
        Assert.assertTrue((String)"Deleted", (boolean)fc.delete(path, false));
        Assert.assertFalse((String)"No longer exists", (boolean)FileContextTestHelper.exists(fc, path));
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testNullCreateFlag() throws IOException {
        Path p = this.getTestRootPath(fc, "test/file");
        fc.create(p, null, new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testEmptyCreateFlag() throws IOException {
        Path p = this.getTestRootPath(fc, "test/file");
        fc.create(p, EnumSet.noneOf(CreateFlag.class), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateFlagCreateExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testCreateFlagCreateExistingFile");
        this.createFile(p);
        fc.create(p, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=FileNotFoundException.class)
    public void testCreateFlagOverwriteNonExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testCreateFlagOverwriteNonExistingFile");
        fc.create(p, EnumSet.of(CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test
    public void testCreateFlagOverwriteExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testCreateFlagOverwriteExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, data.length);
    }

    @Test(expected=FileNotFoundException.class)
    public void testCreateFlagAppendNonExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testCreateFlagAppendNonExistingFile");
        fc.create(p, EnumSet.of(CreateFlag.APPEND), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test
    public void testCreateFlagAppendExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testCreateFlagAppendExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.APPEND), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, 2 * data.length);
    }

    @Test
    public void testCreateFlagCreateAppendNonExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testCreateFlagCreateAppendNonExistingFile");
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, data.length);
    }

    @Test
    public void testCreateFlagCreateAppendExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testCreateFlagCreateAppendExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, 2 * data.length);
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testCreateFlagAppendOverwrite() throws IOException {
        Path p = this.getTestRootPath(fc, "test/nonExistent");
        fc.create(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testCreateFlagAppendCreateOverwrite() throws IOException {
        Path p = this.getTestRootPath(fc, "test/nonExistent");
        fc.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test
    public void testBuilderCreateNonExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testBuilderCreateNonExistingFile");
        FSDataOutputStream out = fc.create(p).build();
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, data.length);
    }

    @Test
    public void testBuilderCreateExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testBuilderCreateExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p).overwrite(true).build();
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, data.length);
    }

    @Test
    public void testBuilderCreateAppendNonExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testBuilderCreateAppendNonExistingFile");
        FSDataOutputStream out = fc.create(p).append().build();
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, data.length);
    }

    @Test
    public void testBuilderCreateAppendExistingFile() throws IOException {
        Path p = this.getTestRootPath(fc, "test/testBuilderCreateAppendExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p).append().build();
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, 2 * data.length);
    }

    @Test
    public void testBuilderCreateRecursive() throws IOException {
        FSDataOutputStream out2;
        Path p = this.getTestRootPath(fc, "test/parent/no/exist/file1");
        try {
            out2 = fc.create(p).build();
            Throwable throwable = null;
            try {
                Assert.fail((String)"Should throw FileNotFoundException on non-exist directory");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out2 != null) {
                    if (throwable != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out2.close();
                    }
                }
            }
        }
        catch (FileNotFoundException out2) {
            // empty catch block
        }
        out2 = fc.create(p).recursive().build();
        FileContextMainOperationsBaseTest.writeData(fc, p, out2, data, data.length);
    }

    private static void writeData(FileContext fc, Path p, FSDataOutputStream out, byte[] data, long expectedLen) throws IOException {
        out.write(data, 0, data.length);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileContextTestHelper.exists(fc, p));
        Assert.assertEquals((String)"Length", (long)expectedLen, (long)fc.getFileStatus(p).getLen());
    }

    @Test
    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = this.getTestRootPath(fc, "test/hadoop/file");
        Assert.assertFalse((String)"Parent doesn't exist", (boolean)FileContextTestHelper.exists(fc, path.getParent()));
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FileContextTestHelper.exists(fc, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fc.getFileStatus(path).getLen());
        Assert.assertTrue((String)"Parent exists", (boolean)FileContextTestHelper.exists(fc, path.getParent()));
    }

    @Test
    public void testDeleteNonExistentFile() throws IOException {
        Path path = this.getTestRootPath(fc, "test/hadoop/file");
        Assert.assertFalse((String)"Doesn't exist", (boolean)FileContextTestHelper.exists(fc, path));
        Assert.assertFalse((String)"No deletion", (boolean)fc.delete(path, true));
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        Path dir = this.getTestRootPath(fc, "test/hadoop");
        Path file = this.getTestRootPath(fc, "test/hadoop/file");
        Path subdir = this.getTestRootPath(fc, "test/hadoop/subdir");
        this.createFile(file);
        fc.mkdir(subdir, FsPermission.getDefault(), true);
        Assert.assertTrue((String)"File exists", (boolean)FileContextTestHelper.exists(fc, file));
        Assert.assertTrue((String)"Dir exists", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertTrue((String)"Subdir exists", (boolean)FileContextTestHelper.exists(fc, subdir));
        try {
            fc.delete(dir, false);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"File still exists", (boolean)FileContextTestHelper.exists(fc, file));
        Assert.assertTrue((String)"Dir still exists", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertTrue((String)"Subdir still exists", (boolean)FileContextTestHelper.exists(fc, subdir));
        Assert.assertTrue((String)"Deleted", (boolean)fc.delete(dir, true));
        Assert.assertFalse((String)"File doesn't exist", (boolean)FileContextTestHelper.exists(fc, file));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertFalse((String)"Subdir doesn't exist", (boolean)FileContextTestHelper.exists(fc, subdir));
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = this.getTestRootPath(fc, "test/hadoop");
        fc.mkdir(dir, FsPermission.getDefault(), true);
        Assert.assertTrue((String)"Dir exists", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertTrue((String)"Deleted", (boolean)fc.delete(dir, false));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileContextTestHelper.exists(fc, dir));
    }

    @Test
    public void testRenameNonExistentPath() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/nonExistent");
        Path dst = this.getTestRootPath(fc, "test/new/newpath");
        try {
            this.rename(src, dst, false, false, Options.Rename.NONE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(fc, "test/nonExistent/newfile");
        try {
            this.rename(src, dst, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToDestinationWithParentFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(fc, "test/parentFile/newfile");
        this.createFile(dst.getParent());
        try {
            this.rename(src, dst, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.rename(src, dst, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileToExistingParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(fc, "test/new/newfile");
        fc.mkdir(dst.getParent(), FileContext.DEFAULT_PERM, true);
        this.rename(src, dst, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        try {
            this.rename(src, src, true, true, Options.Rename.NONE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
    }

    @Test
    public void testRenameFileAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(fc, "test/new/existingFile");
        this.createFile(dst);
        try {
            this.rename(src, dst, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(fc, "test/new/existingDir");
        fc.mkdir(dst, FileContext.DEFAULT_PERM, true);
        try {
            this.rename(src, dst, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.rename(src, dst, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        try {
            this.rename(src, src, true, true, Options.Rename.NONE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
    }

    @Test
    public void testRenameDirectoryToNonExistentParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        Path dst = this.getTestRootPath(fc, "test/nonExistent/newdir");
        try {
            this.rename(src, dst, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameDirectoryAsNonExistentDirectory() throws Exception {
        this.testRenameDirectoryAsNonExistentDirectory(Options.Rename.NONE);
        this.tearDown();
        this.testRenameDirectoryAsNonExistentDirectory(Options.Rename.OVERWRITE);
    }

    private void testRenameDirectoryAsNonExistentDirectory(Options.Rename ... options) throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        this.createFile(this.getTestRootPath(fc, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(fc, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(fc, "test/new/newdir");
        fc.mkdir(dst.getParent(), FileContext.DEFAULT_PERM, true);
        this.rename(src, dst, false, true, options);
        Assert.assertFalse((String)"Nested file1 exists", (boolean)FileContextTestHelper.exists(fc, this.getTestRootPath(fc, "test/hadoop/dir/file1")));
        Assert.assertFalse((String)"Nested file2 exists", (boolean)FileContextTestHelper.exists(fc, this.getTestRootPath(fc, "test/hadoop/dir/subdir/file2")));
        Assert.assertTrue((String)"Renamed nested file1 exists", (boolean)FileContextTestHelper.exists(fc, this.getTestRootPath(fc, "test/new/newdir/file1")));
        Assert.assertTrue((String)"Renamed nested exists", (boolean)FileContextTestHelper.exists(fc, this.getTestRootPath(fc, "test/new/newdir/subdir/file2")));
    }

    @Test
    public void testRenameDirectoryAsEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        this.createFile(this.getTestRootPath(fc, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(fc, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(fc, "test/new/newdir");
        fc.mkdir(dst, FileContext.DEFAULT_PERM, true);
        try {
            this.rename(src, dst, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameDirectoryAsNonEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        this.createFile(this.getTestRootPath(fc, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(fc, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(fc, "test/new/newdir");
        fc.mkdir(dst, FileContext.DEFAULT_PERM, true);
        this.createFile(this.getTestRootPath(fc, "test/new/newdir/file1"));
        try {
            this.rename(src, dst, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, dst, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryAsFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        Path dst = this.getTestRootPath(fc, "test/new/newfile");
        this.createFile(dst);
        try {
            this.rename(src, dst, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.rename(src, dst, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInputStreamClosedTwice() throws IOException {
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = fc.open(src);
        in.close();
        in.close();
    }

    @Test
    public void testOutputStreamClosedTwice() throws IOException {
        Path src = this.getTestRootPath(fc, "test/hadoop/file");
        FSDataOutputStream out = fc.create(src, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.writeChar(72);
        out.close();
        out.close();
    }

    @Test
    public void testUnsupportedSymlink() throws IOException {
        Path file = this.getTestRootPath(fc, "file");
        Path link = this.getTestRootPath(fc, "linkToFile");
        if (!fc.getDefaultFileSystem().supportsSymlinks()) {
            try {
                fc.createSymlink(file, link, false);
                Assert.fail((String)"Created a symlink on a file system that does not support symlinks.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.createFile(file);
            try {
                fc.getLinkTarget(file);
                Assert.fail((String)"Got a link target on a file system that does not support symlinks.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Assert.assertEquals((Object)fc.getFileStatus(file), (Object)fc.getFileLinkStatus(file));
        }
    }

    protected void createFile(Path path) throws IOException {
        FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.write(data, 0, data.length);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rename(Path src, Path dst, boolean srcExists, boolean dstExists, Options.Rename ... options) throws IOException {
        try {
            fc.rename(src, dst, options);
        }
        finally {
            Assert.assertEquals((String)"Source exists", (Object)srcExists, (Object)FileContextTestHelper.exists(fc, src));
            Assert.assertEquals((String)"Destination exists", (Object)dstExists, (Object)FileContextTestHelper.exists(fc, dst));
        }
    }

    private boolean containsPath(Path path, FileStatus[] filteredPaths) throws IOException {
        for (int i = 0; i < filteredPaths.length; ++i) {
            if (!this.getTestRootPath(fc, path.toString()).equals((Object)filteredPaths[i].getPath())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testOpen2() throws IOException {
        Path rootPath = this.getTestRootPath(fc, "test");
        Path path = new Path(rootPath, "zoo");
        this.createFile(path);
        long length = fc.getFileStatus(path).getLen();
        try (FSDataInputStream fsdis = fc.open(path, 2048);){
            byte[] bb = new byte[(int)length];
            fsdis.readFully(bb);
            Assert.assertArrayEquals((byte[])data, (byte[])bb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetVerifyChecksum() throws IOException {
        Path rootPath = this.getTestRootPath(fc, "test");
        Path path = new Path(rootPath, "zoo");
        try (FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});){
            fc.setVerifyChecksum(true, path);
            out.write(data, 0, data.length);
        }
        FileStatus fileStatus = fc.getFileStatus(path);
        long len = fileStatus.getLen();
        Assert.assertTrue((len == (long)data.length ? 1 : 0) != 0);
        byte[] bb = new byte[(int)len];
        try (FSDataInputStream fsdis = fc.open(path);){
            fsdis.readFully(bb);
        }
        Assert.assertArrayEquals((byte[])data, (byte[])bb);
    }

    @Test
    public void testListCorruptFileBlocks() throws IOException {
        block7: {
            Path rootPath = this.getTestRootPath(fc, "test");
            Path path = new Path(rootPath, "zoo");
            this.createFile(path);
            try {
                RemoteIterator remoteIterator = fc.listCorruptFileBlocks(path);
                if (this.listCorruptedBlocksSupported()) {
                    Assert.assertTrue((remoteIterator != null ? 1 : 0) != 0);
                    while (remoteIterator.hasNext()) {
                        Path p = (Path)remoteIterator.next();
                        System.out.println("corrupted block: " + p);
                    }
                    try {
                        remoteIterator.next();
                        Assert.fail();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else {
                    Assert.fail();
                }
            }
            catch (UnsupportedOperationException uoe) {
                if (!this.listCorruptedBlocksSupported()) break block7;
                Assert.fail((String)uoe.toString());
            }
        }
    }

    protected abstract boolean listCorruptedBlocksSupported();

    @Test
    public void testDeleteOnExitUnexisting() throws IOException {
        Path rootPath = this.getTestRootPath(fc, "test");
        Path path = new Path(rootPath, "zoo");
        boolean registered = fc.deleteOnExit(path);
        Assert.assertTrue((!registered ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileContextStatistics() throws IOException {
        FileContext.clearStatistics();
        Path rootPath = this.getTestRootPath(fc, "test");
        Path path = new Path(rootPath, "zoo");
        this.createFile(path);
        byte[] bb = new byte[data.length];
        try (FSDataInputStream fsdis = fc.open(path);){
            fsdis.readFully(bb);
        }
        Assert.assertArrayEquals((byte[])data, (byte[])bb);
        FileContext.printStatistics();
    }

    @Test
    public void testGetFileContext1() throws IOException {
        Path rootPath = this.getTestRootPath(fc, "test");
        AbstractFileSystem asf = fc.getDefaultFileSystem();
        FileContext fc2 = FileContext.getFileContext((AbstractFileSystem)asf);
        Path path = new Path(rootPath, "zoo");
        FSDataOutputStream out = fc2.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.close();
        Path pathResolved = fc2.resolvePath(path);
        Assert.assertEquals((Object)pathResolved.toUri().getPath(), (Object)path.toUri().getPath());
    }

    private Path getTestRootPath(FileContext fc, String pathString) {
        return this.fileContextTestHelper.getTestRootPath(fc, pathString);
    }

    protected Path path(String filepath) throws IOException {
        return this.getTestRootPath(fc, filepath);
    }

    protected void describe(String text) {
        LOG.info(text);
    }

    @Test
    public void testOpenFileRead() throws Exception {
        Path path = this.path("testOpenFileRead");
        this.createFile(path);
        long length = fc.getFileStatus(path).getLen();
        try (FSDataInputStream fsdis = (FSDataInputStream)((FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)fc.openFile(path).opt("fs.test.something", true)).opt("fs.test.something2", 3)).opt("fs.test.something3", "3")).build().get();){
            byte[] bb = new byte[(int)length];
            fsdis.readFully(bb);
            Assert.assertArrayEquals((byte[])data, (byte[])bb);
        }
    }

    @Test
    public void testOpenFileUnknownOption() throws Throwable {
        this.describe("calling openFile fails when a 'must()' option is unknown");
        Path path = this.path("testOpenFileUnknownOption");
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)fc.openFile(path).opt("fs.test.something", true)).must("fs.test.something", true);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> builder.build());
    }

    @Test
    public void testOpenFileLazyFail() throws Throwable {
        this.describe("openFile fails on a missing file in the get() and not before");
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)fc.openFile(this.path("testOpenFileUnknownOption")).opt("fs.test.something", true);
        LambdaTestUtils.interceptFuture(FileNotFoundException.class, "", builder.build());
    }

    @Test
    public void testOpenFileApplyRead() throws Throwable {
        this.describe("use the apply sequence");
        Path path = this.path("testOpenFileApplyRead");
        this.createFile(path);
        CompletionStage readAllBytes = fc.openFile(path).build().thenApply(ContractTestUtils::readStream);
        Assert.assertEquals((String)"Wrong number of bytes read from stream", (long)data.length, (long)((Long)((CompletableFuture)readAllBytes).get()));
    }

    @Test
    public void testOpenFileApplyAsyncRead() throws Throwable {
        this.describe("verify that async accept callbacks are evaluated");
        Path path = this.path("testOpenFileApplyAsyncRead");
        this.createFile(path);
        CompletableFuture future = fc.openFile(path).build();
        AtomicBoolean accepted = new AtomicBoolean(false);
        ((CompletableFuture)future.thenAcceptAsync(i -> accepted.set(true))).get();
        Assert.assertTrue((String)"async accept operation not invoked", (boolean)accepted.get());
    }

    static {
        DEFAULT_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return true;
            }
        };
        TEST_X_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return file.getName().contains("x") || file.getName().contains("X");
            }
        };
        data = FileContextTestHelper.getFileData(numBlocks, FileContextTestHelper.getDefaultBlockSize());
    }
}

