/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.fs.FSWrapper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.test.GenericTestUtils;

public abstract class FSTestWrapper
implements FSWrapper {
    protected static final int DEFAULT_BLOCK_SIZE = 1024;
    protected static final int DEFAULT_NUM_BLOCKS = 2;
    protected String testRootDir = null;
    protected String absTestRootDir = null;

    public FSTestWrapper(String testRootDir) {
        if (testRootDir == null || testRootDir.isEmpty()) {
            testRootDir = GenericTestUtils.getTestDir().getAbsolutePath();
        }
        this.testRootDir = testRootDir + "/" + RandomStringUtils.randomAlphanumeric((int)10);
    }

    public static byte[] getFileData(int numOfBlocks, long blockSize) {
        byte[] data = new byte[(int)((long)numOfBlocks * blockSize)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 10);
        }
        return data;
    }

    public Path getTestRootPath() {
        return this.makeQualified(new Path(this.testRootDir));
    }

    public Path getTestRootPath(String pathString) {
        return this.makeQualified(new Path(this.testRootDir, pathString));
    }

    public String getAbsoluteTestRootDir() throws IOException {
        if (this.absTestRootDir == null) {
            Path testRootPath = new Path(this.testRootDir);
            this.absTestRootDir = testRootPath.isAbsolute() ? this.testRootDir : this.getWorkingDirectory().toString() + "/" + this.testRootDir;
        }
        return this.absTestRootDir;
    }

    public Path getAbsoluteTestRootPath() throws IOException {
        return this.makeQualified(new Path(this.getAbsoluteTestRootDir()));
    }

    public abstract FSTestWrapper getLocalFSWrapper() throws UnsupportedFileSystemException, IOException;

    public abstract Path getDefaultWorkingDirectory() throws IOException;

    public abstract long createFile(Path var1, int var2, Options.CreateOpts ... var3) throws IOException;

    public abstract long createFile(Path var1, int var2, int var3) throws IOException;

    public abstract long createFile(Path var1) throws IOException;

    public abstract long createFile(String var1) throws IOException;

    public abstract long createFileNonRecursive(String var1) throws IOException;

    public abstract long createFileNonRecursive(Path var1) throws IOException;

    public abstract void appendToFile(Path var1, int var2, Options.CreateOpts ... var3) throws IOException;

    public abstract boolean exists(Path var1) throws IOException;

    public abstract boolean isFile(Path var1) throws IOException;

    public abstract boolean isDir(Path var1) throws IOException;

    public abstract boolean isSymlink(Path var1) throws IOException;

    public abstract void writeFile(Path var1, byte[] var2) throws IOException;

    public abstract byte[] readFile(Path var1, int var2) throws IOException;

    public abstract FileStatus containsPath(Path var1, FileStatus[] var2) throws IOException;

    public abstract FileStatus containsPath(String var1, FileStatus[] var2) throws IOException;

    public abstract void checkFileStatus(String var1, fileType var2) throws IOException;

    public abstract void checkFileLinkStatus(String var1, fileType var2) throws IOException;

    static enum fileType {
        isDir,
        isFile,
        isSymlink;

    }
}

