/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.RangerAdminRESTClient;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.audit.provider.StandAloneAuditProviderFactory;
import org.apache.ranger.authorization.hadoop.config.RangerAuditConfig;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptExecutionContext;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerAuthContextListener;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.PolicyRefresher;
import org.apache.ranger.plugin.util.RangerPolicyDeltaUtil;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerBasePlugin {
    private static final Log LOG = LogFactory.getLog(RangerBasePlugin.class);
    private static volatile RangerBasePlugin sInstance = null;
    private final RangerPluginConfig pluginConfig;
    private final RangerPluginContext pluginContext;
    private final Map<String, LogHistory> logHistoryList = new Hashtable<String, LogHistory>();
    private final int logInterval = 30000;
    private final DownloadTrigger accessTrigger = new DownloadTrigger();
    private PolicyRefresher refresher;
    private RangerPolicyEngine policyEngine;
    private RangerAuthContext currentAuthContext;
    private RangerAccessResultProcessor resultProcessor;
    private RangerRoles roles;
    private Set<String> superUsers = Collections.emptySet();
    private Set<String> superGroups = Collections.emptySet();

    public RangerBasePlugin(String serviceType, String appId) {
        this(new RangerPluginConfig(serviceType, null, appId, null, null, null));
    }

    public RangerBasePlugin(String serviceType, String serviceName, String appId) {
        this(new RangerPluginConfig(serviceType, serviceName, appId, null, null, null));
    }

    public RangerBasePlugin(RangerPluginConfig pluginConfig) {
        sInstance = this;
        this.pluginConfig = pluginConfig;
        this.pluginContext = new RangerPluginContext(pluginConfig);
        RangerScriptExecutionContext.init(pluginConfig);
    }

    @Deprecated
    public static RangerBasePlugin getInstance() {
        return sInstance;
    }

    public static AuditHandler getAuditProvider(String serviceName) {
        AuditProviderFactory providerFactory = RangerBasePlugin.getAuditProviderFactory(serviceName);
        AuditHandler ret = providerFactory.getAuditProvider();
        return ret;
    }

    public String getServiceType() {
        return this.pluginConfig.getServiceType();
    }

    public String getAppId() {
        return this.pluginConfig.getAppId();
    }

    public RangerPluginConfig getConfig() {
        return this.pluginConfig;
    }

    public String getClusterName() {
        return this.pluginConfig.getClusterName();
    }

    public RangerAuthContext getCurrentRangerAuthContext() {
        return this.currentAuthContext;
    }

    public RangerAuthContext createRangerAuthContext() {
        return this.currentAuthContext;
    }

    public RangerRoles getRoles() {
        return this.roles;
    }

    public void setRoles(RangerRoles roles) {
        this.roles = roles;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.setRoles(roles);
        }
        this.pluginContext.notifyAuthContextChanged();
    }

    public void setSuperUsersAndGroups(Set<String> users, Set<String> groups) {
        this.superUsers = users == null ? Collections.emptySet() : users;
        this.superGroups = groups == null ? Collections.emptySet() : groups;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.setSuperUsersAndGroups(this.superUsers, this.superGroups);
        }
    }

    public RangerServiceDef getServiceDef() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        return policyEngine != null ? policyEngine.getServiceDef() : null;
    }

    public int getServiceDefId() {
        RangerServiceDef serviceDef = this.getServiceDef();
        return serviceDef != null && serviceDef.getId() != null ? serviceDef.getId().intValue() : -1;
    }

    public String getServiceName() {
        return this.pluginConfig.getServiceName();
    }

    public AuditProviderFactory getAuditProviderFactory() {
        return RangerBasePlugin.getAuditProviderFactory(this.getServiceName());
    }

    public void init() {
        this.cleanup();
        AuditProviderFactory providerFactory = AuditProviderFactory.getInstance();
        if (!providerFactory.isInitDone()) {
            if (this.pluginConfig.getProperties() != null) {
                providerFactory.init(this.pluginConfig.getProperties(), this.getAppId());
            } else {
                LOG.error((Object)"Audit subsystem is not initialized correctly. Please check audit configuration. ");
                LOG.error((Object)"No authorization audits will be generated. ");
            }
        }
        this.refresher = new PolicyRefresher(this);
        this.refresher.setDaemon(true);
        this.refresher.startRefresher();
    }

    public void setPolicies(ServicePolicies policies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> setPolicies(" + policies + ")"));
        }
        try {
            RangerPolicyEngine oldPolicyEngine = this.policyEngine;
            ServicePolicies servicePolicies = null;
            boolean isValid = true;
            boolean usePolicyDeltas = false;
            if (policies == null) {
                policies = this.getDefaultSvcPolicies();
                if (policies == null) {
                    LOG.error((Object)"Could not get default Service Policies");
                    isValid = false;
                }
            } else {
                Boolean hasPolicyDeltas = RangerPolicyDeltaUtil.hasPolicyDeltas(policies);
                if (hasPolicyDeltas == null) {
                    LOG.warn((Object)"Policies and policy-deltas are empty. Creating policy engine with no policies!!");
                } else if (hasPolicyDeltas.equals(Boolean.TRUE)) {
                    RangerPolicyEngineImpl policyEngine = (RangerPolicyEngineImpl)oldPolicyEngine;
                    servicePolicies = ServicePolicies.applyDelta(policies, policyEngine);
                    if (servicePolicies != null) {
                        usePolicyDeltas = true;
                    } else {
                        LOG.error((Object)("Could not apply deltas=" + Arrays.toString(policies.getPolicyDeltas().toArray())));
                        isValid = false;
                    }
                } else {
                    usePolicyDeltas = false;
                }
            }
            if (isValid) {
                RangerPolicyEngine newPolicyEngine = null;
                boolean isPolicyEngineShared = false;
                if (!usePolicyDeltas) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Creating engine from policies");
                    }
                    newPolicyEngine = new RangerPolicyEngineImpl(policies, this.pluginContext, this.roles, this.superUsers, this.superGroups);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"policy-deltas are not null");
                    }
                    if (CollectionUtils.isNotEmpty(policies.getPolicyDeltas()) || MapUtils.isNotEmpty(policies.getSecurityZones())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Non empty policy-deltas found. Cloning engine using policy-deltas");
                        }
                        if (oldPolicyEngine != null) {
                            RangerPolicyEngineImpl oldPolicyEngineImpl = (RangerPolicyEngineImpl)oldPolicyEngine;
                            newPolicyEngine = RangerPolicyEngineImpl.getPolicyEngine(oldPolicyEngineImpl, policies);
                        }
                        if (newPolicyEngine != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Applied policyDeltas=" + Arrays.toString(policies.getPolicyDeltas().toArray()) + ")"));
                            }
                            isPolicyEngineShared = true;
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Failed to apply policyDeltas=" + Arrays.toString(policies.getPolicyDeltas().toArray()) + "), Creating engine from policies"));
                                LOG.debug((Object)("Creating new engine from servicePolicies:[" + servicePolicies + "]"));
                            }
                            newPolicyEngine = new RangerPolicyEngineImpl(servicePolicies, this.pluginContext, this.roles, this.superUsers, this.superGroups);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Empty policy-deltas. No need to change policy engine");
                    }
                }
                if (newPolicyEngine != null) {
                    if (!isPolicyEngineShared) {
                        newPolicyEngine.setUseForwardedIPAddress(this.pluginConfig.isUseForwardedIPAddress());
                        newPolicyEngine.setTrustedProxyAddresses(this.pluginConfig.getTrustedProxyAddresses());
                    }
                    this.policyEngine = newPolicyEngine;
                    this.currentAuthContext = this.pluginContext.getAuthContext();
                    this.pluginContext.notifyAuthContextChanged();
                    if (oldPolicyEngine != null) {
                        ((RangerPolicyEngineImpl)oldPolicyEngine).releaseResources();
                    }
                    if (this.refresher != null) {
                        this.refresher.saveToCache(usePolicyDeltas ? servicePolicies : policies);
                    }
                }
            } else {
                LOG.error((Object)"Returning without saving policies to cache. Leaving current policy engine as-is");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"setPolicies: policy engine initialization failed!  Leaving current policy engine as-is. Exception : ", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== setPolicies(" + policies + ")"));
        }
    }

    public void cleanup() {
        PolicyRefresher refresher = this.refresher;
        this.policyEngine = null;
        this.refresher = null;
        if (refresher != null) {
            refresher.stopRefresher();
        }
    }

    public void setResultProcessor(RangerAccessResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public RangerAccessResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request) {
        return this.isAccessAllowed(request, this.resultProcessor);
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests) {
        return this.isAccessAllowed(requests, this.resultProcessor);
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.evaluatePolicies(request, 0, resultProcessor);
        }
        return null;
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.evaluatePolicies(requests, 0, resultProcessor);
        }
        return null;
    }

    public RangerAccessResult evalDataMaskPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.evaluatePolicies(request, 1, resultProcessor);
        }
        return null;
    }

    public RangerAccessResult evalRowFilterPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.evaluatePolicies(request, 2, resultProcessor);
        }
        return null;
    }

    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getResourceAccessInfo(request);
        }
        return null;
    }

    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getResourceACLs(request);
        }
        return null;
    }

    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getRolesFromUserAndGroups(user, groups);
        }
        return null;
    }

    public RangerRole createRole(RangerRole request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.createRole(" + request + ")"));
        }
        RangerRole ret = this.getAdminClient().createRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.createRole(" + request + ")"));
        }
        return ret;
    }

    public void dropRole(String execUser, String roleName, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.dropRole(" + roleName + ")"));
        }
        this.getAdminClient().dropRole(execUser, roleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.dropRole(" + roleName + ")"));
        }
    }

    public List<String> getUserRoles(String execUser, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.getUserRoleNames(" + execUser + ")"));
        }
        List<String> ret = this.getAdminClient().getUserRoles(execUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.getUserRoleNames(" + execUser + ")"));
        }
        return ret;
    }

    public List<String> getAllRoles(String execUser, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerBasePlugin.getAllRoles()");
        }
        List<String> ret = this.getAdminClient().getAllRoles(execUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerBasePlugin.getAllRoles()");
        }
        return ret;
    }

    public RangerRole getRole(String execUser, String roleName, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.getPrincipalsForRole(" + roleName + ")"));
        }
        RangerRole ret = this.getAdminClient().getRole(execUser, roleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.getPrincipalsForRole(" + roleName + ")"));
        }
        return ret;
    }

    public void grantRole(GrantRevokeRoleRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.grantRole(" + request + ")"));
        }
        this.getAdminClient().grantRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.grantRole(" + request + ")"));
        }
    }

    public void revokeRole(GrantRevokeRoleRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.revokeRole(" + request + ")"));
        }
        this.getAdminClient().revokeRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.revokeRole(" + request + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.grantAccess(" + request + ")"));
        }
        boolean isSuccess = false;
        try {
            RangerPolicyEngine policyEngine = this.policyEngine;
            if (policyEngine != null) {
                request.setZoneName(policyEngine.getMatchedZoneName(request));
            }
            this.getAdminClient().grantAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "grant", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.grantAccess(" + request + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.revokeAccess(" + request + ")"));
        }
        boolean isSuccess = false;
        try {
            RangerPolicyEngine policyEngine = this.policyEngine;
            if (policyEngine != null) {
                request.setZoneName(policyEngine.getMatchedZoneName(request));
            }
            this.getAdminClient().revokeAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "revoke", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.revokeAccess(" + request + ")"));
        }
    }

    public void registerAuthContextEventListener(RangerAuthContextListener authContextListener) {
        this.pluginContext.setAuthContextListener(authContextListener);
    }

    public static RangerAdminClient createAdminClient(RangerPluginConfig pluginConfig) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + ")"));
        }
        RangerAdminClient ret = null;
        String propertyName = pluginConfig.getPropertyPrefix() + ".policy.source.impl";
        String policySourceImpl = pluginConfig.get(propertyName);
        if (StringUtils.isEmpty((String)policySourceImpl)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Value for property[%s] was null or empty. Unexpected! Will use policy source of type[%s]", propertyName, RangerAdminRESTClient.class.getName()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Value for property[%s] was [%s].", propertyName, policySourceImpl));
            }
            try {
                Class<?> adminClass = Class.forName(policySourceImpl);
                ret = (RangerAdminClient)adminClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error((Object)("failed to instantiate policy source of type '" + policySourceImpl + "'. Will use policy source of type '" + RangerAdminRESTClient.class.getName() + "'"), (Throwable)excp);
            }
        }
        if (ret == null) {
            ret = new RangerAdminRESTClient();
        }
        ret.init(pluginConfig.getServiceName(), pluginConfig.getAppId(), pluginConfig.getPropertyPrefix(), pluginConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + "): policySourceImpl=" + policySourceImpl + ", client=" + ret));
        }
        return ret;
    }

    public void refreshPoliciesAndTags() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> refreshPoliciesAndTags()");
        }
        try {
            RangerTagEnricher tagEnricher;
            RangerPolicyEngine policyEngine = this.policyEngine;
            long oldPolicyVersion = policyEngine.getPolicyVersion();
            this.refresher.syncPoliciesWithAdmin(this.accessTrigger);
            policyEngine = this.policyEngine;
            long newPolicyVersion = policyEngine.getPolicyVersion();
            if (oldPolicyVersion == newPolicyVersion && (tagEnricher = this.getTagEnricher()) != null) {
                tagEnricher.syncTagsWithAdmin(this.accessTrigger);
            }
        }
        catch (InterruptedException exception) {
            LOG.error((Object)"Failed to update policy-engine, continuing to use old policy-engine and/or tags", (Throwable)exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)"<== refreshPoliciesAndTags()");
        }
    }

    private void auditGrantRevoke(GrantRevokeRequest request, String action, boolean isSuccess, RangerAccessResultProcessor resultProcessor) {
        if (request != null && resultProcessor != null) {
            RangerAccessRequestImpl accessRequest = new RangerAccessRequestImpl();
            accessRequest.setResource(new RangerAccessResourceImpl(StringUtil.toStringObjectMap(request.getResource())));
            accessRequest.setUser(request.getGrantor());
            accessRequest.setAccessType("_admin");
            accessRequest.setAction(action);
            accessRequest.setClientIPAddress(request.getClientIPAddress());
            accessRequest.setClientType(request.getClientType());
            accessRequest.setRequestData(request.getRequestData());
            accessRequest.setSessionId(request.getSessionId());
            RangerAccessResult accessResult = this.isAccessAllowed(accessRequest, null);
            if (accessResult != null && accessResult.getIsAudited()) {
                accessRequest.setAccessType(action);
                accessResult.setIsAllowed(isSuccess);
                if (!isSuccess) {
                    accessResult.setPolicyId(-1L);
                }
                resultProcessor.processResult(accessResult);
            }
        }
    }

    private RangerServiceDef getDefaultServiceDef() {
        RangerServiceDef ret = null;
        if (StringUtils.isNotBlank((String)this.getServiceType())) {
            try {
                ret = EmbeddedServiceDefsUtil.instance().getEmbeddedServiceDef(this.getServiceType());
            }
            catch (Exception exp) {
                LOG.error((Object)("Could not get embedded service-def for " + this.getServiceType()));
            }
        }
        return ret;
    }

    private ServicePolicies getDefaultSvcPolicies() {
        ServicePolicies ret = null;
        RangerServiceDef serviceDef = this.getServiceDef();
        if (serviceDef == null) {
            serviceDef = this.getDefaultServiceDef();
        }
        if (serviceDef != null) {
            ret = new ServicePolicies();
            ret.setServiceDef(serviceDef);
            ret.setServiceName(this.getServiceName());
            ret.setPolicies(new ArrayList<RangerPolicy>());
        }
        return ret;
    }

    public boolean logErrorMessage(String message) {
        LogHistory log = this.logHistoryList.get(message);
        if (log == null) {
            log = new LogHistory();
            this.logHistoryList.put(message, log);
        }
        if (System.currentTimeMillis() - log.lastLogTime > 30000L) {
            log.lastLogTime = System.currentTimeMillis();
            int counter = log.counter;
            log.counter = 0;
            if (counter > 0) {
                message = message + ". Messages suppressed before: " + counter;
            }
            LOG.error((Object)message);
            return true;
        }
        ++log.counter;
        return false;
    }

    private RangerTagEnricher getTagEnricher() {
        Map<RangerContextEnricher, Object> contextEnricherMap;
        RangerTagEnricher ret = null;
        RangerAuthContext authContext = this.getCurrentRangerAuthContext();
        if (authContext != null && MapUtils.isNotEmpty(contextEnricherMap = authContext.getRequestContextEnrichers())) {
            Set<RangerContextEnricher> contextEnrichers = contextEnricherMap.keySet();
            for (RangerContextEnricher enricher : contextEnrichers) {
                if (!(enricher instanceof RangerTagEnricher)) continue;
                ret = (RangerTagEnricher)enricher;
                break;
            }
        }
        return ret;
    }

    private RangerAdminClient getAdminClient() throws Exception {
        RangerAdminClient admin;
        PolicyRefresher refresher = this.refresher;
        RangerAdminClient rangerAdminClient = admin = refresher == null ? null : refresher.getRangerAdminClient();
        if (admin == null) {
            throw new Exception("ranger-admin client is null");
        }
        return admin;
    }

    private static AuditProviderFactory getAuditProviderFactory(String serviceName) {
        AuditProviderFactory ret = AuditProviderFactory.getInstance();
        if (!ret.isInitDone()) {
            RangerAuditConfig conf;
            LOG.warn((Object)("RangerBasePlugin.getAuditProviderFactory(serviceName=" + serviceName + "): audit not initialized yet. Will use stand-alone audit factory"));
            ret = StandAloneAuditProviderFactory.getInstance();
            if (!ret.isInitDone() && (conf = new RangerAuditConfig()).isInitSuccess()) {
                ret.init(conf.getProperties(), "StandAlone");
            }
        }
        return ret;
    }

    private static final class LogHistory {
        long lastLogTime;
        int counter;

        private LogHistory() {
        }
    }
}

