/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.resourcematcher.RecursiveMatcher;

final class CaseInsensitiveURLRecursiveMatcher
extends RecursiveMatcher {
    CaseInsensitiveURLRecursiveMatcher(String value, char levelSeparatorChar) {
        super(value, levelSeparatorChar);
    }

    @Override
    boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
        String noSeparator;
        if (this.getNeedsDynamicEval()) {
            String expandedPolicyValue = this.getExpandedValue(evalContext);
            noSeparator = expandedPolicyValue != null ? this.getStringToCompare(expandedPolicyValue) : null;
        } else {
            if (this.valueWithoutSeparator == null && this.value != null) {
                this.valueWithoutSeparator = this.getStringToCompare(this.value);
                this.valueWithSeparator = this.valueWithoutSeparator + Character.toString(this.levelSeparatorChar);
            }
            noSeparator = this.valueWithoutSeparator;
        }
        boolean ret = StringUtils.equalsIgnoreCase((String)resourceValue, (String)noSeparator);
        if (!ret && noSeparator != null) {
            String withSeparator = this.getNeedsDynamicEval() ? noSeparator + Character.toString(this.levelSeparatorChar) : this.valueWithSeparator;
            ret = StringUtils.startsWithIgnoreCase((String)resourceValue, (String)withSeparator);
        }
        return ret;
    }

    @Override
    int getPriority() {
        return 8 + (this.getNeedsDynamicEval() ? 8 : 0);
    }
}

