/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.plugin.client.HadoopException;

public class HadoopConfigHolder {
    private static final Log LOG = LogFactory.getLog(HadoopConfigHolder.class);
    public static final String GLOBAL_LOGIN_PARAM_PROP_FILE = "hadoop-login.properties";
    public static final String DEFAULT_DATASOURCE_PARAM_PROP_FILE = "datasource.properties";
    public static final String RESOURCEMAP_PROP_FILE = "resourcenamemap.properties";
    public static final String DEFAULT_RESOURCE_NAME = "core-site.xml";
    public static final String RANGER_SECTION_NAME = "xalogin.xml";
    public static final String RANGER_LOGIN_USER_NAME_PROP = "username";
    public static final String RANGER_LOGIN_KEYTAB_FILE_PROP = "keytabfile";
    public static final String RANGER_LOGIN_PASSWORD = "password";
    public static final String RANGER_LOOKUP_PRINCIPAL = "lookupprincipal";
    public static final String RANGER_LOOKUP_KEYTAB = "lookupkeytab";
    public static final String RANGER_PRINCIPAL = "rangerprincipal";
    public static final String RANGER_KEYTAB = "rangerkeytab";
    public static final String RANGER_NAME_RULES = "namerules";
    public static final String RANGER_AUTH_TYPE = "authtype";
    public static final String HADOOP_SECURITY_AUTHENTICATION = "hadoop.security.authentication";
    public static final String HADOOP_NAME_RULES = "hadoop.security.auth_to_local";
    public static final String HADOOP_SECURITY_AUTHENTICATION_METHOD = "kerberos";
    public static final String HADOOP_RPC_PROTECTION = "hadoop.rpc.protection";
    public static final String ENABLE_HIVE_METASTORE_LOOKUP = "enable.hive.metastore.lookup";
    public static final String HIVE_SITE_FILE_PATH = "hive.site.file.path";
    private static boolean initialized;
    private static Map<String, HashMap<String, Properties>> dataSource2ResourceListMap;
    private static Map<String, HadoopConfigHolder> dataSource2HadoopConfigHolder;
    private static Properties globalLoginProp;
    private static Properties resourcemapProperties;
    private String datasourceName;
    private String defaultConfigFile;
    private String userName;
    private String keyTabFile;
    private String password;
    private String lookupPrincipal;
    private String lookupKeytab;
    private String nameRules;
    private String authType;
    private String hiveSiteFilePath;
    private boolean isKerberosAuth;
    private boolean enableHiveMetastoreLookup;
    private Map<String, String> connectionProperties;
    private static Set<String> rangerInternalPropertyKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HadoopConfigHolder getInstance(String aDatasourceName) {
        HadoopConfigHolder ret = dataSource2HadoopConfigHolder.get(aDatasourceName);
        if (ret != null) return ret;
        Class<HadoopConfigHolder> clazz = HadoopConfigHolder.class;
        synchronized (HadoopConfigHolder.class) {
            HadoopConfigHolder temp = ret;
            if (temp != null) return ret;
            ret = new HadoopConfigHolder(aDatasourceName);
            dataSource2HadoopConfigHolder.put(aDatasourceName, ret);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HadoopConfigHolder getInstance(String aDatasourceName, Map<String, String> connectionProperties, String defaultConfigFile) {
        HadoopConfigHolder ret = dataSource2HadoopConfigHolder.get(aDatasourceName);
        if (ret == null) {
            Class<HadoopConfigHolder> clazz = HadoopConfigHolder.class;
            synchronized (HadoopConfigHolder.class) {
                HadoopConfigHolder temp = ret;
                if (temp == null) {
                    ret = new HadoopConfigHolder(aDatasourceName, connectionProperties, defaultConfigFile);
                    dataSource2HadoopConfigHolder.put(aDatasourceName, ret);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else if (connectionProperties != null && !connectionProperties.equals(ret.connectionProperties)) {
            ret = new HadoopConfigHolder(aDatasourceName, connectionProperties);
            dataSource2HadoopConfigHolder.remove(aDatasourceName);
            dataSource2HadoopConfigHolder.put(aDatasourceName, ret);
        }
        return ret;
    }

    private HadoopConfigHolder(String aDatasourceName) {
        this.datasourceName = aDatasourceName;
        if (!initialized) {
            HadoopConfigHolder.init();
        }
        this.initLoginInfo();
    }

    private HadoopConfigHolder(String aDatasourceName, Map<String, String> connectionProperties) {
        this(aDatasourceName, connectionProperties, null);
    }

    private HadoopConfigHolder(String aDatasourceName, Map<String, String> connectionProperties, String defaultConfigFile) {
        this.datasourceName = aDatasourceName;
        this.connectionProperties = connectionProperties;
        this.defaultConfigFile = defaultConfigFile;
        this.initConnectionProp();
        this.initLoginInfo();
    }

    private void initConnectionProp() {
        if (!this.connectionProperties.containsKey(ENABLE_HIVE_METASTORE_LOOKUP)) {
            this.connectionProperties.put(ENABLE_HIVE_METASTORE_LOOKUP, "false");
        }
        if (!this.connectionProperties.containsKey(HIVE_SITE_FILE_PATH)) {
            this.connectionProperties.put(HIVE_SITE_FILE_PATH, "");
        }
        for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
            String key = entry.getKey();
            String resourceName = this.getResourceName(key);
            if (resourceName == null) {
                resourceName = RANGER_SECTION_NAME;
            }
            String val = entry.getValue();
            HadoopConfigHolder.addConfiguration(this.datasourceName, resourceName, key, val);
        }
    }

    private String getResourceName(String key) {
        if (resourcemapProperties == null) {
            HadoopConfigHolder.initResourceMap();
        }
        if (resourcemapProperties != null) {
            String rn = resourcemapProperties.getProperty(key);
            return rn != null ? rn : this.defaultConfigFile;
        }
        return this.defaultConfigFile;
    }

    private static void initResourceMap() {
        Properties props = new Properties();
        InputStream in = HadoopConfigHolder.class.getClassLoader().getResourceAsStream(RESOURCEMAP_PROP_FILE);
        if (in != null) {
            try {
                props.load(in);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String value = (String)entry.getValue();
                    if (!RANGER_SECTION_NAME.equals(value)) continue;
                    String key = (String)entry.getKey();
                    rangerInternalPropertyKeys.add(key);
                }
                resourcemapProperties = props;
            }
            catch (IOException e) {
                throw new HadoopException("Unable to load resource map properties from [resourcenamemap.properties]", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new HadoopException("Unable to locate resource map properties from [resourcenamemap.properties] in the class path.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void init() {
        block27: {
            if (initialized) {
                return;
            }
            try {
                InputStream in = HadoopConfigHolder.class.getClassLoader().getResourceAsStream(DEFAULT_DATASOURCE_PARAM_PROP_FILE);
                if (in != null) {
                    Properties prop = new Properties();
                    try {
                        prop.load(in);
                    }
                    catch (IOException e) {
                        throw new HadoopException("Unable to get configuration information for Hadoop environments", e);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (prop.isEmpty()) {
                        return;
                    }
                    for (Object keyobj : prop.keySet()) {
                        String key = (String)keyobj;
                        String val = prop.getProperty(key);
                        int dotLocatedAt = key.indexOf(".");
                        if (dotLocatedAt == -1) continue;
                        String dataSource = key.substring(0, dotLocatedAt);
                        String propKey = key.substring(dotLocatedAt + 1);
                        int resourceFoundAt = propKey.indexOf(".");
                        if (resourceFoundAt <= -1) continue;
                        String resourceName = propKey.substring(0, resourceFoundAt) + ".xml";
                        propKey = propKey.substring(resourceFoundAt + 1);
                        HadoopConfigHolder.addConfiguration(dataSource, resourceName, propKey, val);
                    }
                }
                if ((in = HadoopConfigHolder.class.getClassLoader().getResourceAsStream(GLOBAL_LOGIN_PARAM_PROP_FILE)) == null) break block27;
                Properties tempLoginProp = new Properties();
                try {
                    tempLoginProp.load(in);
                }
                catch (IOException e) {
                    throw new HadoopException("Unable to get login configuration information for Hadoop environments from file: [hadoop-login.properties]", e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                globalLoginProp = tempLoginProp;
            }
            finally {
                initialized = true;
            }
        }
    }

    private void initLoginInfo() {
        Properties prop = this.getRangerSection();
        if (prop != null) {
            this.userName = prop.getProperty(RANGER_LOGIN_USER_NAME_PROP);
            this.keyTabFile = prop.getProperty(RANGER_LOGIN_KEYTAB_FILE_PROP);
            if (StringUtils.trimToNull((String)prop.getProperty(ENABLE_HIVE_METASTORE_LOOKUP)) != null) {
                try {
                    this.enableHiveMetastoreLookup = Boolean.valueOf(prop.getProperty(ENABLE_HIVE_METASTORE_LOOKUP, "false").trim());
                }
                catch (Exception e) {
                    this.enableHiveMetastoreLookup = false;
                    LOG.error((Object)("Error while getting enable.hive.metastore.lookup : " + e.getMessage()));
                }
            }
            this.hiveSiteFilePath = StringUtils.trimToNull((String)prop.getProperty(HIVE_SITE_FILE_PATH)) != null ? prop.getProperty(HIVE_SITE_FILE_PATH).trim() : null;
            this.password = prop.getProperty(RANGER_LOGIN_PASSWORD);
            this.lookupPrincipal = prop.getProperty(RANGER_LOOKUP_PRINCIPAL);
            this.lookupKeytab = prop.getProperty(RANGER_LOOKUP_KEYTAB);
            this.nameRules = prop.getProperty(RANGER_NAME_RULES);
            this.authType = prop.getProperty(RANGER_AUTH_TYPE, "simple");
            String hadoopSecurityAuthentication = this.getHadoopSecurityAuthentication();
            this.isKerberosAuth = hadoopSecurityAuthentication != null ? HADOOP_SECURITY_AUTHENTICATION_METHOD.equalsIgnoreCase(hadoopSecurityAuthentication) : this.userName != null && this.userName.indexOf("@") > -1 || SecureClientLogin.isKerberosCredentialExists(this.lookupPrincipal, this.lookupKeytab);
        }
    }

    public Properties getRangerSection() {
        Properties prop = this.getProperties(RANGER_SECTION_NAME);
        if (prop == null) {
            prop = globalLoginProp;
        }
        return prop;
    }

    private static void addConfiguration(String dataSource, String resourceName, String propertyName, String value) {
        Properties prop;
        HashMap<String, Properties> resourceName2PropertiesMap;
        if (dataSource == null || dataSource.isEmpty()) {
            return;
        }
        if (propertyName == null || propertyName.isEmpty()) {
            return;
        }
        if (resourceName == null) {
            resourceName = DEFAULT_RESOURCE_NAME;
        }
        if ((resourceName2PropertiesMap = dataSource2ResourceListMap.get(dataSource)) == null) {
            resourceName2PropertiesMap = new HashMap();
            dataSource2ResourceListMap.put(dataSource, resourceName2PropertiesMap);
        }
        if ((prop = resourceName2PropertiesMap.get(resourceName)) == null) {
            prop = new Properties();
            resourceName2PropertiesMap.put(resourceName, prop);
        }
        if (value == null) {
            prop.remove(propertyName);
        } else {
            prop.put(propertyName, value);
        }
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public boolean hasResourceExists(String aResourceName) {
        HashMap<String, Properties> resourceName2PropertiesMap = dataSource2ResourceListMap.get(this.datasourceName);
        return resourceName2PropertiesMap != null && resourceName2PropertiesMap.containsKey(aResourceName);
    }

    public Properties getProperties(String aResourceName) {
        Properties ret = null;
        HashMap<String, Properties> resourceName2PropertiesMap = dataSource2ResourceListMap.get(this.datasourceName);
        if (resourceName2PropertiesMap != null) {
            ret = resourceName2PropertiesMap.get(aResourceName);
        }
        return ret;
    }

    public String getHadoopSecurityAuthentication() {
        String ret = null;
        String sectionName = RANGER_SECTION_NAME;
        if (this.defaultConfigFile != null) {
            sectionName = this.defaultConfigFile;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HadoopConfigHolder.getHadoopSecurityAuthentication(  DataSource : " + sectionName + " Property : " + HADOOP_SECURITY_AUTHENTICATION + ")"));
        }
        ret = this.getProperties(sectionName, HADOOP_SECURITY_AUTHENTICATION);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HadoopConfigHolder.getHadoopSecurityAuthentication( DataSource : " + sectionName + " Property : " + HADOOP_SECURITY_AUTHENTICATION + " Value : " + ret + ")"));
        }
        return ret;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getKeyTabFile() {
        return this.keyTabFile;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isKerberosAuthentication() {
        return this.isKerberosAuth;
    }

    public String getLookupPrincipal() {
        return this.lookupPrincipal;
    }

    public String getLookupKeytab() {
        return this.lookupKeytab;
    }

    public String getNameRules() {
        return this.nameRules;
    }

    public String getAuthType() {
        return this.authType;
    }

    public boolean isEnableHiveMetastoreLookup() {
        return this.enableHiveMetastoreLookup;
    }

    public String getHiveSiteFilePath() {
        return this.hiveSiteFilePath;
    }

    public Set<String> getRangerInternalPropertyKeys() {
        return rangerInternalPropertyKeys;
    }

    private String getProperties(String sectionName, String property) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HadoopConfigHolder.getProperties(  DataSource : " + sectionName + " Property : " + property + ")"));
        }
        Properties repoParam = null;
        String ret = null;
        HashMap<String, Properties> resourceName2PropertiesMap = dataSource2ResourceListMap.get(this.getDatasourceName());
        if (resourceName2PropertiesMap != null) {
            repoParam = resourceName2PropertiesMap.get(sectionName);
        }
        if (repoParam != null) {
            ret = (String)repoParam.get(property);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HadoopConfigHolder.getProperties(  DataSource : " + sectionName + " Property : " + property + " Value : " + ret));
        }
        return ret;
    }

    static {
        dataSource2ResourceListMap = new HashMap<String, HashMap<String, Properties>>();
        dataSource2HadoopConfigHolder = new HashMap<String, HadoopConfigHolder>();
        globalLoginProp = new Properties();
        rangerInternalPropertyKeys = new HashSet<String>();
    }
}

