/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.knox.token;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.knox.token.Token;

public class Get {

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) throws IOException {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private URI requestURI;
        private HttpGet httpRequest;

        Request(KnoxSession session) {
            this(session, null);
        }

        Request(KnoxSession session, String doAsUser) {
            super(session, doAsUser);
            try {
                URIBuilder uri = this.uri(Token.SERVICE_PATH);
                this.requestURI = uri.build();
            }
            catch (URISyntaxException e) {
                throw new KnoxShellException(e);
            }
        }

        public URI getRequestURI() {
            return this.requestURI;
        }

        public HttpGet getRequest() {
            return this.httpRequest;
        }

        @Override
        protected Callable<Response> callable() {
            return () -> {
                this.httpRequest = new HttpGet(this.requestURI);
                return new Response((HttpResponse)this.execute((HttpRequest)this.httpRequest));
            };
        }
    }
}

