/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.idbroker;

import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.knox.gateway.shell.AbstractCloudAccessBrokerRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.idbroker.Credentials;

public class Role {
    private static final String ROLE_CREDENTIALS_API_PATH = Credentials.SERVICE_PATH + "/role";

    static class Response
    extends BasicResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractCloudAccessBrokerRequest<Response> {
        private String roleid;

        Request(CloudAccessBrokerSession session) {
            super(session);
        }

        public Request roleid(String roleid) {
            this.roleid = roleid;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return () -> {
                URI uri = this.uri(ROLE_CREDENTIALS_API_PATH).build();
                if (!StringUtils.isBlank((CharSequence)this.roleid)) {
                    uri = this.uri(ROLE_CREDENTIALS_API_PATH + "/" + this.roleid).build();
                }
                HttpGet request = new HttpGet(uri);
                return new Response((HttpResponse)this.execute((HttpRequest)request));
            };
        }
    }
}

