/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.alias;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.alias.AbstractAliasRequest;
import org.apache.knox.gateway.shell.alias.AddAliasResponse;
import org.apache.knox.gateway.shell.alias.AliasResponse;

public class PostRequest
extends AbstractAliasRequest {
    static final String FORM_PARAM_VALUE = "value";
    private String alias;
    private String pwd;

    PostRequest(KnoxSession session, String alias, String pwd) {
        this(session, null, alias, pwd);
    }

    PostRequest(KnoxSession session, String clusterName, String alias, String pwd) {
        this(session, clusterName, alias, pwd, null);
    }

    PostRequest(KnoxSession session, String clusterName, String alias, String pwd, String doAsUser) {
        super(session, clusterName, doAsUser);
        this.alias = alias;
        this.pwd = pwd;
        this.requestURI = this.buildURI();
    }

    @Override
    protected AbstractAliasRequest.RequestType getRequestType() {
        return AbstractAliasRequest.RequestType.POST;
    }

    @Override
    protected List<String> getPathElements() {
        List<String> elements = super.getPathElements();
        elements.add("/");
        elements.add(this.alias);
        return elements;
    }

    @Override
    protected HttpRequestBase createRequest() {
        HttpRequestBase request = super.createRequest();
        ArrayList<BasicNameValuePair> formData = new ArrayList<BasicNameValuePair>();
        formData.add(new BasicNameValuePair(FORM_PARAM_VALUE, this.pwd));
        ((HttpPost)request).setEntity((HttpEntity)new UrlEncodedFormEntity(formData, StandardCharsets.UTF_8));
        return request;
    }

    @Override
    protected AliasResponse createResponse(HttpResponse response) {
        return new AddAliasResponse(response);
    }
}

