/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import groovy.ui.GroovyMain;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxSh;
import org.apache.knox.gateway.shell.hbase.HBase;
import org.apache.knox.gateway.shell.hdfs.Hdfs;
import org.apache.knox.gateway.shell.job.Job;
import org.apache.knox.gateway.shell.manager.Manager;
import org.apache.knox.gateway.shell.workflow.Workflow;
import org.apache.knox.gateway.shell.yarn.Yarn;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.groovy.tools.shell.AnsiDetector;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class Shell {
    private static final List<String> NON_INTERACTIVE_COMMANDS = Arrays.asList("buildTrustStore", "init", "list", "destroy");
    private static final String[] IMPORTS = new String[]{KnoxSession.class.getName(), HBase.class.getName(), Hdfs.class.getName(), Job.class.getName(), Workflow.class.getName(), Yarn.class.getName(), TimeUnit.class.getName(), Manager.class.getName()};

    public static void main(String ... args) throws Exception {
        PropertyConfigurator.configure((String)System.getProperty("log4j.configuration"));
        if (args.length > 0) {
            if (NON_INTERACTIVE_COMMANDS.contains(args[0])) {
                String[] arguments = new String[args.length == 1 ? 1 : 3];
                arguments[0] = args[0];
                if (args.length > 1) {
                    arguments[1] = "--gateway";
                    arguments[2] = args[1];
                }
                KnoxSh.main(arguments);
            } else {
                GroovyMain.main((String[])args);
            }
        } else {
            Groovysh shell = new Groovysh();
            for (String name : IMPORTS) {
                shell.execute("import " + name);
            }
            shell.run(null);
        }
    }

    static {
        AnsiConsole.systemInstall();
        Ansi.setDetector((Callable)new AnsiDetector());
        System.setProperty("groovysh.prompt", "knox");
    }
}

