/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.knox.gateway.shell.ClientContext;
import org.apache.knox.gateway.shell.KnoxSession;

public class CloudAccessBrokerSession
extends KnoxSession {
    private ClientContext clientContext;

    CloudAccessBrokerSession(ClientContext clientContext) throws URISyntaxException {
        super(clientContext);
        this.clientContext = clientContext;
    }

    public void updateEndpoint(String endpoint) throws Exception {
        this.base = endpoint;
        ClientContext updated = ClientContext.with(endpoint).connection().withTruststore(this.clientContext.connection().truststoreLocation(), this.clientContext.connection().truststorePass()).withPublicCertPem(this.clientContext.connection().endpointPublicCertPem()).end().kerberos().enable(this.clientContext.kerberos().enable()).debug(this.clientContext.kerberos().debug()).jaasConf(this.clientContext.kerberos().jaasConf()).krb5Conf(this.clientContext.kerberos().krb5Conf()).end();
        this.client = this.createClient(updated);
    }

    public static CloudAccessBrokerSession create(String url, Map<String, String> headers) throws URISyntaxException {
        CloudAccessBrokerSession instance = new CloudAccessBrokerSession(ClientContext.with(url));
        instance.setHeaders(headers);
        return instance;
    }

    public static CloudAccessBrokerSession create(String url, Map<String, String> headers, String truststoreLocation, String truststorePass) throws URISyntaxException {
        CloudAccessBrokerSession instance = new CloudAccessBrokerSession(ClientContext.with(url).connection().withTruststore(truststoreLocation, truststorePass).end());
        instance.setHeaders(headers);
        return instance;
    }

    public static CloudAccessBrokerSession create(String url, String username, String password) throws URISyntaxException {
        return new CloudAccessBrokerSession(ClientContext.with(username, password, url));
    }

    public static CloudAccessBrokerSession create(String url, String username, String password, String truststoreLocation, String truststorePass) throws URISyntaxException {
        return new CloudAccessBrokerSession(ClientContext.with(username, password, url).connection().withTruststore(truststoreLocation, truststorePass).end());
    }

    public static CloudAccessBrokerSession create(ClientContext context) throws URISyntaxException {
        return new CloudAccessBrokerSession(context);
    }
}

