/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.s3a;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.HttpResponse;
import org.apache.knox.gateway.cloud.idbroker.AbstractIDBClient;
import org.apache.knox.gateway.cloud.idbroker.common.DefaultEndpointManager;
import org.apache.knox.gateway.cloud.idbroker.common.DefaultRequestExecutor;
import org.apache.knox.gateway.cloud.idbroker.s3a.AuthResponseAWSMessage;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBProperty;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3AIDBClient
extends AbstractIDBClient<MarshalledCredentials> {
    private static final Logger LOG = LoggerFactory.getLogger(S3AIDBClient.class);
    private final S3AFileSystem fs;

    public static S3AIDBClient createFullIDBClient(Configuration conf, UserGroupInformation owner, S3AFileSystem fs) throws IOException {
        return new S3AIDBClient(conf, owner, fs);
    }

    public static S3AIDBClient createLightIDBClient(Configuration conf, S3AFileSystem fs) throws IOException {
        S3AIDBClient client = new S3AIDBClient(conf, fs.getOwner(), fs);
        DefaultEndpointManager em = new DefaultEndpointManager(Arrays.asList(conf.get(S3AIDBProperty.IDBROKER_GATEWAY.getPropertyName(), S3AIDBProperty.IDBROKER_GATEWAY.getDefaultValue())));
        client.requestExecutor = new DefaultRequestExecutor(em);
        return client;
    }

    S3AIDBClient(Configuration conf, UserGroupInformation owner, S3AFileSystem fs) throws IOException {
        super(conf, owner);
        this.fs = fs;
    }

    @Override
    protected boolean getOnlyUser(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, S3AIDBProperty.IDBROKER_ONLY_USER_METHOD);
    }

    @Override
    protected boolean getOnlyGroups(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, S3AIDBProperty.IDBROKER_ONLY_GROUPS_METHOD);
    }

    @Override
    protected String getSpecificRole(Configuration configuration) {
        return this.getPropertyValue(configuration, S3AIDBProperty.IDBROKER_SPECIFIC_ROLE_METHOD);
    }

    @Override
    protected String getSpecificGroup(Configuration configuration) {
        return this.getPropertyValue(configuration, S3AIDBProperty.IDBROKER_SPECIFIC_GROUP_METHOD);
    }

    @Override
    protected String getTruststorePath(Configuration configuration) {
        return this.getPropertyValue(configuration, S3AIDBProperty.IDBROKER_TRUSTSTORE_LOCATION);
    }

    @Override
    protected boolean getUseCertificateFromDT(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, S3AIDBProperty.IDBROKER_USE_DT_CERT);
    }

    @Override
    protected char[] getTruststorePassword(Configuration configuration) throws IOException {
        char[] password = configuration.getPassword(S3AIDBProperty.IDBROKER_TRUSTSTORE_PASS.getPropertyName());
        if (password == null) {
            password = configuration.getPassword(S3AIDBProperty.IDBROKER_TRUSTSTORE_PASSWORD.getPropertyName());
        }
        return password;
    }

    @Override
    protected String getDelegationTokensURL(Configuration configuration) {
        return this.buildUrl(this.getGatewayAddress(), this.getPropertyValue(configuration, S3AIDBProperty.IDBROKER_DT_PATH));
    }

    @Override
    protected String getCredentialsURL(Configuration configuration) {
        return this.buildUrl(this.getGatewayAddress(), this.getPropertyValue(configuration, S3AIDBProperty.IDBROKER_PATH));
    }

    @Override
    protected String getCredentialsType(Configuration configuration) {
        return this.getPropertyValue(configuration, S3AIDBProperty.IDBROKER_CREDENTIALS_TYPE);
    }

    @Override
    protected String[] getGatewayAddress(Configuration configuration) {
        return configuration.getStrings(S3AIDBProperty.IDBROKER_GATEWAY.getPropertyName(), new String[]{S3AIDBProperty.IDBROKER_GATEWAY.getDefaultValue()});
    }

    @Override
    protected String getUsername(Configuration conf) {
        try {
            return S3AUtils.lookupPassword((String)this.fs.getBucket(), (Configuration)conf, (String)S3AIDBProperty.IDBROKER_USERNAME.getPropertyName());
        }
        catch (IOException e) {
            LOG.warn("Failed to get the username from S3A, falling back to the configuration", (Throwable)e);
            return this.getPropertyValue(conf, S3AIDBProperty.IDBROKER_USERNAME);
        }
    }

    @Override
    protected String getUsernamePropertyName() {
        return S3AIDBProperty.IDBROKER_USERNAME.getPropertyName();
    }

    @Override
    protected String getPassword(Configuration conf) {
        try {
            return S3AUtils.lookupPassword((String)this.fs.getBucket(), (Configuration)conf, (String)S3AIDBProperty.IDBROKER_PASSWORD.getPropertyName());
        }
        catch (IOException e) {
            LOG.warn("Failed to get the password from S3A, falling back to the configuration", (Throwable)e);
            return this.getPropertyValue(conf, S3AIDBProperty.IDBROKER_PASSWORD);
        }
    }

    @Override
    protected String getPasswordPropertyName() {
        return S3AIDBProperty.IDBROKER_PASSWORD.getPropertyName();
    }

    @Override
    public MarshalledCredentials extractCloudCredentialsFromResponse(BasicResponse basicResponse) throws IOException {
        return this.responseToMarshalledCredentials(this.processGet(AuthResponseAWSMessage.class, null, basicResponse));
    }

    @Override
    protected IOException translateException(URI requestURI, String extraDiags, KnoxShellException e) {
        Object ioe;
        String path = requestURI.toString();
        Throwable cause = e.getCause();
        if (cause instanceof ErrorResponse) {
            ErrorResponse error = (ErrorResponse)cause;
            HttpResponse response = error.getResponse();
            int status = response.getStatusLine().getStatusCode();
            String message = String.format(Locale.ROOT, "Error %03d from %s", status, path);
            if (!extraDiags.isEmpty()) {
                message = message + " " + extraDiags;
            }
            switch (status) {
                case 401: 
                case 403: {
                    ioe = new AccessDeniedException(path, null, message);
                    ((Throwable)ioe).initCause(e);
                    break;
                }
                case 404: 
                case 410: {
                    ioe = new FileNotFoundException(message);
                    ((Throwable)ioe).initCause(e);
                    break;
                }
                default: {
                    ioe = new DelegationTokenIOException(message + "  " + (Object)((Object)e), (Throwable)e);
                    break;
                }
            }
        } else {
            String errorMessage = e.toString();
            if (errorMessage.contains("Unable to obtain Principal Name for authentication")) {
                errorMessage = errorMessage + " - Trying to request full IDBroker session but not logged in with Kerberos.";
            }
            ioe = new DelegationTokenIOException("From " + path + " " + errorMessage + (extraDiags.isEmpty() ? "" : " " + extraDiags), (Throwable)e);
        }
        return ioe;
    }

    MarshalledCredentials responseToMarshalledCredentials(AuthResponseAWSMessage responseAWSMessage) throws IOException {
        AuthResponseAWSMessage.CredentialsStruct responseCreds = responseAWSMessage.Credentials;
        MarshalledCredentials received = new MarshalledCredentials(responseCreds.AccessKeyId, responseCreds.SecretAccessKey, responseCreds.SessionToken);
        received.setExpiration(responseCreds.Expiration);
        received.setRoleARN(responseAWSMessage.AssumedRoleUser.Arn);
        received.validate(this.getGatewayAddress() + " ", MarshalledCredentials.CredentialTypeRequired.SessionOnly);
        return received;
    }
}

