/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.s3a;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.common.AbstractIDBTokenRenewer;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBS3AConstants;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBS3ATokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBProperty;

public class IDBS3ATokenRenewer
extends AbstractIDBTokenRenewer {
    private static final String GATEWAY_ADDRESS_PROPERTY = S3AIDBProperty.IDBROKER_GATEWAY.getPropertyName();
    private static final String DT_PATH_PROPERTY = S3AIDBProperty.IDBROKER_DT_PATH.getPropertyName();

    public boolean handleKind(Text text) {
        return IDBS3AConstants.IDB_TOKEN_KIND.equals((Object)text);
    }

    @Override
    protected String getAccessToken(DelegationTokenIdentifier identifier) {
        return ((IDBS3ATokenIdentifier)identifier).getAccessToken();
    }

    @Override
    protected long getTokenExpiration(DelegationTokenIdentifier identifier) {
        return ((IDBS3ATokenIdentifier)identifier).getExpiryTime();
    }

    @Override
    protected String getGatewayAddressConfigProperty(Configuration config) {
        return config.get(GATEWAY_ADDRESS_PROPERTY);
    }

    @Override
    protected String getDelegationTokenPathConfigProperty(Configuration config) {
        return config.get(DT_PATH_PROPERTY);
    }
}

