/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.s3a;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.io.Text;
import org.apache.knox.gateway.cloud.idbroker.common.IDBTokenPayload;
import org.apache.knox.gateway.cloud.idbroker.common.Preconditions;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBS3AConstants;

public class IDBS3ATokenIdentifier
extends AbstractS3ATokenIdentifier {
    private IDBTokenPayload payload = new IDBTokenPayload();
    private MarshalledCredentials marshalledCredentials = new MarshalledCredentials();
    private String rolePolicy = "";

    public IDBS3ATokenIdentifier() {
        super(IDBS3AConstants.IDB_TOKEN_KIND);
    }

    public IDBS3ATokenIdentifier(Text kind, Text owner, Text renewer, URI uri, String accessToken, long expiryTime, MarshalledCredentials marshalledCredentials, EncryptionSecrets encryptionSecrets, String rolePolicy, String origin, long issueTime, String correlationId, String endpoint, String endpointCertificate) {
        super(kind, uri, owner, renewer, origin, encryptionSecrets);
        this.marshalledCredentials = Preconditions.checkNotNull(marshalledCredentials);
        this.payload = new IDBTokenPayload(accessToken, endpoint, expiryTime, issueTime, correlationId, endpointCertificate);
        this.rolePolicy = Preconditions.checkNotNull(rolePolicy);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.payload.write(out);
        this.marshalledCredentials.write(out);
        Text.writeString((DataOutput)out, (String)this.rolePolicy);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.payload.readFields(in);
        this.marshalledCredentials.readFields(in);
        this.rolePolicy = Text.readString((DataInput)in, (int)32768);
    }

    public String toString() {
        return "IDBroker S3ATokenIdentifier{" + super.toString() + " " + this.payload + ", AWS Credentials=" + this.marshalledCredentials + '}';
    }

    public long getExpiryTime() {
        return this.payload.getExpiryTime();
    }

    public MarshalledCredentials getMarshalledCredentials() {
        return this.marshalledCredentials;
    }

    public boolean hasMarshalledCredentials() {
        return !this.marshalledCredentials.isEmpty();
    }

    public Optional<MarshalledCredentials> credentials() {
        return this.hasMarshalledCredentials() ? Optional.of(this.marshalledCredentials) : Optional.empty();
    }

    public Optional<OffsetDateTime> getExpirationDateTime() {
        return this.marshalledCredentials.getExpirationDateTime();
    }

    public String getAccessToken() {
        return this.payload.getAccessToken();
    }

    public String getRolePolicy() {
        return this.rolePolicy;
    }

    public String getCertificate() {
        return this.payload.getCertificate();
    }

    public String getEndpoint() {
        return this.payload.getEndpoint();
    }

    public void validate() throws IOException {
        super.validate();
        this.payload.validate(true);
        this.marshalledCredentials.validate("Credentials in delegation token", MarshalledCredentials.CredentialTypeRequired.AnyIncludingEmpty);
        Preconditions.checkNotNull(this.rolePolicy, "null rolePolicy");
    }

    public String errorMessageString() {
        String s = this.payload.errorMessageString("Knox S3A Delegation Token");
        return s + " " + this.getOrigin();
    }
}

