/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.s3a;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialBinding;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.NoAuthWithAWSException;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractDelegationTokenBinding;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxTokenMonitor;
import org.apache.knox.gateway.cloud.idbroker.common.UTCClock;
import org.apache.knox.gateway.cloud.idbroker.messages.RequestDTResponseMessage;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBS3AConstants;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBS3ATokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBClient;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBProperty;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.KnoxSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDBDelegationTokenBinding
extends AbstractDelegationTokenBinding {
    private static final String E_NO_ACQUIRE_TOKEN_FROM_TOKEN = "Cannot acquire Knox token unless logged in; using %s";
    private static final String E_NO_ACQUIRE_TOKEN_WHEN_HAS_EXPIRED = "Knox token has expired; the current token is %s";
    private static final String E_NO_KNOX_DELEGATION_TOKEN = "No Knox delegation token";
    private static final String E_NO_SESSION_TO_KNOX_AWS = "No session to knox AWS credential endpoint";
    protected static final Logger LOG = LoggerFactory.getLogger(IDBDelegationTokenBinding.class);
    private static final String NAME = "IDBDelegationToken";
    private static final String COMPONENT_NAME = "IDBDelegationToken";
    private static final String PROP_TOKENMON_ENABLED = S3AIDBProperty.IDBROKER_ENABLE_TOKEN_MONITOR.getPropertyName();
    private static final boolean PROP_TOKENMON_ENABLED_DEFAULT = Boolean.valueOf(S3AIDBProperty.IDBROKER_ENABLE_TOKEN_MONITOR.getDefaultValue());
    private AWSCredentialProviderList credentialProviders;
    private MarshalledCredentials marshalledCredentials;
    private S3AIDBClient idbClient;
    private UTCClock clock = UTCClock.getClock();
    private IDBS3ATokenIdentifier boundTokenIdentifier;
    private boolean collectAwsCredentials = true;
    private KnoxToken knoxToken;
    private KnoxTokenMonitor knoxTokenMonitor;

    public IDBDelegationTokenBinding() {
        this("IDBDelegationToken", IDBS3AConstants.IDB_TOKEN_KIND);
    }

    public IDBDelegationTokenBinding(String name, Text kind) {
        super(name, kind);
    }

    private void initKnoxTokenMonitor() {
        if (this.knoxTokenMonitor == null && this.idbClient.hasKerberosCredentials() && this.getConfig().getBoolean(PROP_TOKENMON_ENABLED, PROP_TOKENMON_ENABLED_DEFAULT)) {
            this.knoxTokenMonitor = new KnoxTokenMonitor();
        }
    }

    @VisibleForTesting
    protected MarshalledCredentials fetchMarshalledAWSCredentials(S3AIDBClient client, CloudAccessBrokerSession credentialSession) throws IOException {
        return (MarshalledCredentials)client.fetchCloudCredentials(credentialSession);
    }

    private void bondToRequestedToken(RequestDTResponseMessage response) throws IOException {
        String token = this.extractTokenFromResponse(response);
        LOG.debug("Bonded to Knox token {}", (Object)token.substring(0, 10));
        String gatewayCertificate = this.extractGatewayCertificate(response);
        if (gatewayCertificate.isEmpty()) {
            LOG.warn("No certificate provided by gateway: renewals will not work");
        }
        this.knoxToken = new KnoxToken("", token, response.token_type, response.expiryTimeSeconds(), gatewayCertificate);
        this.startKnoxTokenMonitor();
    }

    private String extractGatewayCertificate(RequestDTResponseMessage response) {
        String cert = response.endpoint_public_cert;
        if (cert == null) {
            cert = "";
        }
        return cert;
    }

    private String extractTokenFromResponse(RequestDTResponseMessage response) throws DelegationTokenIOException {
        String token = response.access_token;
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new DelegationTokenIOException(E_NO_KNOX_DELEGATION_TOKEN);
        }
        return token;
    }

    public AbstractS3ATokenIdentifier createTokenIdentifier(Optional<RoleModel.Policy> policy, EncryptionSecrets encryptionSecrets, Text renewer) throws IOException {
        this.credentialProviders = new AWSCredentialProviderList();
        this.credentialProviders.add((AWSCredentialsProvider)new IDBCredentials());
        this.maybeRenewAccessToken();
        String knoxDT = this.knoxToken.getAccessToken();
        long expiryTime = this.knoxToken.getExpiry();
        String endpointCertificate = this.knoxToken.getEndpointPublicCert();
        String endpoint = this.idbClient.getCredentialsURL();
        IDBS3ATokenIdentifier identifier = new IDBS3ATokenIdentifier(IDBS3AConstants.IDB_TOKEN_KIND, this.getOwnerText(), renewer, this.getCanonicalUri(), knoxDT, expiryTime, this.collectAWSCredentialsForDelegation(), encryptionSecrets, Objects.toString(policy.orElse(null), ""), "Created from " + endpoint, System.currentTimeMillis(), this.getOwner().getUserName(), endpoint, endpointCertificate);
        LOG.debug("Created token identifier {}", (Object)identifier);
        return identifier;
    }

    public AWSCredentialProviderList deployUnbonded() throws IOException {
        this.idbClient = S3AIDBClient.createFullIDBClient(this.getConfig(), this.getOwner(), this.getFileSystem());
        Configuration conf = this.getConfig();
        this.credentialProviders = new AWSCredentialProviderList();
        this.credentialProviders.add((AWSCredentialsProvider)new IDBCredentials());
        this.collectAwsCredentials = conf.getBoolean(S3AIDBProperty.IDBROKER_INIT_CAB_CREDENTIALS.getPropertyName(), Boolean.valueOf(S3AIDBProperty.IDBROKER_INIT_CAB_CREDENTIALS.getDefaultValue()).booleanValue());
        this.maybeRenewAccessToken();
        return this.credentialProviders;
    }

    public AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier retrievedIdentifier) throws IOException {
        LOG.debug("Binding to retrieved token");
        this.idbClient = S3AIDBClient.createLightIDBClient(this.getConfig(), this.getFileSystem());
        IDBS3ATokenIdentifier tokenIdentifier = (IDBS3ATokenIdentifier)this.convertTokenIdentifier(retrievedIdentifier, IDBS3ATokenIdentifier.class);
        tokenIdentifier.validate();
        this.boundTokenIdentifier = tokenIdentifier;
        this.marshalledCredentials = IDBDelegationTokenBinding.extractMarshalledCredentials(tokenIdentifier);
        this.knoxToken = new KnoxToken(tokenIdentifier.getOrigin(), tokenIdentifier.getAccessToken(), tokenIdentifier.getExpiryTime(), tokenIdentifier.getCertificate());
        if (StringUtils.isNotEmpty((CharSequence)this.knoxToken.getEndpointPublicCert())) {
            LOG.debug("Using Cloud Access Broker public cert from delegation token");
        }
        this.startKnoxTokenMonitor();
        this.credentialProviders = new AWSCredentialProviderList();
        this.credentialProviders.add((AWSCredentialsProvider)new IDBCredentials());
        LOG.debug("Renewing AWS Credentials if needed");
        if (this.maybeResetAWSCredentials().booleanValue()) {
            LOG.debug("New AWS credentials will be requested");
        }
        return this.credentialProviders;
    }

    public IDBS3ATokenIdentifier createEmptyIdentifier() {
        return new IDBS3ATokenIdentifier();
    }

    public String toString() {
        return "IDBDelegationTokenBinding{marshaledCredentials=" + Objects.toString(this.marshalledCredentials, "<unset>") + ", accessToken=" + Objects.toString(this.knoxToken, "<unset>") + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestDTResponseMessage requestNewKnoxToken(boolean hasExpired) throws IOException {
        RequestDTResponseMessage requestDTResponseMessage;
        Pair<KnoxSession, String> sessionPair = this.getNewKnoxDelegationTokenSession();
        KnoxSession session = (KnoxSession)sessionPair.getLeft();
        if (session == null) {
            String tokenInfo = this.boundTokenIdentifier == null ? "" : this.boundTokenIdentifier.errorMessageString();
            String message = hasExpired ? String.format(Locale.ROOT, E_NO_ACQUIRE_TOKEN_WHEN_HAS_EXPIRED, tokenInfo) : String.format(Locale.ROOT, E_NO_ACQUIRE_TOKEN_FROM_TOKEN, tokenInfo);
            throw new DelegationTokenIOException(message);
        }
        String origin = (String)sessionPair.getRight();
        try {
            requestDTResponseMessage = this.idbClient.requestKnoxDelegationToken(session, origin, this.getCanonicalUri());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
        return requestDTResponseMessage;
    }

    private Pair<KnoxSession, String> getNewKnoxDelegationTokenSession() throws IOException {
        LOG.debug("Attempting to create a Knox delegation token session using local credentials (kerberos, simple)");
        Pair<KnoxSession, String> sessionDetails = this.idbClient.createKnoxDTSession(this.getConfig());
        if (sessionDetails.getLeft() != null) {
            LOG.debug("Created a Knox delegation token session using local credentials (kerberos, simple)");
        }
        if (sessionDetails.getLeft() == null) {
            String message = this.knoxToken == null ? "Authentication with IDBroker failed.  Please ensure you have a Kerberos token by using kinit." : "Authentication with IDBroker failed.  The existing Knox delegation token has expired and must be renewed. However, it cannot be renewed unless a valid Kerberos token is available. Please ensure you have a Kerberos token by using kinit.";
            throw new IllegalStateException(message);
        }
        return sessionDetails;
    }

    private boolean maybeRenewAccessToken() throws IOException {
        if (this.knoxToken == null) {
            LOG.debug("Requesting initial Knox delegation token");
            return this.getNewKnoxToken(true);
        }
        LOG.debug("Using existing Knox delegation token");
        return false;
    }

    private boolean getNewKnoxToken(boolean hasExpired) throws IOException {
        RequestDTResponseMessage message = this.requestNewKnoxToken(!hasExpired);
        if (message != null) {
            this.bondToRequestedToken(message);
            return true;
        }
        return false;
    }

    private MarshalledCredentials collectAWSCredentialsForDelegation() throws IOException {
        return this.collectAwsCredentials ? this.collectAWSCredentials() : MarshalledCredentials.empty();
    }

    private synchronized MarshalledCredentials collectAWSCredentials() throws IOException {
        if (this.maybeResetAWSCredentials().booleanValue()) {
            this.updateAWSCredentials();
        }
        LOG.debug("AWS credentials: {}", (Object)this.marshalledCredentials.toString());
        return this.marshalledCredentials;
    }

    @VisibleForTesting
    synchronized void updateAWSCredentials() throws IOException {
        LOG.debug("Requesting AWS credentials from IDBroker");
        CloudAccessBrokerSession knoxCABSession = this.idbClient.createKnoxCABSession(this.knoxToken);
        if (knoxCABSession == null) {
            throw new DelegationTokenIOException(E_NO_SESSION_TO_KNOX_AWS);
        }
        this.marshalledCredentials = this.fetchMarshalledAWSCredentials(this.idbClient, knoxCABSession);
    }

    @VisibleForTesting
    synchronized Boolean maybeResetAWSCredentials() {
        if (this.areAWSCredentialsNeeded()) {
            this.resetAWSCredentials();
            return true;
        }
        return false;
    }

    private boolean areAWSCredentialsNeeded() {
        LOG.debug("Checking if AWS credentials are needed");
        LOG.debug("Clock current time: {}", (Object)this.clock.getCurrentTime());
        if (this.marshalledCredentials == null) {
            return true;
        }
        Optional expirationDateTime = this.marshalledCredentials.getExpirationDateTime();
        LOG.debug("Credential expiration time: {}", (Object)expirationDateTime);
        return this.clock.hasExpired(expirationDateTime);
    }

    @VisibleForTesting
    synchronized void resetAWSCredentials() {
        LOG.debug("Resetting AWS credentials");
        this.marshalledCredentials = null;
    }

    @VisibleForTesting
    static MarshalledCredentials extractMarshalledCredentials(IDBS3ATokenIdentifier tokenIdentifier) {
        MarshalledCredentials incomingAwsCreds = tokenIdentifier.getMarshalledCredentials();
        return incomingAwsCreds.isValid(MarshalledCredentials.CredentialTypeRequired.SessionOnly) ? incomingAwsCreds : null;
    }

    protected void serviceStop() throws Exception {
        if (this.knoxTokenMonitor != null) {
            this.knoxTokenMonitor.shutdown();
        }
        super.serviceStop();
    }

    private void startKnoxTokenMonitor() {
        this.initKnoxTokenMonitor();
        if (this.knoxTokenMonitor != null) {
            long knoxTokenExpirationOffset = this.getConfig().getLong(S3AIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getPropertyName(), Long.parseLong(S3AIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getDefaultValue()));
            this.knoxTokenMonitor.monitorKnoxToken(this.knoxToken, knoxTokenExpirationOffset, new GetKnoxTokenCommand());
        }
    }

    private class GetKnoxTokenCommand
    implements KnoxTokenMonitor.GetKnoxTokenCommand {
        private GetKnoxTokenCommand() {
        }

        @Override
        public void execute(KnoxToken knoxToken) throws IOException {
            IDBDelegationTokenBinding.this.getNewKnoxToken(knoxToken != null);
        }
    }

    private class IDBCredentials
    implements AWSCredentialsProvider {
        private IDBCredentials() {
        }

        public AWSCredentials getCredentials() {
            try {
                return this.fetchCredentials();
            }
            catch (IOException e) {
                LOG.warn("Failed to fetch credentials: " + e.getMessage());
                LOG.debug("Failed to fetch credentials: ", (Throwable)e);
                throw new NoAuthWithAWSException(e.getMessage(), (Throwable)e);
            }
        }

        public void refresh() {
            IDBDelegationTokenBinding.this.resetAWSCredentials();
        }

        AWSCredentials fetchCredentials() throws IOException {
            IDBDelegationTokenBinding.this.maybeRenewAccessToken();
            return MarshalledCredentialBinding.toAWSCredentials((MarshalledCredentials)IDBDelegationTokenBinding.this.collectAWSCredentials(), (MarshalledCredentials.CredentialTypeRequired)MarshalledCredentials.CredentialTypeRequired.SessionOnly, (String)"IDBDelegationToken");
        }

        public String toString() {
            return "IDBCredentials for " + IDBDelegationTokenBinding.super.toString();
        }
    }
}

