/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.knox.gateway.cloud.idbroker.IDBClient;
import org.apache.knox.gateway.cloud.idbroker.google.CABDelegationTokenBinding;
import org.apache.knox.gateway.cloud.idbroker.google.DateTime;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleTempCredentials;
import org.apache.knox.gateway.cloud.idbroker.google.TestAccessTokenProvider;
import org.apache.knox.gateway.cloud.idbroker.google.TokenProvider;

public class TestCABDelegationTokenBinding
extends CABDelegationTokenBinding {
    TokenProvider accessTokenProvider;
    private boolean getTestToken;
    private Path testTokenPath;

    public void setClient(IDBClient<AccessTokenProvider.AccessToken> client) {
        this.cabClient = client;
    }

    public void bindToFileSystem(GoogleHadoopFileSystemBase fs, Text service) {
        super.bindToFileSystem(fs, service);
        LOG.warn("This implementation of the CABDelegationTokenBinding is for testing purposes only");
        Configuration configuration = this.getConf();
        String propertyValue = configuration.getTrimmed("fs.gs.ext.cab.test.token.path");
        if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
            Path path = Paths.get(propertyValue, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.warn("The specified path does not exist, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isRegularFile(path, new LinkOption[0])) {
                LOG.warn("The specified path is not a file, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isReadable(path)) {
                LOG.warn("The specified file is not readable, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else {
                this.testTokenPath = path;
                LOG.warn("Using test access token from {}", (Object)this.testTokenPath.toAbsolutePath());
            }
        } else {
            LOG.warn("A file for a test token was not specified, a test token will not be used");
            this.testTokenPath = null;
        }
        this.getTestToken = this.testTokenPath != null;
    }

    @Override
    TokenProvider getAccessTokenProvider() {
        if (this.accessTokenProvider == null) {
            this.accessTokenProvider = new TestAccessTokenProvider(super.getAccessTokenProvider());
        }
        return this.accessTokenProvider;
    }

    @Override
    synchronized GoogleTempCredentials updateGCPCredentials() throws IOException {
        GoogleTempCredentials token;
        if (this.getTestToken) {
            token = this.readTestToken();
            this.getTestToken = false;
        } else {
            token = null;
        }
        if (token == null) {
            LOG.warn("This implementation of the CABDelegationTokenBinding is for testing purposes only - using REAL access token");
            return super.updateGCPCredentials();
        }
        LOG.warn("This implementation of the CABDelegationTokenBinding is for testing purposes only - using TEST access token");
        return token;
    }

    private GoogleTempCredentials readTestToken() throws IOException {
        Map map;
        if (this.testTokenPath != null) {
            try (InputStream inputStream = Files.newInputStream(this.testTokenPath, new OpenOption[0]);){
                ObjectMapper om = new ObjectMapper();
                map = (Map)om.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        } else {
            map = null;
        }
        if (map != null) {
            String accessToken = (String)map.get("accessToken");
            String expireTime = (String)map.get("expireTime");
            long expirationDateTime = DateTime.parseRfc3339(expireTime).getValue();
            return new GoogleTempCredentials(new AccessTokenProvider.AccessToken(accessToken, Long.valueOf(expirationDateTime)));
        }
        return null;
    }
}

