/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.knox.gateway.cloud.idbroker.AbstractIDBClient;
import org.apache.knox.gateway.cloud.idbroker.google.CABUtils;
import org.apache.knox.gateway.cloud.idbroker.google.DateTime;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBProperty;
import org.apache.knox.gateway.shell.BasicResponse;

public class GoogleIDBClient
extends AbstractIDBClient<AccessTokenProvider.AccessToken> {
    public GoogleIDBClient(Configuration config, UserGroupInformation owner) throws IOException {
        super(config, owner);
    }

    @Override
    protected boolean getOnlyUser(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, GoogleIDBProperty.IDBROKER_ONLY_USER_METHOD);
    }

    @Override
    protected boolean getOnlyGroups(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, GoogleIDBProperty.IDBROKER_ONLY_GROUPS_METHOD);
    }

    @Override
    protected String getSpecificRole(Configuration configuration) {
        return this.getPropertyValue(configuration, GoogleIDBProperty.IDBROKER_SPECIFIC_ROLE_METHOD);
    }

    @Override
    protected String getSpecificGroup(Configuration configuration) {
        return this.getPropertyValue(configuration, GoogleIDBProperty.IDBROKER_SPECIFIC_GROUP_METHOD);
    }

    @Override
    protected String getTruststorePath(Configuration configuration) {
        return this.getPropertyValue(configuration, GoogleIDBProperty.IDBROKER_TRUSTSTORE_LOCATION);
    }

    @Override
    protected char[] getTruststorePassword(Configuration configuration) throws IOException {
        char[] password = configuration.getPassword(GoogleIDBProperty.IDBROKER_TRUSTSTORE_PASS.getPropertyName());
        if (password == null) {
            password = configuration.getPassword(GoogleIDBProperty.IDBROKER_TRUSTSTORE_PASSWORD.getPropertyName());
        }
        return password;
    }

    @Override
    protected boolean getUseCertificateFromDT(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, GoogleIDBProperty.IDBROKER_USE_DT_CERT);
    }

    @Override
    protected String getDelegationTokensURL(Configuration configuration) {
        return this.buildUrl(this.getGatewayAddress(), this.getPropertyValue(configuration, GoogleIDBProperty.IDBROKER_DT_PATH));
    }

    @Override
    protected String getCredentialsURL(Configuration configuration) {
        return this.buildUrl(this.getGatewayAddress(), this.getPropertyValue(configuration, GoogleIDBProperty.IDBROKER_PATH));
    }

    @Override
    protected String getCredentialsType(Configuration configuration) {
        return this.getPropertyValue(configuration, GoogleIDBProperty.IDBROKER_CREDENTIALS_TYPE);
    }

    @Override
    protected String[] getGatewayAddress(Configuration configuration) {
        return configuration.getStrings(GoogleIDBProperty.IDBROKER_GATEWAY.getPropertyName(), new String[]{GoogleIDBProperty.IDBROKER_GATEWAY.getDefaultValue()});
    }

    @Override
    protected String getUsername(Configuration configuration) {
        return this.getPropertyValue(configuration, GoogleIDBProperty.IDBROKER_USERNAME);
    }

    @Override
    protected String getUsernamePropertyName() {
        return GoogleIDBProperty.IDBROKER_USERNAME.getPropertyName();
    }

    @Override
    protected String getPassword(Configuration configuration) {
        return CABUtils.getConfigSecret(configuration, this.getPasswordPropertyName(), "CLOUD_ACCESS_BROKER_PASS");
    }

    @Override
    protected String getPasswordPropertyName() {
        return GoogleIDBProperty.IDBROKER_PASSWORD.getPropertyName();
    }

    @Override
    public AccessTokenProvider.AccessToken extractCloudCredentialsFromResponse(BasicResponse response) throws IOException {
        AccessTokenProvider.AccessToken token = null;
        if (response.getStatusCode() == 200 && response.getContentLength() > 0L && "application/json".equals(response.getContentType())) {
            Map<String, Object> json = this.parseJSONResponse(response.getString());
            String accessToken = (String)json.get("accessToken");
            String expireTime = (String)json.get("expireTime");
            long expirationDateTime = DateTime.parseRfc3339(expireTime).getValue();
            token = new AccessTokenProvider.AccessToken(accessToken, Long.valueOf(expirationDateTime));
        }
        return token;
    }

    Map<String, Object> parseJSONResponse(String response) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return (Map)om.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

