/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.google.cloud.hadoop.fs.gcs.auth.DelegationTokenIOException;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.knox.gateway.cloud.idbroker.IDBClient;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBProperty;
import org.apache.knox.gateway.cloud.idbroker.google.TokenProvider;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudAccessBrokerTokenProvider
implements TokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CloudAccessBrokerTokenProvider.class);
    private static final String E_MISSING_DT = "Missing required delegation token.";
    private Configuration config;
    private IDBClient<AccessTokenProvider.AccessToken> cabClient;
    private AccessTokenProvider.AccessToken accessToken;
    private long knoxTokenExpirationOffset;
    private KnoxToken knoxToken;

    CloudAccessBrokerTokenProvider(IDBClient<AccessTokenProvider.AccessToken> client, KnoxToken knoxToken, String accessToken, Long accessTokenExpiration) {
        this.cabClient = client;
        this.knoxToken = knoxToken;
        if (accessToken != null) {
            this.accessToken = new AccessTokenProvider.AccessToken(accessToken, accessTokenExpiration);
        }
    }

    public void setConf(Configuration configuration) {
        this.config = configuration;
        if (configuration != null) {
            this.knoxTokenExpirationOffset = configuration.getLong(GoogleIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getPropertyName(), this.knoxTokenExpirationOffset);
        }
    }

    public Configuration getConf() {
        return this.config;
    }

    @Override
    public void updateDelegationToken(KnoxToken delegationToken) {
        this.knoxToken = delegationToken;
    }

    public AccessTokenProvider.AccessToken getAccessToken() {
        if (!this.isValid(this.accessToken)) {
            LOG.info("No existing valid Google Cloud Platform credentials.");
            try {
                this.accessToken = this.fetchAccessToken();
            }
            catch (IOException e) {
                LOG.error("Failed to fetch new Google Cloud Platform credentials: " + e.getMessage());
                throw new RuntimeException(e);
            }
        } else {
            LOG.info("Using existing Google Cloud Platform credentials");
        }
        return this.accessToken;
    }

    public void refresh() throws IOException {
        LOG.info("Refresh Google Cloud Platform credentials");
        this.accessToken = this.fetchAccessToken();
    }

    private boolean isValid(AccessTokenProvider.AccessToken accessToken) {
        return accessToken != null && accessToken.getExpirationTimeMilliSeconds() >= System.currentTimeMillis() + this.knoxTokenExpirationOffset;
    }

    private AccessTokenProvider.AccessToken fetchAccessToken() throws IOException {
        AccessTokenProvider.AccessToken result;
        if (this.knoxToken == null || !this.knoxToken.isValid()) {
            throw new IllegalStateException(E_MISSING_DT);
        }
        try {
            CloudAccessBrokerSession session = this.cabClient.createKnoxCABSession(this.knoxToken);
            try {
                LOG.debug("Requesting Google Cloud Platform credentials from the Cloud Access Broker.");
                result = this.cabClient.fetchCloudCredentials(session);
            }
            catch (IOException e) {
                try {
                    LOG.error("Error requesting cloud credentials: " + e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
                    throw throwable;
                }
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
            if (result != null) {
                LOG.info("Acquired Google Cloud Platform credentials: token={}, expires={}", (Object)result.getToken().substring(0, 8), (Object)new Date(result.getExpirationTimeMilliSeconds()));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            LOG.debug("Failed to get Google Cloud Platform credentials.", (Throwable)e);
            throw new DelegationTokenIOException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

