/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.common.AbstractIDBTokenRenewer;
import org.apache.knox.gateway.cloud.idbroker.google.CABGCPTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerBindingConstants;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBProperty;

public class CABGCPTokenRenewer
extends AbstractIDBTokenRenewer {
    private static final String GATEWAY_ADDRESS_PROPERTY = GoogleIDBProperty.IDBROKER_GATEWAY.getPropertyName();
    private static final String DT_PATH_PROPERTY = GoogleIDBProperty.IDBROKER_DT_PATH.getPropertyName();

    public boolean handleKind(Text text) {
        return CloudAccessBrokerBindingConstants.CAB_TOKEN_KIND.equals((Object)text);
    }

    @Override
    protected String getAccessToken(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).getAccessToken();
    }

    @Override
    protected long getTokenExpiration(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).getExpiryTime();
    }

    @Override
    protected String getGatewayAddressConfigProperty(Configuration config) {
        return config.get(GATEWAY_ADDRESS_PROPERTY);
    }

    @Override
    protected String getDelegationTokenPathConfigProperty(Configuration config) {
        return config.get(DT_PATH_PROPERTY);
    }
}

