/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.google.cloud.hadoop.fs.gcs.auth.AbstractDelegationTokenBinding;
import com.google.cloud.hadoop.fs.gcs.auth.DelegationTokenIOException;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.IDBClient;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxTokenMonitor;
import org.apache.knox.gateway.cloud.idbroker.common.UTCClock;
import org.apache.knox.gateway.cloud.idbroker.google.CABGCPTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.google.CABUtils;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerBindingConstants;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerTokenProvider;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBProperty;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleTempCredentials;
import org.apache.knox.gateway.cloud.idbroker.google.TokenProvider;
import org.apache.knox.gateway.cloud.idbroker.messages.RequestDTResponseMessage;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.KnoxSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CABDelegationTokenBinding
extends AbstractDelegationTokenBinding {
    protected static final Logger LOG = LoggerFactory.getLogger(CABDelegationTokenBinding.class);
    static final String E_INVALID_DT_RESPONSE = "Invalid delegation token response";
    static final String E_FAILED_DT_SESSION = "Error establishing session with delegation token provider";
    static final String E_FAILED_CLOUD_SESSION = "Error establishing session with Cloud Access Broker credential provider";
    static final String E_NO_SESSION_TO_KNOX_CREDS = "No session with Knox credential endpoint";
    static final String E_MISSING_DT_USERNAME_CONFIG = "Missing Cloud Access Broker delegation token username configuration in fs.gs.ext.cab.username";
    private static final String PROP_TOKENMON_ENABLED = GoogleIDBProperty.IDBROKER_ENABLE_TOKEN_MONITOR.getPropertyName();
    private static final boolean PROP_TOKENMON_ENABLED_DEFAULT = Boolean.valueOf(GoogleIDBProperty.IDBROKER_ENABLE_TOKEN_MONITOR.getDefaultValue());
    protected IDBClient<AccessTokenProvider.AccessToken> cabClient;
    private KnoxToken knoxToken;
    private KnoxTokenMonitor knoxTokenMonitor;
    private GoogleTempCredentials marshalledCredentials;
    private TokenProvider accessTokenProvider;

    public CABDelegationTokenBinding() {
        super(CloudAccessBrokerBindingConstants.CAB_TOKEN_KIND);
    }

    private void initKnoxTokenMonitor() {
        if (this.knoxTokenMonitor == null && this.cabClient != null && this.cabClient.hasKerberosCredentials() && this.getConf().getBoolean(PROP_TOKENMON_ENABLED, PROP_TOKENMON_ENABLED_DEFAULT)) {
            this.knoxTokenMonitor = new KnoxTokenMonitor();
        }
    }

    IDBClient<AccessTokenProvider.AccessToken> getClient() {
        if (this.cabClient == null) {
            try {
                this.cabClient = CABUtils.newClient(this.getConf(), UserGroupInformation.getCurrentUser());
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
        return this.cabClient;
    }

    Configuration getConf() {
        return this.getFileSystem().getConf();
    }

    public AccessTokenProvider deployUnbonded() throws IOException {
        this.maybeRenewAccessToken();
        return this.getAccessTokenProvider();
    }

    TokenProvider getAccessTokenProvider() {
        if (this.accessTokenProvider == null) {
            LOG.debug("No existing accessTokenProvider");
            String gcpToken = null;
            long gcpTokenExp = -1L;
            if (this.marshalledCredentials != null) {
                LOG.debug("Using existing marshalled credentials");
                gcpToken = this.marshalledCredentials.getToken();
                gcpTokenExp = this.marshalledCredentials.getExpiration();
            }
            LOG.debug("Creating new accessTokenProvider");
            this.accessTokenProvider = new CloudAccessBrokerTokenProvider(this.cabClient, this.knoxToken, gcpToken, gcpTokenExp);
        }
        return this.accessTokenProvider;
    }

    public DelegationTokenIdentifier createTokenIdentifier() throws IOException {
        String tokenType = null;
        String targetURL = CABUtils.getCloudAccessBrokerURL(this.getConf(), this.cabClient.getGatewayAddress());
        this.maybeRenewAccessToken();
        String knoxDT = this.knoxToken.getAccessToken();
        long expiryTime = this.knoxToken.getExpiry();
        String endpointCertificate = this.knoxToken.getEndpointPublicCert();
        GoogleTempCredentials gcpCredentials = this.getConf().getBoolean("fs.gs.ext.cab.init.credentials", true) ? this.collectGCPCredentials() : new GoogleTempCredentials();
        CABGCPTokenIdentifier identifier = new CABGCPTokenIdentifier(this.getKind(), this.getOwnerText(UserGroupInformation.getCurrentUser()), this.getCanonicalUri(), knoxDT, expiryTime, tokenType, targetURL, endpointCertificate, gcpCredentials, "Created from " + this.cabClient.getGatewayAddress());
        LOG.debug("Created delegation token identifier {}", (Object)identifier);
        return identifier;
    }

    public DelegationTokenIdentifier createTokenIdentifier(Text renewer) throws IOException {
        return this.createTokenIdentifier();
    }

    public DelegationTokenIdentifier createEmptyIdentifier() {
        return null;
    }

    private void maybeRenewAccessToken() throws IOException {
        if (this.knoxToken == null) {
            LOG.info("Requesting initial delegation token");
            this.bondToRequestedToken(this.requestDelegationToken());
        }
    }

    private boolean hasExpired(long seconds) {
        return seconds < TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    public AccessTokenProvider bindToTokenIdentifier(DelegationTokenIdentifier retrievedIdentifier) throws IOException {
        CABGCPTokenIdentifier tokenIdentifier = (CABGCPTokenIdentifier)this.convertTokenIdentifier(retrievedIdentifier, CABGCPTokenIdentifier.class);
        String endpointCert = tokenIdentifier.getCertificate();
        if (endpointCert != null) {
            LOG.debug("Using Cloud Access Broker public cert from delegation token");
        }
        this.knoxToken = new KnoxToken("origin", tokenIdentifier.getAccessToken(), tokenIdentifier.getTokenType(), tokenIdentifier.getExpiryTime(), endpointCert);
        this.startKnoxTokenMonitor();
        this.marshalledCredentials = tokenIdentifier.getMarshalledCredentials();
        LOG.debug("Marshalled GCP credentials: " + this.marshalledCredentials.toString());
        TokenProvider tokenProvider = this.getAccessTokenProvider();
        tokenProvider.updateDelegationToken(this.knoxToken);
        return tokenProvider;
    }

    private void bondToRequestedToken(Pair<RequestDTResponseMessage, String> response) throws IOException {
        if (response == null || response.getLeft() == null) {
            throw new DelegationTokenIOException(E_INVALID_DT_RESPONSE);
        }
        this.knoxToken = KnoxToken.fromDTResponse((String)response.getRight(), (RequestDTResponseMessage)response.getLeft());
        this.getAccessTokenProvider().updateDelegationToken(this.knoxToken);
        this.startKnoxTokenMonitor();
        LOG.info("Bonded to Knox token {}, expires {}", (Object)this.knoxToken.getAccessToken().substring(0, 10), UTCClock.secondsToDateTime(this.knoxToken.getExpiry()));
        if (this.knoxToken.getEndpointPublicCert() != null) {
            LOG.debug("Including public cert in the delegation token.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<RequestDTResponseMessage, String> requestDelegationToken() throws IOException {
        Pair pair;
        Pair<KnoxSession, String> sessionDetails = this.getDTSession();
        KnoxSession session = (KnoxSession)sessionDetails.getLeft();
        String origin = (String)sessionDetails.getRight();
        try {
            pair = Pair.of((Object)this.getClient().requestKnoxDelegationToken(session, origin, this.getCanonicalUri()), (Object)origin);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
        return pair;
    }

    private synchronized GoogleTempCredentials collectGCPCredentials() throws IOException {
        if (this.needsGCPCredentials()) {
            this.marshalledCredentials = this.updateGCPCredentials();
        }
        return this.marshalledCredentials;
    }

    synchronized GoogleTempCredentials updateGCPCredentials() throws IOException {
        GoogleTempCredentials googleTempCredentials;
        CloudAccessBrokerSession session = this.getClient().createKnoxCABSession(this.knoxToken);
        try {
            googleTempCredentials = new GoogleTempCredentials(this.getClient().fetchCloudCredentials(session));
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
        return googleTempCredentials;
    }

    private synchronized boolean needsGCPCredentials() {
        boolean isNeeded = true;
        if (this.marshalledCredentials != null && !this.marshalledCredentials.isEmpty()) {
            long expiration = this.marshalledCredentials.getExpiration();
            if (expiration > 0L && this.hasExpired(expiration)) {
                LOG.debug("Expiring current GCP credentials");
                this.resetGCPCredentials();
            } else {
                LOG.debug("Current GCP credentials are still valid");
                isNeeded = false;
            }
        } else {
            LOG.debug("No marshalled GCP credentials");
        }
        return isNeeded;
    }

    private synchronized void resetGCPCredentials() {
        this.marshalledCredentials = null;
    }

    private Pair<KnoxSession, String> getDTSession() throws IOException {
        IDBClient<AccessTokenProvider.AccessToken> client = this.getClient();
        LOG.debug("Attempting to create a Knox delegation token session using local credentials (kerberos, simple)");
        Pair<KnoxSession, String> sessionDetails = client.createKnoxDTSession(this.getConf());
        if (sessionDetails.getLeft() != null) {
            LOG.debug("Created a Knox delegation token session using local credentials (kerberos, simple)");
        }
        if (sessionDetails.getLeft() == null) {
            String message = this.knoxToken == null ? "Authentication with IDBroker failed.  Please ensure you have a Kerberos token by using kinit." : "Authentication with IDBroker failed.  The existing Knox delegation token has expired and must be renewed. However, it cannot be renewed unless a valid Kerberos token is available. Please ensure you have a Kerberos token by using kinit.";
            throw new IllegalStateException(message);
        }
        return sessionDetails;
    }

    private Text getOwnerText(UserGroupInformation owner) {
        return new Text(owner.getUserName());
    }

    private URI getCanonicalUri() {
        return this.getFileSystem().getUri();
    }

    private void startKnoxTokenMonitor() {
        this.initKnoxTokenMonitor();
        if (this.knoxTokenMonitor != null) {
            long knoxTokenExpirationOffset = this.getConf().getLong(GoogleIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getPropertyName(), Long.parseLong(GoogleIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getDefaultValue()));
            this.knoxTokenMonitor.monitorKnoxToken(this.knoxToken, knoxTokenExpirationOffset, new GetKnoxTokenCommand());
        }
    }

    private class GetKnoxTokenCommand
    implements KnoxTokenMonitor.GetKnoxTokenCommand {
        private GetKnoxTokenCommand() {
        }

        @Override
        public void execute(KnoxToken knoxToken) throws IOException {
            CABDelegationTokenBinding.this.bondToRequestedToken((Pair<RequestDTResponseMessage, String>)CABDelegationTokenBinding.this.requestDelegationToken());
        }
    }
}

