/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.util.Locale;

public class OperationDuration {
    private final long started;
    private long finished;

    public OperationDuration() {
        this.finished = this.started = this.time();
    }

    protected long time() {
        return System.currentTimeMillis();
    }

    public void finished() {
        this.finished = this.time();
    }

    public String getDurationString() {
        return OperationDuration.humanTime(this.value());
    }

    public static String humanTime(long time) {
        long seconds = time / 1000L;
        long minutes = seconds / 60L;
        return String.format(Locale.ROOT, "%d:%02d.%03ds", minutes, seconds % 60L, time % 1000L);
    }

    public String toString() {
        return this.getDurationString();
    }

    public long value() {
        return this.finished - this.started;
    }
}

