/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.cloud.idbroker.common.Preconditions;
import org.apache.knox.gateway.cloud.idbroker.messages.RequestDTResponseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxToken {
    public static final String DEFAULT_TOKEN_TYPE = "Bearer";
    private static final Logger LOG = LoggerFactory.getLogger(KnoxToken.class);
    private final String origin;
    private final String accessToken;
    private final String tokenType;
    private final long expiry;
    private final String endpointPublicCert;

    public KnoxToken(String origin, String accessToken, long expiry, String endpointPublicCert) {
        this(origin, accessToken, DEFAULT_TOKEN_TYPE, expiry, endpointPublicCert);
    }

    public KnoxToken(String origin, String accessToken, String tokenType, long expiry, String endpointPublicCert) {
        this.origin = origin;
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiry = expiry;
        this.endpointPublicCert = endpointPublicCert;
    }

    public static KnoxToken fromDTResponse(String origin, RequestDTResponseMessage message) {
        Preconditions.checkArgument(message != null, "Missing RequestDTResponseMessage");
        return new KnoxToken(origin, message.access_token, message.token_type, message.expiryTimeSeconds(), message.endpoint_public_cert);
    }

    public static KnoxToken fromDTResponse(RequestDTResponseMessage message) {
        return KnoxToken.fromDTResponse("unknown", message);
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return StringUtils.isEmpty((CharSequence)this.tokenType) ? DEFAULT_TOKEN_TYPE : this.tokenType;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public String getEndpointPublicCert() {
        return this.endpointPublicCert;
    }

    public boolean isExpired() {
        return this.isAboutToExpire(0L);
    }

    public boolean isAboutToExpire(long offsetSeconds) {
        return this.isAboutToExpire(offsetSeconds, ChronoUnit.SECONDS);
    }

    public boolean isAboutToExpire(long offset, TemporalUnit unit) {
        Instant now = Instant.now();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Knox token expiration:\n\tExpires in:\t{} seconds\n\tOffset:\t{} seconds\n\tTime left:\t{} seconds", new Object[]{this.expiry - now.getEpochSecond(), Duration.of(offset, unit).getSeconds(), this.expiry - now.plus(offset, unit).getEpochSecond()});
        }
        return !Instant.ofEpochSecond(this.expiry).isAfter(now.plus(offset, unit));
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.accessToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128).append("KnoxToken{origin=").append(this.origin).append(", accessToken=").append(this.accessToken).append(", TokenType=").append(this.tokenType).append(", expiry=").append(this.expiry).append(", endpointPublicCert=");
        if (StringUtils.isNotEmpty((CharSequence)this.endpointPublicCert)) {
            sb.append(this.endpointPublicCert, 0, Math.min(5, this.endpointPublicCert.length())).append("...");
        } else {
            sb.append("<unset>");
        }
        return sb.append('}').toString();
    }
}

