/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.knox.gateway.cloud.idbroker.common.Preconditions;
import org.apache.knox.gateway.cloud.idbroker.common.UTCClock;

public class IDBTokenPayload
implements Writable {
    private String accessToken;
    private String endpoint;
    private long issueTime;
    private long expiryTime;
    private String correlationId;
    private String certificate;

    public IDBTokenPayload(String accessToken, String endpoint, long expiryTime, long issueTime, String correlationId, String endpointCertificate) {
        this.accessToken = Preconditions.checkNotNull(accessToken);
        this.endpoint = Preconditions.checkNotNull(endpoint);
        this.expiryTime = expiryTime;
        this.issueTime = issueTime;
        this.correlationId = correlationId;
        this.certificate = endpointCertificate;
    }

    public IDBTokenPayload() {
        this("", "", 0L, 0L, "", "");
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.issueTime);
        out.writeLong(this.expiryTime);
        Text.writeString((DataOutput)out, (String)this.accessToken);
        Text.writeString((DataOutput)out, (String)this.endpoint);
        Text.writeString((DataOutput)out, (String)this.correlationId);
        Text.writeString((DataOutput)out, (String)this.certificate);
    }

    public void readFields(DataInput in) throws IOException {
        this.issueTime = in.readLong();
        this.expiryTime = in.readLong();
        this.accessToken = Text.readString((DataInput)in, (int)32768);
        this.endpoint = Text.readString((DataInput)in, (int)32768);
        this.correlationId = Text.readString((DataInput)in, (int)32768);
        this.certificate = Text.readString((DataInput)in, (int)32768);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public Optional<OffsetDateTime> getExpiryDateTime() {
        return this.expiryTime == 0L ? Optional.empty() : Optional.of(OffsetDateTime.ofInstant(new Date(TimeUnit.SECONDS.toMillis(this.expiryTime)).toInstant(), ZoneOffset.UTC));
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return "IDBTokenPayload{accessToken='" + IDBTokenPayload.tokenToPrintableString(this.accessToken) + '\'' + ", issued=" + UTCClock.timeToString(UTCClock.millisToDateTime(this.issueTime)) + ", expiry=" + UTCClock.secondsToString(this.expiryTime) + ", expiryTime=" + this.expiryTime + ", endpoint=" + this.endpoint + ", certificate=" + (this.certificate.isEmpty() ? "empty" : this.certificate.substring(0, Math.min(8, this.certificate.length())) + "...") + '}';
    }

    public String errorMessageString(String type) {
        return type + " " + "issued=" + UTCClock.timeToString(UTCClock.millisToDateTime(this.issueTime)) + ", expiry=" + UTCClock.secondsToString(this.expiryTime) + ", endpoint=" + this.endpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IDBTokenPayload payload = (IDBTokenPayload)o;
        return Objects.equals(this.accessToken, payload.accessToken) && Objects.equals(this.correlationId, payload.correlationId);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.correlationId);
    }

    public void validate(boolean requireCertificate) throws IOException {
        this.checkValid("accessToken", this.accessToken);
        this.checkValid("endpoint", this.endpoint);
        this.checkValid("correlationId", this.correlationId);
        Preconditions.checkNotNull(this.certificate, "Null certificate field");
        if (requireCertificate) {
            this.checkValid("certificate", this.certificate);
        }
    }

    private void checkValid(String fieldname, String field) {
        Preconditions.checkNotNull(field, "Null " + fieldname);
        Preconditions.checkState(!field.isEmpty(), "Empty " + fieldname);
    }

    private static String tokenToPrintableString(String accessToken) {
        return StringUtils.isNotEmpty((CharSequence)accessToken) ? accessToken.substring(0, 4) + "..." + accessToken.substring(accessToken.length() - 3) : "(unset)";
    }
}

