/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.knox.gateway.cloud.idbroker.common.EndpointManager;
import org.apache.knox.gateway.cloud.idbroker.common.RandomEndpointManager;
import org.apache.knox.gateway.cloud.idbroker.common.RequestExecutor;
import org.apache.knox.gateway.shell.AbstractCloudAccessBrokerRequest;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestExecutor
implements RequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestExecutor.class);
    private static final List<Integer> retryStatusCodes = Arrays.asList(404, 503, 504);
    private static final List<Class<? extends Exception>> failoverExceptions = Arrays.asList(UnknownHostException.class, NoRouteToHostException.class, SocketException.class);
    private EndpointManager endpointManager;
    private int maxFailoverAttempts = 2;
    private int maxRetryAttempts = 2;
    private long failoverSleep = 1000L;
    private long retrySleep = 5000L;

    public DefaultRequestExecutor(List<String> endpoints) {
        this(new RandomEndpointManager(endpoints));
    }

    public DefaultRequestExecutor(EndpointManager endpointManager) {
        this.endpointManager = endpointManager;
    }

    @Override
    public String getEndpoint() {
        return this.endpointManager.getActiveURL();
    }

    @Override
    public List<String> getConfiguredEndpoints() {
        return this.endpointManager.getURLs();
    }

    @Override
    public <T> T execute(AbstractCloudAccessBrokerRequest<T> request) {
        Object response = null;
        try {
            response = request.now();
        }
        catch (KnoxShellException e) {
            LOG.error("Error executing request: {}", (Object)e.getMessage());
            if (this.isRetryException(e) && request.retryAttempts() < this.maxRetryAttempts) {
                try {
                    Thread.sleep(this.retrySleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                request.recordRetryAttempt();
                LOG.debug("Request attempt {} ...", (Object)request.retryAttempts());
                response = this.execute(request);
            }
            if (this.isFailoverException(e) && request.failoverAttempts() < this.maxFailoverAttempts) {
                LOG.debug("Failover attempt {} ...", (Object)(request.failoverAttempts() + 1));
                response = this.failoverRequest(request);
            }
            Throwable cause = e.getCause();
            if (ErrorResponse.class.isAssignableFrom(cause.getClass())) {
                throw (ErrorResponse)cause;
            }
            throw e;
        }
        return (T)response;
    }

    <T> T failoverRequest(AbstractCloudAccessBrokerRequest<T> request) throws KnoxShellException {
        T response = null;
        String currentEndpoint = this.endpointManager.getActiveURL();
        String topology = request.getSession().base().substring(currentEndpoint.length());
        this.endpointManager.markFailed(currentEndpoint);
        CloudAccessBrokerSession cabSession = request.getSession();
        try {
            String newEndpoint = this.endpointManager.getActiveURL();
            LOG.debug("Failing over to {}", (Object)newEndpoint);
            cabSession.updateEndpoint(newEndpoint + topology);
            try {
                Thread.sleep(this.failoverSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            request.recordFailoverAttempt();
            response = this.execute(request);
        }
        catch (ErrorResponse | KnoxShellException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KnoxShellException((Throwable)e);
        }
        return response;
    }

    private boolean isFailoverException(KnoxShellException e) {
        boolean isFailoverException = false;
        Throwable cause = e.getCause();
        if (cause != null) {
            for (Class<? extends Exception> exceptionType : failoverExceptions) {
                if (!exceptionType.isAssignableFrom(cause.getClass())) continue;
                isFailoverException = true;
                break;
            }
        }
        return isFailoverException;
    }

    private boolean isRetryException(KnoxShellException e) {
        boolean result = false;
        Throwable cause = e.getCause();
        if (cause != null && ErrorResponse.class.isAssignableFrom(cause.getClass())) {
            ErrorResponse response = (ErrorResponse)cause;
            result = retryStatusCodes.contains(response.getResponse().getStatusLine().getStatusCode());
        }
        return result;
    }
}

