/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.knox.gateway.shell.KnoxSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIDBTokenRenewer
extends TokenRenewer {
    private static final String ENDPOINT_TOKEN_API_PATH = "knoxtoken/api/v1/token";
    private static final String RENEW_ENDPOINT_PATH = "knoxtoken/api/v1/token/renew";
    private static final String CANCEL_ENDPOINT_PATH = "knoxtoken/api/v1/token/revoke";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIDBTokenRenewer.class);
    private static final String ERR_INVALID_RENEWER = "The user (%s) does not match the renewer declared for the token: %s";

    public boolean isManaged(Token<?> token) throws IOException {
        return this.handleKind(token.getKind());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long renew(Token<?> token, Configuration configuration) throws IOException, InterruptedException {
        long result;
        block6: {
            result = 0L;
            TokenIdentifier identifier = token.decodeIdentifier();
            if (this.handleKind(identifier.getKind())) {
                LOG.info("Renewing " + identifier.toString());
                DelegationTokenIdentifier dtIdentifier = (DelegationTokenIdentifier)identifier;
                LOG.debug("Token: " + dtIdentifier.toString());
                result = this.getTokenExpiration(dtIdentifier);
                UserGroupInformation user = UserGroupInformation.getCurrentUser();
                if (!AbstractIDBTokenRenewer.validateRenewer(user, dtIdentifier)) throw new IOException("Invalid renewer: " + user.getShortUserName());
                String accessToken = this.getAccessToken(dtIdentifier);
                LOG.debug("Access token: " + accessToken);
                String renewalEndpoint = this.getRenewalEndpoint(configuration);
                LOG.debug("Renewal endpoint: " + renewalEndpoint);
                try {
                    HttpResponse response = AbstractIDBTokenRenewer.executeRequest(renewalEndpoint, accessToken, user);
                    HttpEntity responseEntity = response.getEntity();
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() == 200) {
                        if (responseEntity == null || responseEntity.getContentLength() <= 0L || !"application/json".equals(responseEntity.getContentType().getValue())) break block6;
                        Map<String, Object> json = AbstractIDBTokenRenewer.parseJSONResponse(EntityUtils.toString((HttpEntity)responseEntity));
                        boolean isRenewed = Boolean.valueOf((String)json.getOrDefault("renewed", "false"));
                        if (isRenewed) {
                            LOG.debug("Token renewed.");
                            String expirationValue = (String)json.get("expires");
                            if (expirationValue != null && !expirationValue.isEmpty()) {
                                result = Long.parseLong(expirationValue);
                            }
                            break block6;
                        }
                        LOG.error("Token could not be renewed: " + json.get("error"));
                        throw new IOException("Token could not be renewed: " + json.get("error"));
                    }
                    LOG.error("Failed to renew token: " + statusLine.toString());
                    if (responseEntity == null) throw new IOException("Failed to renew token: " + statusLine.toString());
                    LOG.debug(EntityUtils.toString((HttpEntity)responseEntity));
                    throw new IOException("Failed to renew token: " + statusLine.toString());
                }
                catch (Exception e) {
                    LOG.error("Error renewing token: " + e.getMessage());
                    throw new IOException("Error renewing token", e);
                }
            }
        }
        LOG.debug("Updated token expiration: " + result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancel(Token<?> token, Configuration configuration) throws IOException, InterruptedException {
        TokenIdentifier identifier = token.decodeIdentifier();
        if (!this.handleKind(identifier.getKind())) return;
        LOG.info("Cancelling " + identifier.toString());
        DelegationTokenIdentifier dtIdentifier = (DelegationTokenIdentifier)identifier;
        LOG.debug("Token: " + dtIdentifier.toString());
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        if (!AbstractIDBTokenRenewer.validateRenewer(user, dtIdentifier)) throw new IOException("Invalid renewer: " + user.getShortUserName());
        String accessToken = this.getAccessToken(dtIdentifier);
        LOG.debug("Access token: " + accessToken);
        String cancelEndpoint = this.getCancelEndpoint(configuration);
        LOG.debug("Cancellation endpoint: " + cancelEndpoint);
        try {
            HttpResponse response = AbstractIDBTokenRenewer.executeRequest(cancelEndpoint, accessToken, user);
            HttpEntity responseEntity = response.getEntity();
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                if (responseEntity.getContentLength() <= 0L || !"application/json".equals(responseEntity.getContentType().getValue())) return;
                Map<String, Object> json = AbstractIDBTokenRenewer.parseJSONResponse(EntityUtils.toString((HttpEntity)responseEntity));
                boolean isCanceled = Boolean.valueOf((String)json.getOrDefault("revoked", "false"));
                if (isCanceled) {
                    LOG.debug("Token cancelled.");
                    return;
                }
                LOG.error("Token could not be cancelled: " + json.get("error"));
                throw new IOException("Token could not be cancelled: " + json.get("error"));
            }
            LOG.error("Failed to cancel token: " + statusLine.toString());
            if (responseEntity == null) throw new IOException("Failed to cancel token: " + statusLine.toString());
            LOG.debug(EntityUtils.toString((HttpEntity)responseEntity));
            throw new IOException("Failed to cancel token: " + statusLine.toString());
        }
        catch (Exception e) {
            LOG.error("Error cancelling token: " + e.getMessage());
            throw new IOException("Error cancelling token", e);
        }
    }

    protected abstract String getGatewayAddressConfigProperty(Configuration var1);

    protected abstract String getDelegationTokenPathConfigProperty(Configuration var1);

    protected abstract String getAccessToken(DelegationTokenIdentifier var1);

    protected abstract long getTokenExpiration(DelegationTokenIdentifier var1);

    private String getRenewalEndpoint(Configuration config) {
        String endpoint = this.getTokenEndpoint(config);
        return endpoint + RENEW_ENDPOINT_PATH;
    }

    private String getCancelEndpoint(Configuration config) {
        String endpoint = this.getTokenEndpoint(config);
        return endpoint + CANCEL_ENDPOINT_PATH;
    }

    private String getTokenEndpoint(Configuration config) {
        String gateway = this.getGatewayAddressConfigProperty(config);
        String dtPath = this.getDelegationTokenPathConfigProperty(config);
        return gateway + (gateway.endsWith("/") ? "" : "/") + dtPath + (dtPath.endsWith("/") ? "" : "/");
    }

    private static boolean validateRenewer(UserGroupInformation candidate, DelegationTokenIdentifier identifier) throws IllegalArgumentException {
        boolean isValid = true;
        Text declaredRenewer = identifier.getRenewer();
        if (declaredRenewer != null && declaredRenewer.getLength() > 0) {
            if (!declaredRenewer.toString().equals(candidate.getShortUserName())) {
                LOG.error(String.format(Locale.getDefault(), ERR_INVALID_RENEWER, candidate.getUserName(), declaredRenewer));
                isValid = false;
            }
        } else {
            LOG.error("Operation not permitted. No renewer is specified in the identifier.");
            isValid = false;
        }
        return isValid;
    }

    private static HttpResponse executeRequest(String endpoint, String tokenData, UserGroupInformation renewer) throws Exception {
        KnoxSession session = KnoxSession.kerberosLogin((String)endpoint);
        HttpPost request = new HttpPost(endpoint);
        request.setEntity((HttpEntity)new StringEntity(tokenData));
        Object response = renewer != null ? (HttpResponse)renewer.doAs(() -> {
            try {
                return session.executeNow((HttpRequest)request);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }) : session.executeNow((HttpRequest)request);
        return response;
    }

    private static Map<String, Object> parseJSONResponse(String response) throws IOException {
        return (Map)new ObjectMapper().readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

