/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.abfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBConstants;
import org.apache.knox.gateway.cloud.idbroker.common.IDBTokenPayload;
import org.apache.knox.gateway.cloud.idbroker.common.OAuthPayload;

public class AbfsIDBTokenIdentifier
extends DelegationTokenIdentifier {
    private URI uri;
    private long created = System.currentTimeMillis();
    private String origin = "";
    private String uuid = UUID.randomUUID().toString();
    private IDBTokenPayload payload = new IDBTokenPayload();
    private OAuthPayload marshalledCredentials = new OAuthPayload();

    public AbfsIDBTokenIdentifier() {
        super(AbfsIDBConstants.IDB_TOKEN_KIND);
    }

    public AbfsIDBTokenIdentifier(URI uri, Text owner, Text renewer, String origin, String accessToken, long expiryTime, OAuthPayload marshalledCredentials, long issueTime, String correlationId, String endpoint, String endpointCertificate) {
        super(AbfsIDBConstants.IDB_TOKEN_KIND, owner, renewer, new Text());
        this.uri = Objects.requireNonNull(uri);
        this.origin = Objects.requireNonNull(origin);
        this.marshalledCredentials = Objects.requireNonNull(marshalledCredentials);
        this.payload = new IDBTokenPayload(accessToken, endpoint, expiryTime, issueTime, correlationId, endpointCertificate);
    }

    public String getAccessToken() {
        return this.payload.getAccessToken();
    }

    public long getExpiryTime() {
        return this.payload.getExpiryTime();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public long getCreated() {
        return this.created;
    }

    public String getUuid() {
        return this.uuid;
    }

    public IDBTokenPayload getPayload() {
        return this.payload;
    }

    public OAuthPayload getMarshalledCredentials() {
        return this.marshalledCredentials;
    }

    public String getCertificate() {
        return this.payload.getCertificate();
    }

    public String getEndpoint() {
        return this.payload.getEndpoint();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.uri.toString());
        Text.writeString((DataOutput)out, (String)this.origin);
        Text.writeString((DataOutput)out, (String)this.uuid);
        out.writeLong(this.created);
        this.payload.write(out);
        this.marshalledCredentials.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.uri = URI.create(Text.readString((DataInput)in, (int)32768));
        this.origin = Text.readString((DataInput)in, (int)32768);
        this.uuid = Text.readString((DataInput)in, (int)32768);
        this.created = in.readLong();
        this.payload.readFields(in);
        this.marshalledCredentials.readFields(in);
    }

    public String toString() {
        return "AbfsIDBTokenIdentifier{uri=" + this.uri + ", uuid='" + this.uuid + '\'' + ", created='" + new Date(this.created) + '\'' + ", origin='" + this.origin + '\'' + ", payload=" + this.payload + ", oathCredentials=" + this.marshalledCredentials + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbfsIDBTokenIdentifier that = (AbfsIDBTokenIdentifier)((Object)o);
        return this.uri.equals(that.uri) && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uri, this.uuid);
    }
}

