/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.abfs;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.knox.gateway.cloud.idbroker.AbstractIDBClient;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsAuthResponseMessage;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBProperty;
import org.apache.knox.gateway.shell.BasicResponse;

public class AbfsIDBClient
extends AbstractIDBClient<AzureADToken> {
    AbfsIDBClient(Configuration conf, UserGroupInformation owner) throws IOException {
        super(conf, owner);
    }

    @Override
    protected boolean getOnlyUser(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, AbfsIDBProperty.IDBROKER_ONLY_USER_METHOD);
    }

    @Override
    protected boolean getOnlyGroups(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, AbfsIDBProperty.IDBROKER_ONLY_GROUPS_METHOD);
    }

    @Override
    protected String getSpecificRole(Configuration configuration) {
        return this.getPropertyValue(configuration, AbfsIDBProperty.IDBROKER_SPECIFIC_ROLE_METHOD);
    }

    @Override
    protected String getSpecificGroup(Configuration configuration) {
        return this.getPropertyValue(configuration, AbfsIDBProperty.IDBROKER_SPECIFIC_GROUP_METHOD);
    }

    @Override
    protected String getTruststorePath(Configuration configuration) {
        return this.getPropertyValue(configuration, AbfsIDBProperty.IDBROKER_TRUSTSTORE_LOCATION);
    }

    @Override
    protected char[] getTruststorePassword(Configuration configuration) throws IOException {
        char[] password = configuration.getPassword(AbfsIDBProperty.IDBROKER_TRUSTSTORE_PASS.getPropertyName());
        if (password == null) {
            password = configuration.getPassword(AbfsIDBProperty.IDBROKER_TRUSTSTORE_PASSWORD.getPropertyName());
        }
        return password;
    }

    @Override
    protected boolean getUseCertificateFromDT(Configuration configuration) {
        return this.getPropertyValueAsBoolean(configuration, AbfsIDBProperty.IDBROKER_USE_DT_CERT);
    }

    @Override
    protected String getDelegationTokensURL(Configuration configuration) {
        return this.buildUrl(this.getGatewayAddress(), this.getPropertyValue(configuration, AbfsIDBProperty.IDBROKER_DT_PATH));
    }

    @Override
    protected String getCredentialsURL(Configuration configuration) {
        return this.buildUrl(this.getGatewayAddress(), this.getPropertyValue(configuration, AbfsIDBProperty.IDBROKER_PATH));
    }

    @Override
    protected String getCredentialsType(Configuration configuration) {
        return this.getPropertyValue(configuration, AbfsIDBProperty.IDBROKER_CREDENTIALS_TYPE);
    }

    @Override
    protected String[] getGatewayAddress(Configuration configuration) {
        return configuration.getStrings(AbfsIDBProperty.IDBROKER_GATEWAY.getPropertyName(), new String[]{AbfsIDBProperty.IDBROKER_GATEWAY.getDefaultValue()});
    }

    @Override
    protected String getUsername(Configuration conf) {
        return this.getPropertyValue(conf, AbfsIDBProperty.IDBROKER_USERNAME);
    }

    @Override
    protected String getUsernamePropertyName() {
        return AbfsIDBProperty.IDBROKER_USERNAME.getPropertyName();
    }

    @Override
    protected String getPassword(Configuration conf) {
        return this.getPropertyValue(conf, AbfsIDBProperty.IDBROKER_PASSWORD);
    }

    @Override
    protected String getPasswordPropertyName() {
        return AbfsIDBProperty.IDBROKER_PASSWORD.getPropertyName();
    }

    @Override
    public AzureADToken extractCloudCredentialsFromResponse(BasicResponse basicResponse) throws IOException {
        AbfsAuthResponseMessage response = this.processGet(AbfsAuthResponseMessage.class, null, basicResponse);
        AzureADToken token = new AzureADToken();
        token.setAccessToken(response.getAccessToken());
        token.setExpiry(Date.from(response.getExpiry()));
        return token;
    }
}

