/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.knox.gateway.cloud.idbroker.IDBClient;
import org.apache.knox.gateway.cloud.idbroker.IDBConstants;
import org.apache.knox.gateway.cloud.idbroker.IDBProperty;
import org.apache.knox.gateway.cloud.idbroker.common.CommonUtils;
import org.apache.knox.gateway.cloud.idbroker.common.DefaultRequestExecutor;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.apache.knox.gateway.cloud.idbroker.common.Preconditions;
import org.apache.knox.gateway.cloud.idbroker.common.RequestExecutor;
import org.apache.knox.gateway.cloud.idbroker.messages.RequestDTResponseMessage;
import org.apache.knox.gateway.cloud.idbroker.messages.ValidationFailure;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.ClientContext;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.idbroker.Credentials;
import org.apache.knox.gateway.shell.idbroker.Group;
import org.apache.knox.gateway.shell.knox.token.CloudAccessBrokerTokenGet;
import org.apache.knox.gateway.shell.knox.token.Get;
import org.apache.knox.gateway.shell.knox.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIDBClient<CloudCredentialType>
implements IDBClient<CloudCredentialType> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIDBClient.class);
    protected static final String E_IDB_GATEWAY_UNDEFINED = "No IDB gateways have been defined";
    protected static final String E_NO_PRINCIPAL = "Unable to obtain Principal Name for authentication";
    protected static final String E_NO_KAUTH = "Trying to request full IDBroker session but not logged in with Kerberos.";
    private Configuration config;
    protected RequestExecutor requestExecutor;
    private boolean useCertificateFromDT;
    private String truststore;
    private String truststorePass;
    private String specificGroup;
    private String specificRole;
    private boolean onlyUser;
    private boolean onlyGroups;
    private UserGroupInformation owner;
    private String proxyUser;

    protected AbstractIDBClient(Configuration configuration, UserGroupInformation owner) throws IOException {
        this.initializeAsFullIDBClient(configuration, owner);
    }

    protected AbstractIDBClient() {
    }

    public List<String> getGatewayBaseURLs() {
        return this.requestExecutor.getConfiguredEndpoints();
    }

    public String getTruststorePath() {
        return this.truststore;
    }

    public String getTruststorePassword() {
        return this.truststorePass;
    }

    public String getCredentialsURL() {
        this.checkGatewayConfigured();
        return this.getCredentialsURL(this.config);
    }

    public String getIdbTokensURL() {
        this.checkGatewayConfigured();
        return this.getDelegationTokensURL(this.config);
    }

    @Override
    public boolean hasKerberosCredentials() {
        return this.owner != null && this.owner.hasKerberosCredentials();
    }

    @Override
    public Pair<KnoxSession, String> createKnoxDTSession(Configuration configuration) throws IOException {
        KnoxSession session = null;
        String sessionOrigin = null;
        String credentialsType = this.getCredentialsType(configuration);
        LOG.debug("IDBroker credentials type is {}", (Object)credentialsType);
        boolean useBasicAuth = credentialsType.equals("basic-auth");
        String hadoopAuth = configuration.get("hadoop.security.authentication", "simple");
        boolean isSimpleAuth = "simple".equalsIgnoreCase(hadoopAuth);
        if (useBasicAuth || isSimpleAuth) {
            LOG.debug("Authenticating with IDBroker for DT session via username and password");
            String errorPrefix = useBasicAuth ? "Authentication with username and password enabled" : "No kerberos session -falling back to username and password";
            String username = this.getUsername(configuration);
            if (StringUtils.isEmpty((CharSequence)username)) {
                throw new IOException(errorPrefix + " -missing configuration option: " + this.getUsernamePropertyName());
            }
            String password = this.getPassword(configuration);
            if (StringUtils.isEmpty((CharSequence)password)) {
                throw new IOException(errorPrefix + " -missing configuration option: " + this.getPasswordPropertyName());
            }
            sessionOrigin = "local credentials";
            session = this.createKnoxDTSession(username, password);
        } else if ("kerberos".equalsIgnoreCase(hadoopAuth)) {
            LOG.debug("Authenticating with IDBroker requires Kerberos");
            if (this.hasKerberosCredentials()) {
                LOG.debug("Kerberos credentials are available, using Kerberos to establish a session.");
                sessionOrigin = "local kerberos";
                session = this.createKnoxDTSession(this.owner);
            } else {
                LOG.debug("Kerberos credentials are not available, unable to establish a session.");
            }
        } else {
            LOG.warn("Unknown IDBroker authentication mechanism, unable to establish a session: \"{}\"", (Object)hadoopAuth);
        }
        return Pair.of(session, sessionOrigin);
    }

    @Override
    public CloudAccessBrokerSession createKnoxCABSession(KnoxToken knoxToken) throws IOException {
        Preconditions.checkNotNull(knoxToken, "Empty KnoxToken");
        return this.createKnoxCABSession(knoxToken.getAccessToken(), knoxToken.getTokenType(), knoxToken.getEndpointPublicCert());
    }

    @Override
    public CloudAccessBrokerSession createKnoxCABSession(String delegationToken, String endpointCert) throws IOException {
        return this.createKnoxSession(delegationToken, this.getCredentialsURL(), endpointCert, this.useCertificateFromDT);
    }

    @Override
    public CloudAccessBrokerSession createKnoxCABSession(String delegationToken, String delegationTokenType, String endpointCert) throws IOException {
        return this.createKnoxSession(delegationToken, delegationTokenType, this.getCredentialsURL(), endpointCert, this.useCertificateFromDT);
    }

    @Override
    public KnoxSession createKnoxDTSession() throws IOException {
        String url = this.getIdbTokensURL();
        Preconditions.checkNotNull(url, "No DT URL specified");
        try {
            LOG.debug("Logging in to {} using Kerberos", (Object)url);
            return CloudAccessBrokerSession.create((ClientContext)this.createKnoxClientContext(url, true));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public KnoxSession createKnoxDTSession(UserGroupInformation user) throws IOException {
        if (user == null) {
            return this.createKnoxDTSession();
        }
        try {
            return (KnoxSession)user.doAs(this::createKnoxDTSession);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public KnoxSession createKnoxDTSession(String username, String password) throws IOException {
        if (StringUtils.isEmpty((CharSequence)username)) {
            throw new AccessDeniedException("No IDBroker Username");
        }
        String url = this.getIdbTokensURL();
        try {
            LOG.debug("Logging in to {} as {}", (Object)url, (Object)username);
            return CloudAccessBrokerSession.create((ClientContext)this.createKnoxClientContext(url, username, password));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public KnoxSession createKnoxDTSession(KnoxToken knoxToken) throws IOException {
        String url = this.getIdbTokensURL();
        LOG.debug("Logging in to {} using a Knox DT", (Object)url);
        return this.createKnoxSession(knoxToken, url, this.useCertificateFromDT);
    }

    @Override
    public CloudCredentialType fetchCloudCredentials(CloudAccessBrokerSession session) throws IOException {
        Group.Request request;
        LOG.debug("Fetching cloud credentials from {}", (Object)session.base());
        IDBClient.IDBMethod method = this.determineIDBMethodToCall();
        switch (method) {
            case SPECIFIC_GROUP: {
                request = Credentials.forGroup((CloudAccessBrokerSession)session).groupName(this.specificGroup);
                break;
            }
            case SPECIFIC_ROLE: {
                request = Credentials.forRole((CloudAccessBrokerSession)session).roleid(this.specificRole);
                break;
            }
            case GROUPS_ONLY: {
                request = Credentials.forGroup((CloudAccessBrokerSession)session);
                break;
            }
            case USER_ONLY: {
                request = Credentials.forUser((CloudAccessBrokerSession)session);
                break;
            }
            default: {
                request = Credentials.get((CloudAccessBrokerSession)session);
            }
        }
        BasicResponse response = null;
        try {
            response = (BasicResponse)this.requestExecutor.execute(request);
        }
        catch (ErrorResponse e) {
            HttpEntity entity;
            HttpResponse r = e.getResponse();
            if (r.getStatusLine().getStatusCode() != 200 && (entity = r.getEntity()) != null) {
                String responseContent = EntityUtils.toString((HttpEntity)entity);
                LOG.error("Cloud Access Broker response: " + responseContent);
                if (entity.getContentType().getValue().contains("application/json")) {
                    throw new IOException(this.parseErrorResponse(responseContent));
                }
            }
            throw e;
        }
        return this.extractCloudCredentialsFromResponse(response);
    }

    private String parseErrorResponse(String response) {
        StringWriter message = new StringWriter();
        try {
            String groupId;
            ObjectMapper om = new ObjectMapper();
            Map json = (Map)om.readValue(response, (TypeReference)new TypeReference<Map<String, String>>(){});
            message.append((CharSequence)json.get("error"));
            String authId = (String)json.get("auth_id");
            if (authId != null && !authId.isEmpty()) {
                message.append(" (user: ").append(authId).append(")");
            }
            if ((groupId = (String)json.get("group_id")) != null && !groupId.isEmpty()) {
                message.append(" (group: ").append(groupId).append(")");
            }
        }
        catch (IOException e) {
            LOG.error("Failed parsing error response: " + e.getMessage());
        }
        return message.toString();
    }

    @Override
    public RequestDTResponseMessage requestKnoxDelegationToken(KnoxSession knoxSession, String origin, URI fsUri) throws IOException {
        LOG.trace("Getting a new Knox Delegation Token");
        Preconditions.checkNotNull(knoxSession, "Missing KnoxSession");
        Get.Request getRequest = Token.get((KnoxSession)knoxSession, (String)this.proxyUser);
        CloudAccessBrokerTokenGet request = new CloudAccessBrokerTokenGet(getRequest);
        LOG.debug("Fetching IDB access token from {} (session origin {})", (Object)request.getRequestURI(), (Object)origin);
        try {
            BasicResponse response;
            if (this.hasKerberosCredentials()) {
                if (this.owner.isFromKeytab()) {
                    this.owner.checkTGTAndReloginFromKeytab();
                } else {
                    this.owner.reloginFromTicketCache();
                }
                response = (BasicResponse)this.owner.doAs(() -> (BasicResponse)this.requestExecutor.execute(request));
            } else {
                response = (BasicResponse)this.requestExecutor.execute(request);
            }
            RequestDTResponseMessage struct = this.processGet(RequestDTResponseMessage.class, request.getRequestURI(), response);
            String access_token = struct.access_token;
            ValidationFailure.verify(StringUtils.isNotEmpty((CharSequence)access_token), "No access token from knox login of %s (session origin %s)", request.getRequestURI(), origin);
            return struct;
        }
        catch (KnoxShellException e) {
            throw this.translateException(request.getRequestURI(), "origin=" + origin + "; " + AbstractIDBClient.buildDiagnosticsString(fsUri, this.owner), e);
        }
        catch (Throwable t) {
            LOG.error(t.toString(), t);
            throw new IOException(t.toString(), t);
        }
    }

    @Override
    public RequestDTResponseMessage updateDelegationToken(KnoxToken knoxToken) throws Exception {
        return this.requestKnoxDelegationToken((KnoxSession)this.createKnoxCABSession(knoxToken), knoxToken.getOrigin(), null);
    }

    @Override
    public IDBClient.IDBMethod determineIDBMethodToCall() {
        IDBClient.IDBMethod method = IDBClient.IDBMethod.DEFAULT;
        if (this.onlyGroups) {
            method = IDBClient.IDBMethod.GROUPS_ONLY;
        }
        if (this.specificGroup != null) {
            method = IDBClient.IDBMethod.SPECIFIC_GROUP;
        }
        if (this.onlyUser) {
            method = IDBClient.IDBMethod.USER_ONLY;
        }
        if (this.specificRole != null) {
            method = IDBClient.IDBMethod.SPECIFIC_ROLE;
        }
        return method;
    }

    public static String buildDiagnosticsString(URI uri, UserGroupInformation user) {
        StringBuilder diagnostics = new StringBuilder(32);
        diagnostics.append("filesystem =").append(uri != null ? uri : "(null").append("; owner=").append(user != null ? user.getUserName() : "(null)").append("; ");
        if (user != null) {
            diagnostics.append("tokens=[");
            Collection tokens = user.getTokens();
            for (org.apache.hadoop.security.token.Token token : tokens) {
                diagnostics.append(token.toString()).append(';');
            }
            diagnostics.append(']');
        }
        return diagnostics.toString();
    }

    public String toString() {
        return "IDBClient{gateway=" + this.getGatewayAddress() + '}';
    }

    protected abstract boolean getOnlyUser(Configuration var1);

    protected abstract boolean getOnlyGroups(Configuration var1);

    protected abstract String getSpecificRole(Configuration var1);

    protected abstract String getSpecificGroup(Configuration var1);

    protected abstract String getTruststorePath(Configuration var1);

    protected abstract char[] getTruststorePassword(Configuration var1) throws IOException;

    protected abstract boolean getUseCertificateFromDT(Configuration var1);

    protected abstract String getDelegationTokensURL(Configuration var1);

    protected abstract String getCredentialsURL(Configuration var1);

    protected abstract String getCredentialsType(Configuration var1);

    protected abstract String[] getGatewayAddress(Configuration var1);

    protected abstract String getUsername(Configuration var1);

    protected abstract String getUsernamePropertyName();

    protected abstract String getPassword(Configuration var1);

    protected abstract String getPasswordPropertyName();

    @Override
    public String getGatewayAddress() {
        return this.requestExecutor.getEndpoint();
    }

    protected String buildUrl(String baseUrl, String path) {
        StringBuilder url = new StringBuilder(AbstractIDBClient.maybeAddTrailingSlash(baseUrl));
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            url.append(AbstractIDBClient.maybeRemoveLeadingSlash(path));
        }
        return url.toString();
    }

    protected IOException translateException(URI requestURI, String extraDiags, KnoxShellException e) {
        IOException ioe;
        String path = requestURI.toString();
        Throwable cause = e.getCause();
        if (cause instanceof ErrorResponse) {
            ErrorResponse error = (ErrorResponse)cause;
            HttpResponse response = error.getResponse();
            int status = response.getStatusLine().getStatusCode();
            String message = String.format(Locale.ROOT, "Error %03d from %s", status, path);
            if (!extraDiags.isEmpty()) {
                message = message + " " + extraDiags;
            }
            switch (status) {
                case 401: 
                case 403: {
                    ioe = new AccessDeniedException(path, null, message);
                    ioe.initCause(e);
                    break;
                }
                case 404: 
                case 410: {
                    ioe = new FileNotFoundException(message);
                    ioe.initCause(e);
                    break;
                }
                default: {
                    ioe = new IOException(message + "  " + (Object)((Object)e), e);
                    break;
                }
            }
        } else if (cause instanceof SSLHandshakeException) {
            ioe = new IOException(String.format(Locale.ROOT, "While connecting to %s: %s%s", path, e.toString(), extraDiags.isEmpty() ? "" : " (" + extraDiags + ")"), e);
            LOG.error(ioe.toString());
        } else {
            String errorMessage = e.toString();
            if (errorMessage.contains(E_NO_PRINCIPAL)) {
                errorMessage = errorMessage + " - Trying to request full IDBroker session but not logged in with Kerberos.";
            }
            ioe = new IOException("From " + path + " " + errorMessage + (extraDiags.isEmpty() ? "" : " " + extraDiags), e);
        }
        return ioe;
    }

    protected <T> T processGet(Class<T> clazz, @Nullable URI requestURI, BasicResponse response) throws IOException {
        String body;
        String dest;
        int statusCode = response.getStatusCode();
        String type = response.getContentType();
        String string = dest = requestURI != null ? requestURI.toString() : "path under " + this.getGatewayAddress();
        if (statusCode != 200) {
            body = response.getString();
            LOG.error("Bad response {} content-type {}\n{}", new Object[]{statusCode, type, body});
            ValidationFailure.verify(false, "Wrong status code %s from session auth to %s: %s", statusCode, dest, body);
        }
        ValidationFailure.verify(response.getContentLength() > 0L, "No content in response from %s; content type %s", dest, type);
        if (!"application/json".equals(type)) {
            body = response.getString();
            LOG.error("Bad response {} content-type {}\n{}", new Object[]{statusCode, type, body});
            ValidationFailure.verify(false, "Wrong content type %s from session auth under %s: %s", type, this.getGatewayAddress(), body);
        }
        JsonSerialization serDeser = new JsonSerialization(clazz, false, true);
        InputStream stream = response.getStream();
        return (T)serDeser.fromJsonStream(stream);
    }

    protected String getPropertyValue(Configuration configuration, IDBProperty property, boolean trimmed) {
        return trimmed ? configuration.getTrimmed(property.getPropertyName(), property.getDefaultValue()) : configuration.get(property.getPropertyName(), property.getDefaultValue());
    }

    protected String getPropertyValue(Configuration configuration, IDBProperty property) {
        return this.getPropertyValue(configuration, property, true);
    }

    protected Boolean getPropertyValueAsBoolean(Configuration configuration, IDBProperty property) {
        return configuration.getBoolean(property.getPropertyName(), Boolean.valueOf(property.getDefaultValue()).booleanValue());
    }

    private static String maybeAddTrailingSlash(String s) {
        return s.endsWith("/") ? s : s + "/";
    }

    private static String maybeRemoveLeadingSlash(String s) {
        return s.startsWith("/") ? s.substring(1) : s;
    }

    private void initializeAsFullIDBClient(Configuration configuration, UserGroupInformation owner) throws IOException {
        File f;
        this.owner = owner;
        if (owner != null && UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation realUser;
            if (LOG.isDebugEnabled()) {
                UserGroupInformation.logAllUserInfo((Logger)LOG, (UserGroupInformation)this.owner);
            }
            if ((realUser = this.owner.getRealUser()) != null) {
                this.proxyUser = this.owner.getShortUserName();
                this.owner = realUser;
            }
        }
        this.config = configuration;
        CommonUtils.ensureSSLClientConfigLoaded(this.config);
        String[] endpoints = this.getGatewayAddress(configuration);
        Preconditions.checkState(endpoints != null && endpoints.length > 0, "At least one CloudAccessBroker endpoint must be configured.");
        this.requestExecutor = new DefaultRequestExecutor(Arrays.asList(endpoints));
        if (LOG.isDebugEnabled()) {
            List<String> baseURLs = this.getGatewayBaseURLs();
            if (baseURLs.size() == 1) {
                LOG.debug("The configured IDBroker gateway is {}", (Object)baseURLs.get(0));
            } else {
                LOG.debug("The following IDBroker gateways have been configured, using {} (for now): \n\t{}", (Object)this.getGatewayAddress(), (Object)String.join((CharSequence)"\n\t", baseURLs));
            }
        }
        LOG.debug("IDBroker credentials URL is {}", (Object)this.getCredentialsURL());
        LOG.debug("IDBroker Knox Tokens URL is {}", (Object)this.getIdbTokensURL());
        this.useCertificateFromDT = this.getUseCertificateFromDT(configuration);
        this.truststore = this.getTruststorePath(configuration);
        if (this.truststore == null) {
            this.truststore = configuration.getTrimmed("ssl.client.truststore.location");
        }
        LOG.debug("Trust store is {}", (Object)(this.truststore != null ? this.truststore : "unset -using default path"));
        if (this.truststore != null && !(f = new File(this.truststore)).exists()) {
            throw new FileNotFoundException("Truststore not found: " + f.getAbsolutePath());
        }
        try {
            char[] trustPass = this.getTruststorePassword(configuration);
            if (trustPass == null) {
                trustPass = configuration.getPassword("ssl.client.truststore.password");
            }
            if (trustPass != null) {
                this.truststorePass = new String(trustPass);
            }
        }
        catch (IOException e) {
            LOG.debug("Problem with Configuration.getPassword()", (Throwable)e);
            this.truststorePass = IDBConstants.DEFAULT_CERTIFICATE_PASSWORD;
        }
        this.specificGroup = this.getSpecificGroup(configuration);
        this.specificRole = this.getSpecificRole(configuration);
        this.onlyGroups = this.getOnlyGroups(configuration);
        this.onlyUser = this.getOnlyUser(configuration);
        LOG.debug("Created client to {}", (Object)this.getGatewayAddress());
    }

    private void checkGatewayConfigured() {
        Preconditions.checkState(!StringUtils.isBlank((CharSequence)this.getGatewayAddress()), E_IDB_GATEWAY_UNDEFINED);
    }

    private CloudAccessBrokerSession createKnoxSession(KnoxToken knoxToken, String endPointUrl, boolean useEndpointCertificate) throws IOException {
        Preconditions.checkNotNull(knoxToken, "Empty KnoxToken");
        return this.createKnoxSession(knoxToken.getAccessToken(), endPointUrl, knoxToken.getEndpointPublicCert(), useEndpointCertificate);
    }

    private CloudAccessBrokerSession createKnoxSession(String delegationToken, String endPointUrl, String endpointCert, boolean useEndpointCertificate) throws IOException {
        return this.createKnoxSession(delegationToken, "Bearer", endPointUrl, endpointCert, useEndpointCertificate);
    }

    private CloudAccessBrokerSession createKnoxSession(String delegationToken, String delegationTokenType, String endpointUrl, String endpointCert, boolean useEndpointCertificate) throws IOException {
        Preconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)delegationToken), "Empty delegation token");
        Preconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)endpointUrl), "Empty endpoint");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Establishing Knox session with Cloud Access Broker at {}\n\tcert: {}{}", new Object[]{endpointUrl, StringUtils.isEmpty((CharSequence)endpointCert) ? "<N/A>" : endpointCert.substring(0, 4), useEndpointCertificate ? "" : " [disabled by request]"});
        }
        ClientContext context = this.createKnoxClientContext(endpointUrl, endpointCert, useEndpointCertificate);
        try {
            CloudAccessBrokerSession session = CloudAccessBrokerSession.create((ClientContext)context);
            String type = delegationTokenType == null ? "Bearer" : delegationTokenType;
            session.setHeaders(Collections.singletonMap("Authorization", type + " " + delegationToken));
            return session;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private ClientContext createKnoxClientContext(String endpointUrl, String username, String password) {
        return this.updateKnoxClientContext(ClientContext.with((String)username, (String)password, (String)endpointUrl), null, false, false);
    }

    private ClientContext createKnoxClientContext(String endpointUrl, boolean enableKerberos) {
        return this.updateKnoxClientContext(ClientContext.with((String)endpointUrl), null, false, enableKerberos);
    }

    private ClientContext createKnoxClientContext(String endpointUrl, String endpointCertificate, boolean useEndpointCertificate) {
        return this.updateKnoxClientContext(ClientContext.with((String)endpointUrl), endpointCertificate, useEndpointCertificate, false);
    }

    private ClientContext updateKnoxClientContext(ClientContext clientContext, String endpointCertificate, boolean useEndpointCertificate, boolean enableKerberos) {
        String trustStorePath;
        if (enableKerberos) {
            LOG.debug("Creating Knox client context enabling support for Kerberos");
            clientContext.kerberos().enable(true).debug(LOG.isDebugEnabled());
        }
        if (StringUtils.isNotEmpty((CharSequence)(trustStorePath = this.getTruststorePath()))) {
            LOG.debug("Creating Knox client context using the supplied truststore: {}", (Object)trustStorePath);
            clientContext.connection().withTruststore(trustStorePath, this.getTruststorePassword());
        }
        if (useEndpointCertificate && StringUtils.isNotEmpty((CharSequence)endpointCertificate)) {
            LOG.debug("Creating Knox client context using a supplied endpoint certificate");
            clientContext.connection().withPublicCertPem(endpointCertificate);
        }
        return clientContext;
    }
}

