/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InitializeTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ReplLastIdInfo;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.metastore.utils.StringableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
abstract class TxnHandler
implements TxnStore,
TxnStore.MutexAPI {
    protected static final char INITIATED_STATE = 'i';
    protected static final char WORKING_STATE = 'w';
    protected static final char READY_FOR_CLEANING = 'r';
    static final char FAILED_STATE = 'f';
    static final char SUCCEEDED_STATE = 's';
    static final char ATTEMPTED_STATE = 'a';
    protected static final char MAJOR_TYPE = 'a';
    protected static final char MINOR_TYPE = 'i';
    protected static final char TXN_ABORTED = 'a';
    protected static final char TXN_OPEN = 'o';
    protected static final char LOCK_ACQUIRED = 'a';
    protected static final char LOCK_WAITING = 'w';
    protected static final char LOCK_EXCLUSIVE = 'e';
    protected static final char LOCK_SHARED = 'r';
    protected static final char LOCK_SEMI_SHARED = 'w';
    private static final int ALLOWED_REPEATED_DEADLOCKS = 10;
    private static final Logger LOG = LoggerFactory.getLogger((String)TxnHandler.class.getName());
    private static DataSource connPool;
    private static DataSource connPoolMutex;
    private static boolean doRetryOnConnPool;
    private List<TransactionalMetaStoreEventListener> transactionalListeners;
    private static volatile int maxOpenTxns;
    private static volatile boolean tooManyOpenTxns;
    private int deadlockCnt;
    private long deadlockRetryInterval;
    protected Configuration conf;
    private static DatabaseProduct dbProduct;
    private static SQLGenerator sqlGenerator;
    private long timeout;
    private String identifierQuoteString;
    private long retryInterval;
    private int retryLimit;
    private int retryNum;
    private AtomicInteger numOpenTxns;
    private static final ReentrantLock derbyLock;
    private static final ConcurrentHashMap<String, Semaphore> derbyKey2Lock;
    private static final String hostname;
    private static String epochInCurrentTimezone;
    private static Map<LockType, Map<LockType, Map<LockState, LockAction>>> jumpTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.checkQFileTestHack();
        Class<TxnHandler> clazz = TxnHandler.class;
        synchronized (TxnHandler.class) {
            if (connPool == null) {
                Connection dbConn = null;
                try {
                    int maxPoolSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS);
                    long getConnectionTimeoutMs = 30000L;
                    connPool = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize, getConnectionTimeoutMs);
                    connPoolMutex = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize + TxnStore.MUTEX_KEY.values().length, getConnectionTimeoutMs);
                    dbConn = this.getDbConn(2);
                    this.determineDatabaseProduct(dbConn);
                    sqlGenerator = new SQLGenerator(dbProduct, conf);
                }
                catch (SQLException e) {
                    try {
                        String msg = "Unable to instantiate JDBC connection pooling, " + e.getMessage();
                        LOG.error(msg);
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        TxnHandler.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                TxnHandler.closeDbConn(dbConn);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.numOpenTxns = Metrics.getOrCreateGauge("num_open_transactions");
            this.timeout = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.TXN_TIMEOUT, TimeUnit.MILLISECONDS);
            TxnHandler.buildJumpTable();
            this.retryInterval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, TimeUnit.MILLISECONDS);
            this.retryLimit = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS);
            this.deadlockRetryInterval = this.retryInterval / 10L;
            maxOpenTxns = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.MAX_OPEN_TXNS);
            try {
                this.transactionalListeners = MetaStoreUtils.getMetaStoreListeners(TransactionalMetaStoreEventListener.class, conf, MetastoreConf.getVar(conf, MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS));
            }
            catch (MetaException e) {
                String msg = "Unable to get transaction listeners, " + e.getMessage();
                LOG.error(msg);
                throw new RuntimeException((Throwable)((Object)e));
            }
            return;
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException {
        GetOpenTxnsInfoResponse getOpenTxnsInfoResponse;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select ntxn_next - 1 from NEXT_TXN_ID";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            TxnHandler.close(rs);
            ArrayList<TxnInfo> txnInfos = new ArrayList<TxnInfo>();
            s = "select txn_id, txn_state, txn_user, txn_host, txn_started, txn_last_heartbeat from TXNS where txn_id <= " + hwm;
            LOG.debug("Going to execute query<" + s + ">");
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                TxnState state;
                char c = rs.getString(2).charAt(0);
                switch (c) {
                    case 'a': {
                        state = TxnState.ABORTED;
                        break;
                    }
                    case 'o': {
                        state = TxnState.OPEN;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected transaction state " + c + " found in txns table");
                    }
                }
                TxnInfo txnInfo = new TxnInfo(rs.getLong(1), state, rs.getString(3), rs.getString(4));
                txnInfo.setStartedTime(rs.getLong(5));
                txnInfo.setLastHeartbeatTime(rs.getLong(6));
                txnInfos.add(txnInfo);
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            getOpenTxnsInfoResponse = new GetOpenTxnsInfoResponse(hwm, txnInfos);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getOpenTxnsInfo");
                    throw new MetaException("Unable to select from transaction database: " + TxnHandler.getMessage(e) + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxnsInfo();
            }
        }
        TxnHandler.close(rs, stmt, dbConn);
        return getOpenTxnsInfoResponse;
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns() throws MetaException {
        GetOpenTxnsResponse getOpenTxnsResponse;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select ntxn_next - 1 from NEXT_TXN_ID";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            TxnHandler.close(rs);
            ArrayList<Long> openList = new ArrayList<Long>();
            s = "select txn_id, txn_state, txn_type from TXNS where txn_id <= " + hwm + " order by txn_id";
            LOG.debug("Going to execute query<" + s + ">");
            rs = stmt.executeQuery(s);
            long minOpenTxn = Long.MAX_VALUE;
            BitSet abortedBits = new BitSet();
            while (rs.next()) {
                TxnType txnType;
                long txnId = rs.getLong(1);
                char txnState = rs.getString(2).charAt(0);
                if (txnState == 'o') {
                    minOpenTxn = Math.min(minOpenTxn, txnId);
                }
                if ((txnType = TxnType.findByValue(rs.getInt(3))) == TxnType.READ_ONLY) continue;
                openList.add(txnId);
                if (txnState != 'a') continue;
                abortedBits.set(openList.size() - 1);
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            ByteBuffer byteBuffer = ByteBuffer.wrap(abortedBits.toByteArray());
            GetOpenTxnsResponse otr = new GetOpenTxnsResponse(hwm, openList, byteBuffer);
            if (minOpenTxn < Long.MAX_VALUE) {
                otr.setMin_open_txn(minOpenTxn);
            }
            getOpenTxnsResponse = otr;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getOpenTxns");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxns();
            }
        }
        TxnHandler.close(rs, stmt, dbConn);
        return getOpenTxnsResponse;
    }

    @Override
    @RetrySemantics.Idempotent
    public OpenTxnsResponse openTxns(OpenTxnRequest rqst) throws MetaException {
        OpenTxnsResponse openTxnsResponse;
        int numTxns;
        if (!tooManyOpenTxns && this.numOpenTxns.get() >= maxOpenTxns) {
            tooManyOpenTxns = true;
        }
        if (tooManyOpenTxns) {
            if ((double)this.numOpenTxns.get() < (double)maxOpenTxns * 0.9) {
                tooManyOpenTxns = false;
            } else {
                LOG.warn("Maximum allowed number of open transactions (" + maxOpenTxns + ") has been " + "reached. Current number of open transactions: " + this.numOpenTxns);
                throw new MetaException("Maximum allowed number of open transactions has been reached. See hive.max.open.txns.");
            }
        }
        if ((numTxns = rqst.getNum_txns()) <= 0) {
            throw new MetaException("Invalid input for number of txns: " + numTxns);
        }
        Connection dbConn = null;
        Statement stmt = null;
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            int maxTxns = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.TXN_MAX_OPEN_BATCH);
            if (numTxns > maxTxns) {
                numTxns = maxTxns;
            }
            stmt = dbConn.createStatement();
            List<Long> txnIds = this.openTxns(dbConn, stmt, rqst);
            LOG.debug("Going to commit");
            dbConn.commit();
            openTxnsResponse = new OpenTxnsResponse(txnIds);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "openTxns(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.openTxns(rqst);
            }
        }
        TxnHandler.close(null, stmt, dbConn);
        this.unlockInternal();
        return openTxnsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private List<Long> openTxns(Connection dbConn, Statement stmt, OpenTxnRequest rqst) throws SQLException, MetaException {
        block49: {
            block45: {
                block46: {
                    numTxns = rqst.getNum_txns();
                    rs = null;
                    insertPreparedStmts = null;
                    txnType = rqst.isSetTxn_type() != false ? rqst.getTxn_type() : TxnType.DEFAULT;
                    if (!rqst.isSetReplPolicy()) ** GOTO lbl23
                    targetTxnIdList = this.getTargetTxnIdList(rqst.getReplPolicy(), rqst.getReplSrcTxnIds(), dbConn);
                    if (targetTxnIdList.isEmpty()) break block45;
                    if (targetTxnIdList.size() != rqst.getReplSrcTxnIds().size()) {
                        TxnHandler.LOG.warn("target txn id number " + targetTxnIdList.toString() + " is not matching with source txn id number " + rqst.getReplSrcTxnIds().toString());
                    }
                    TxnHandler.LOG.info("Target transactions " + targetTxnIdList.toString() + " are present for repl policy :" + rqst.getReplPolicy() + " and Source transaction id : " + rqst.getReplSrcTxnIds().toString());
                    var9_9 = targetTxnIdList;
                    if (insertPreparedStmts == null) break block46;
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                }
                TxnHandler.close(rs);
                return var9_9;
            }
            try {
                txnType = TxnType.REPL_CREATED;
lbl23:
                // 2 sources

                s = TxnHandler.sqlGenerator.addForUpdateClause("select ntxn_next from NEXT_TXN_ID");
                TxnHandler.LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    throw new MetaException("Transaction database not properly configured, can't find next transaction id.");
                }
                first = rs.getLong(1);
                s = "update NEXT_TXN_ID set ntxn_next = " + (first + (long)numTxns);
                TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                txnIds = new ArrayList<Long>(numTxns);
                rows = new ArrayList<String>();
                params = new ArrayList<String>();
                params.add(rqst.getUser());
                params.add(rqst.getHostname());
                paramsList = new ArrayList<List<String>>(numTxns);
                dbEpochString = this.getDbEpochString();
                for (i = first; i < first + (long)numTxns; ++i) {
                    txnIds.add(i);
                    rows.add(i + "," + TxnHandler.quoteChar('o') + "," + dbEpochString + "," + dbEpochString + ",?,?," + txnType.getValue());
                    paramsList.add(params);
                }
                insertPreparedStmts = TxnHandler.sqlGenerator.createInsertValuesPreparedStmt(dbConn, "TXNS (txn_id, txn_state, txn_started, txn_last_heartbeat, txn_user, txn_host, txn_type)", rows, paramsList);
                for (Iterator<PreparedStatement> pst : insertPreparedStmts) {
                    pst.execute();
                }
                if (txnIds.size() == 1) {
                    s = "INSERT INTO MIN_HISTORY_LEVEL (MHL_TXNID, MHL_MIN_OPEN_TXNID) SELECT ?, MIN(TXN_ID) FROM TXNS WHERE TXN_STATE = " + TxnHandler.quoteChar('o');
                    TxnHandler.LOG.debug("Going to execute query <" + s + ">");
                    pstmt = dbConn.prepareStatement(s);
                    pst = null;
                    try {
                        pstmt.setLong(1, (Long)txnIds.get(0));
                        pstmt.execute();
                    }
                    catch (Throwable var18_26) {
                        pst = var18_26;
                        throw var18_26;
                    }
                    finally {
                        if (pstmt != null) {
                            if (pst != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (Throwable var18_25) {
                                    pst.addSuppressed(var18_25);
                                }
                            } else {
                                pstmt.close();
                            }
                        }
                    }
                    TxnHandler.LOG.info("Added entries to MIN_HISTORY_LEVEL with a single query for current txn: " + txnIds);
                } else {
                    s = "SELECT MIN(TXN_ID) FROM TXNS WHERE TXN_STATE = " + TxnHandler.quoteChar('o');
                    TxnHandler.LOG.debug("Going to execute query <" + s + ">");
                    minOpenTxnId = -1L;
                    minOpenTxnIdRs = stmt.executeQuery(s);
                    var19_31 = null;
                    try {
                        if (!minOpenTxnIdRs.next()) {
                            throw new IllegalStateException("Scalar query returned no rows?!?!!");
                        }
                        minOpenTxnId = minOpenTxnIdRs.getLong(1);
                    }
                    catch (Throwable var20_34) {
                        var19_31 = var20_34;
                        throw var20_34;
                    }
                    finally {
                        if (minOpenTxnIdRs != null) {
                            if (var19_31 != null) {
                                try {
                                    minOpenTxnIdRs.close();
                                }
                                catch (Throwable var20_33) {
                                    var19_31.addSuppressed(var20_33);
                                }
                            } else {
                                minOpenTxnIdRs.close();
                            }
                        }
                    }
                    rows.clear();
                    for (txnId = first; txnId < first + (long)numTxns; ++txnId) {
                        rows.add(txnId + ", " + minOpenTxnId);
                    }
                    inserts = TxnHandler.sqlGenerator.createInsertValuesStmt("MIN_HISTORY_LEVEL (MHL_TXNID, MHL_MIN_OPEN_TXNID)", rows);
                    for (String insert : inserts) {
                        TxnHandler.LOG.debug("Going to execute insert <" + insert + ">");
                        stmt.execute(insert);
                    }
                    TxnHandler.LOG.info("Added entries to MIN_HISTORY_LEVEL for current txns: (" + txnIds + ") with min_open_txn: " + minOpenTxnId);
                }
                if (rqst.isSetReplPolicy()) {
                    rowsRepl = new ArrayList<String>();
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                    insertPreparedStmts.clear();
                    params.clear();
                    paramsList.clear();
                    params.add(rqst.getReplPolicy());
                    for (i = 0; i < numTxns; ++i) {
                        rowsRepl.add("?," + rqst.getReplSrcTxnIds().get(i) + "," + txnIds.get(i));
                        paramsList.add(params);
                    }
                    insertPreparedStmts = TxnHandler.sqlGenerator.createInsertValuesPreparedStmt(dbConn, "REPL_TXN_MAP (RTM_REPL_POLICY, RTM_SRC_TXN_ID, RTM_TARGET_TXN_ID)", rowsRepl, paramsList);
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.execute();
                    }
                }
                if (this.transactionalListeners != null) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.OPEN_TXN, new OpenTxnEvent(txnIds, txnType), dbConn, TxnHandler.sqlGenerator);
                }
                var16_22 = txnIds;
                if (insertPreparedStmts == null) break block49;
            }
            catch (Throwable var23_38) {
                if (insertPreparedStmts != null) {
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                }
                TxnHandler.close(rs);
                throw var23_38;
            }
            for (PreparedStatement pst : insertPreparedStmts) {
                pst.close();
            }
        }
        TxnHandler.close(rs);
        return var16_22;
    }

    private List<Long> getTargetTxnIdList(String replPolicy, List<Long> sourceTxnIdList, Connection dbConn) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            ArrayList<String> inQueries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            ArrayList<Long> targetTxnIdList = new ArrayList<Long>();
            prefix.append("select RTM_TARGET_TXN_ID from REPL_TXN_MAP where ");
            suffix.append(" and RTM_REPL_POLICY = ?");
            TxnUtils.buildQueryWithINClause(this.conf, inQueries, prefix, suffix, sourceTxnIdList, "RTM_SRC_TXN_ID", false, false);
            List<String> params = Arrays.asList(replPolicy);
            for (String query : inQueries) {
                LOG.debug("Going to execute select <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(replPolicy));
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                rs = pst.executeQuery();
                while (rs.next()) {
                    targetTxnIdList.add(rs.getLong(1));
                }
                TxnHandler.closeStmt(pst);
            }
            LOG.debug("targetTxnid for srcTxnId " + sourceTxnIdList.toString() + " is " + ((Object)targetTxnIdList).toString());
            ArrayList<Long> arrayList = targetTxnIdList;
            return arrayList;
        }
        catch (SQLException e) {
            LOG.warn("failed to get target txn ids " + e.getMessage());
            throw e;
        }
        finally {
            TxnHandler.closeStmt(pst);
            TxnHandler.close(rs);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public long getTargetTxnId(String replPolicy, long sourceTxnId) throws MetaException {
        try {
            long l;
            List<Long> targetTxnIds;
            Connection dbConn;
            block8: {
                dbConn = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                targetTxnIds = this.getTargetTxnIdList(replPolicy, Collections.singletonList(sourceTxnId), dbConn);
                if (!targetTxnIds.isEmpty()) break block8;
                LOG.info("Txn {} not present for repl policy {}", (Object)sourceTxnId, (Object)replPolicy);
                long l2 = -1L;
                TxnHandler.closeDbConn(dbConn);
                this.unlockInternal();
                return l2;
            }
            try {
                assert (targetTxnIds.size() == 1);
                l = targetTxnIds.get(0);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getTargetTxnId(" + replPolicy + sourceTxnId + ")");
                    throw new MetaException("Unable to get target transaction id " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
            return l;
        }
        catch (RetryException e2) {
            return this.getTargetTxnId(replPolicy, sourceTxnId);
        }
    }

    private void deleteReplTxnMapEntry(Connection dbConn, long sourceTxnId, String replPolicy) throws SQLException {
        String s = "delete from REPL_TXN_MAP where RTM_SRC_TXN_ID = " + sourceTxnId + " and RTM_REPL_POLICY = ?";
        try (PreparedStatement pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(replPolicy));){
            LOG.info("Going to execute  <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(replPolicy));
            pst.executeUpdate();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void abortTxn(AbortTxnRequest rqst) throws NoSuchTxnException, MetaException, TxnAbortedException {
        txnid = rqst.getTxnid();
        sourceTxnId = -1L;
        try {
            block13: {
                block12: {
                    dbConn = null;
                    stmt = null;
                    this.lockInternal();
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    if (!rqst.isSetReplPolicy()) ** GOTO lbl23
                    sourceTxnId = rqst.getTxnid();
                    targetTxnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), Collections.singletonList(sourceTxnId), dbConn);
                    if (!targetTxnIds.isEmpty()) break block12;
                    TxnHandler.LOG.info("Target txn id is missing for source txn id : " + sourceTxnId + " and repl policy " + rqst.getReplPolicy());
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    return;
                }
                if (!TxnHandler.$assertionsDisabled && targetTxnIds.size() != 1) {
                    throw new AssertionError();
                }
                txnid = targetTxnIds.get(0);
lbl23:
                // 2 sources

                if ((txnRecord = this.lockTransactionRecord(stmt, txnid, Character.valueOf('o'))) != null) ** GOTO lbl36
                status = this.findTxnState(txnid, stmt);
                if (status != TxnStatus.ABORTED) break block13;
                if (rqst.isSetReplPolicy()) {
                    TxnHandler.LOG.warn("Invalid state ABORTED for transactions started using replication replay task");
                    this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                }
                TxnHandler.LOG.info("abortTxn(" + JavaUtils.txnIdToString(txnid) + ") requested by it is already " + (Object)TxnStatus.ABORTED);
                TxnHandler.close(null, stmt, dbConn);
                this.unlockInternal();
                return;
            }
            try {
                TxnHandler.raiseTxnUnexpectedState(status, txnid);
lbl36:
                // 2 sources

                this.abortTxns(dbConn, Collections.singletonList(txnid), true);
                if (rqst.isSetReplPolicy()) {
                    this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                }
                if (this.transactionalListeners != null) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent((Long)txnid, TxnRecord.access$000(txnRecord)), dbConn, TxnHandler.sqlGenerator);
                }
                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "abortTxn(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable var10_10) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw var10_10;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.abortTxn(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void abortTxns(AbortTxnsRequest rqst) throws MetaException {
        List<Long> txnIds = rqst.getTxn_ids();
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder("select TXN_ID, TXN_TYPE from TXNS where TXN_STATE = ").append(TxnHandler.quoteChar('o')).append(" and TXN_TYPE != ").append(TxnType.READ_ONLY.getValue()).append(" and ");
                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "TXN_ID", false, false);
                HashMap<Long, TxnType> nonReadOnlyTxns = new HashMap<Long, TxnType>();
                for (String query : queries) {
                    LOG.debug("Going to execute query<" + query + ">");
                    ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));
                    Throwable throwable = null;
                    try {
                        while (rs.next()) {
                            TxnType txnType = TxnType.findByValue(rs.getInt(2));
                            nonReadOnlyTxns.put(rs.getLong(1), txnType);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                int numAborted = this.abortTxns(dbConn, txnIds, false);
                if (numAborted != txnIds.size()) {
                    LOG.warn("Abort Transactions command only aborted " + numAborted + " out of " + txnIds.size() + " transactions. It's possible that the other " + (txnIds.size() - numAborted) + " transactions have been aborted or committed, or the transaction ids are invalid.");
                }
                if (this.transactionalListeners != null) {
                    for (Long txnId : txnIds) {
                        MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent(txnId, nonReadOnlyTxns.getOrDefault(txnId, TxnType.READ_ONLY)), dbConn, sqlGenerator);
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "abortTxns(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
        }
        catch (RetryException e) {
            this.abortTxns(rqst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReplId(Connection dbConn, ReplLastIdInfo replLastIdInfo) throws SQLException, MetaException {
        long tblId;
        List<String> params;
        String query;
        List<String> partList;
        String table;
        String db;
        String catalog;
        String lastReplId;
        Statement stmt;
        ResultSet rs;
        PreparedStatement pst;
        block15: {
            long dbId;
            block14: {
                pst = null;
                rs = null;
                stmt = null;
                lastReplId = TxnHandler.quoteString(Long.toString(replLastIdInfo.getLastReplId()));
                catalog = replLastIdInfo.isSetCatalog() ? StringUtils.normalizeIdentifier(replLastIdInfo.getCatalog()) : MetaStoreUtils.getDefaultCatalog(this.conf);
                db = StringUtils.normalizeIdentifier(replLastIdInfo.getDatabase());
                table = replLastIdInfo.isSetTable() ? StringUtils.normalizeIdentifier(replLastIdInfo.getTable()) : null;
                partList = replLastIdInfo.isSetPartitionList() ? replLastIdInfo.getPartitionList() : null;
                stmt = dbConn.createStatement();
                if (sqlGenerator.getDbProduct() == DatabaseProduct.MYSQL) {
                    stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
                }
                query = "select \"DB_ID\" from \"DBS\" where \"NAME\" = ?  and \"CTLG_NAME\" = ?";
                params = Arrays.asList(db, catalog);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(db), (Object)TxnHandler.quoteString(catalog));
                rs = pst.executeQuery();
                if (rs == null || !rs.next()) {
                    throw new MetaException(" db with name " + db + " does not exist in catalog " + catalog);
                }
                dbId = rs.getLong(1);
                rs = stmt.executeQuery("select \"PARAM_VALUE\" from \"DATABASE_PARAMS\" where \"PARAM_KEY\" = 'repl.last.id' and \"DB_ID\" = " + dbId);
                if (rs == null || !rs.next()) {
                    stmt.executeUpdate("insert into \"DATABASE_PARAMS\" values ( " + dbId + " , 'repl.last.id' , " + lastReplId + ")");
                } else {
                    stmt.executeUpdate("update \"DATABASE_PARAMS\" set \"PARAM_VALUE\" = " + lastReplId + " where \"DB_ID\" = " + dbId + " and \"PARAM_KEY\" = 'repl.last.id'");
                }
                if (table != null) break block14;
                TxnHandler.closeStmt(stmt);
                TxnHandler.close(rs);
                TxnHandler.closeStmt(pst);
                return;
            }
            query = "select \"TBL_ID\" from \"TBLS\" where \"TBL_NAME\" = ? and \"DB_ID\" = " + dbId;
            params = Arrays.asList(table);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
            LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(table));
            rs = pst.executeQuery();
            if (rs == null || !rs.next()) {
                throw new MetaException(" table with name " + table + " does not exist in db " + catalog + "." + db);
            }
            tblId = rs.getLong(1);
            rs = stmt.executeQuery("select \"PARAM_VALUE\" from \"TABLE_PARAMS\" where \"PARAM_KEY\" = 'repl.last.id' and \"TBL_ID\" = " + tblId);
            if (rs == null || !rs.next()) {
                stmt.executeUpdate("insert into \"TABLE_PARAMS\" values ( " + tblId + " , 'repl.last.id' , " + lastReplId + ")");
            } else {
                stmt.executeUpdate("update \"TABLE_PARAMS\" set \"PARAM_VALUE\" = " + lastReplId + " where \"TBL_ID\" = " + tblId + " and \"PARAM_KEY\" = 'repl.last.id'");
            }
            if (partList != null && !partList.isEmpty()) break block15;
            TxnHandler.closeStmt(stmt);
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            return;
        }
        try {
            for (String part : partList) {
                query = "select \"PART_ID\" from \"PARTITIONS\" where \"TBL_ID\" = " + tblId + " and " + "\"PART_NAME\" = ? ";
                params = Arrays.asList(part);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(part));
                rs = pst.executeQuery();
                if (rs == null || !rs.next()) {
                    throw new MetaException(" partition with name " + part + " does not exist in table " + catalog + "." + db + "." + table);
                }
                long partId = rs.getLong(1);
                rs = stmt.executeQuery("select \"PARAM_VALUE\" from \"PARTITION_PARAMS\" where \"PARAM_KEY\"  = 'repl.last.id' and \"PART_ID\" = " + partId);
                if (rs == null || !rs.next()) {
                    stmt.executeUpdate("insert into \"PARTITION_PARAMS\" values ( " + partId + " , 'repl.last.id' , " + lastReplId + ")");
                    continue;
                }
                stmt.executeUpdate("update \"PARTITION_PARAMS\" set \"PARAM_VALUE\" = " + lastReplId + " where \"PART_ID\" = " + partId + " and \"PARAM_KEY\" = 'repl.last.id'");
            }
        }
        catch (Throwable throwable) {
            TxnHandler.closeStmt(stmt);
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            throw throwable;
        }
        TxnHandler.closeStmt(stmt);
        TxnHandler.close(rs);
        TxnHandler.closeStmt(pst);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent(value={"No-op if already committed"})
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        isUpdateDelete = 'N';
        txnid = rqst.getTxnid();
        sourceTxnId = -1L;
        try {
            block34: {
                block32: {
                    block33: {
                        block30: {
                            block31: {
                                dbConn = null;
                                stmt = null;
                                insertPreparedStmts = null;
                                commitIdRs = null;
                                this.lockInternal();
                                dbConn = this.getDbConn(2);
                                if (rqst.isSetReplLastIdInfo()) {
                                    this.updateReplId(dbConn, rqst.getReplLastIdInfo());
                                }
                                stmt = dbConn.createStatement();
                                if (!rqst.isSetReplPolicy()) ** GOTO lbl33
                                sourceTxnId = rqst.getTxnid();
                                targetTxnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), Collections.singletonList(sourceTxnId), dbConn);
                                if (!targetTxnIds.isEmpty()) break block30;
                                TxnHandler.LOG.info("Target txn id is missing for source txn id : " + sourceTxnId + " and repl policy " + rqst.getReplPolicy());
                                if (insertPreparedStmts == null) break block31;
                                for (PreparedStatement pst : insertPreparedStmts) {
                                    TxnHandler.closeStmt(pst);
                                }
                            }
                            TxnHandler.close(commitIdRs, stmt, dbConn);
                            this.unlockInternal();
                            return;
                        }
                        if (!TxnHandler.$assertionsDisabled && targetTxnIds.size() != 1) {
                            throw new AssertionError();
                        }
                        txnid = targetTxnIds.get(0);
lbl33:
                        // 2 sources

                        if ((txnRecord = this.lockTransactionRecord(stmt, txnid, Character.valueOf('o'))) != null) ** GOTO lbl50
                        actualTxnStatus = this.findTxnState(txnid, stmt);
                        if (actualTxnStatus != TxnStatus.COMMITTED) break block32;
                        if (rqst.isSetReplPolicy()) {
                            TxnHandler.LOG.warn("Invalid state COMMITTED for transactions started using replication replay task");
                        }
                        TxnHandler.LOG.info("Nth commitTxn(" + JavaUtils.txnIdToString(txnid) + ") msg");
                        if (insertPreparedStmts == null) break block33;
                        for (PreparedStatement pst : insertPreparedStmts) {
                            TxnHandler.closeStmt(pst);
                        }
                    }
                    TxnHandler.close(commitIdRs, stmt, dbConn);
                    this.unlockInternal();
                    return;
                }
                try {
                    TxnHandler.raiseTxnUnexpectedState(actualTxnStatus, txnid);
lbl50:
                    // 2 sources

                    conflictSQLSuffix = null;
                    if (rqst.isSetReplPolicy()) {
                        rs = null;
                    } else {
                        conflictSQLSuffix = "from TXN_COMPONENTS where tc_txnid=" + txnid + " and tc_operation_type IN(" + TxnHandler.quoteChar(OperationType.access$100(OperationType.UPDATE)) + "," + TxnHandler.quoteChar(OperationType.access$100(OperationType.DELETE)) + ")";
                        rs = stmt.executeQuery(TxnHandler.sqlGenerator.addLimitClause(1, "tc_operation_type " + conflictSQLSuffix));
                    }
                    if (rs != null && rs.next()) {
                        isUpdateDelete = 'Y';
                        TxnHandler.close(rs);
                        commitIdRs = stmt.executeQuery(TxnHandler.sqlGenerator.addForUpdateClause("select ntxn_next - 1 from NEXT_TXN_ID"));
                        if (!commitIdRs.next()) {
                            throw new IllegalStateException("No rows found in NEXT_TXN_ID");
                        }
                        commitId = commitIdRs.getLong(1);
                        undoWriteSetForCurrentTxn = dbConn.setSavepoint();
                        stmt.executeUpdate("insert into WRITE_SET (ws_database, ws_table, ws_partition, ws_txnid, ws_commit_id, ws_operation_type) select distinct tc_database, tc_table, tc_partition, tc_txnid, " + commitId + ", tc_operation_type " + conflictSQLSuffix);
                        rs = stmt.executeQuery(TxnHandler.sqlGenerator.addLimitClause(1, "committed.ws_txnid, committed.ws_commit_id, committed.ws_database,committed.ws_table, committed.ws_partition, cur.ws_commit_id cur_ws_commit_id, cur.ws_operation_type cur_op, committed.ws_operation_type committed_op from WRITE_SET committed INNER JOIN WRITE_SET cur ON committed.ws_database=cur.ws_database and committed.ws_table=cur.ws_table and (committed.ws_partition=cur.ws_partition or (committed.ws_partition is null and cur.ws_partition is null)) where cur.ws_txnid <= committed.ws_commit_id and cur.ws_txnid=" + txnid + " and committed.ws_txnid <> " + txnid + " and (committed.ws_operation_type IN(" + TxnHandler.quoteChar(OperationType.access$100(OperationType.UPDATE)) + ", " + TxnHandler.quoteChar(OperationType.access$100(OperationType.DELETE)) + ") AND cur.ws_operation_type IN(" + TxnHandler.quoteChar(OperationType.access$100(OperationType.UPDATE)) + ", " + TxnHandler.quoteChar(OperationType.access$100(OperationType.DELETE)) + "))"));
                        if (rs.next()) {
                            committedTxn = "[" + JavaUtils.txnIdToString(rs.getLong(1)) + "," + rs.getLong(2) + "]";
                            resource = new StringBuilder(rs.getString(3)).append("/").append(rs.getString(4));
                            partitionName = rs.getString(5);
                            if (partitionName != null) {
                                resource.append('/').append(partitionName);
                            }
                            msg = "Aborting [" + JavaUtils.txnIdToString(txnid) + "," + rs.getLong(6) + "]" + " due to a write conflict on " + resource + " committed by " + committedTxn + " " + rs.getString(7) + "/" + rs.getString(8);
                            TxnHandler.close(rs);
                            dbConn.rollback(undoWriteSetForCurrentTxn);
                            TxnHandler.LOG.info(msg);
                            if (this.abortTxns(dbConn, Collections.singletonList(txnid), true) != 1) {
                                throw new IllegalStateException(msg + " FAILED!");
                            }
                            dbConn.commit();
                            TxnHandler.close(null, stmt, dbConn);
                            throw new TxnAbortedException(msg);
                        }
                    }
                    if (!rqst.isSetReplPolicy()) {
                        s = "insert into COMPLETED_TXN_COMPONENTS (ctc_txnid, ctc_database, ctc_table, ctc_partition, ctc_writeid, ctc_update_delete) select tc_txnid, tc_database, tc_table, tc_partition, tc_writeid, '" + isUpdateDelete + "' from TXN_COMPONENTS where tc_txnid = " + txnid + " AND tc_operation_type <> " + TxnHandler.quoteChar(OperationType.access$100(OperationType.COMPACT));
                        TxnHandler.LOG.debug("Going to execute insert <" + s + ">");
                        modCount = 0;
                        modCount = stmt.executeUpdate(s);
                        if (modCount < 1) {
                            TxnHandler.LOG.info("Expected to move at least one record from txn_components to completed_txn_components when committing txn! " + JavaUtils.txnIdToString(txnid));
                        }
                    } else {
                        if (rqst.isSetWriteEventInfos()) {
                            rows = new ArrayList<String>();
                            paramsList = new ArrayList<List<String>>();
                            for (WriteEventInfo writeEventInfo : rqst.getWriteEventInfos()) {
                                rows.add(txnid + ", ?, ?, ?," + writeEventInfo.getWriteId() + "," + TxnHandler.quoteChar(isUpdateDelete));
                                params = new ArrayList<String>();
                                params.add(writeEventInfo.getDatabase());
                                params.add(writeEventInfo.getTable());
                                params.add(writeEventInfo.getPartition());
                                paramsList.add(params);
                            }
                            insertPreparedStmts = TxnHandler.sqlGenerator.createInsertValuesPreparedStmt(dbConn, "COMPLETED_TXN_COMPONENTS (ctc_txnid, ctc_database, ctc_table, ctc_partition, ctc_writeid, ctc_update_delete)", rows, paramsList);
                            for (PreparedStatement pst : insertPreparedStmts) {
                                pst.execute();
                            }
                        }
                        this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                    }
                    s = "delete from TXN_COMPONENTS where tc_txnid = " + txnid;
                    TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                    stmt.executeUpdate(s);
                    s = "delete from HIVE_LOCKS where hl_txnid = " + txnid;
                    TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                    stmt.executeUpdate(s);
                    s = "delete from TXNS where txn_id = " + txnid;
                    TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                    stmt.executeUpdate(s);
                    s = "delete from MIN_HISTORY_LEVEL where mhl_txnid = " + txnid;
                    TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                    stmt.executeUpdate(s);
                    TxnHandler.LOG.info("Removed committed transaction: (" + txnid + ") from MIN_HISTORY_LEVEL");
                    s = "delete from MATERIALIZATION_REBUILD_LOCKS where mrl_txn_id = " + txnid;
                    TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                    stmt.executeUpdate(s);
                    if (this.transactionalListeners != null) {
                        MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.COMMIT_TXN, new CommitTxnEvent((Long)txnid, TxnRecord.access$000((TxnRecord)txnRecord)), dbConn, TxnHandler.sqlGenerator);
                    }
                    TxnHandler.LOG.debug("Going to commit");
                    TxnHandler.close(rs);
                    dbConn.commit();
                    if (insertPreparedStmts == null) break block34;
                }
                catch (SQLException e) {
                    try {
                        TxnHandler.LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "commitTxn(" + rqst + ")");
                        throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable var21_31) {
                        if (insertPreparedStmts != null) {
                            for (PreparedStatement pst : insertPreparedStmts) {
                                TxnHandler.closeStmt(pst);
                            }
                        }
                        TxnHandler.close(commitIdRs, stmt, dbConn);
                        this.unlockInternal();
                        throw var21_31;
                    }
                }
                for (PreparedStatement pst : insertPreparedStmts) {
                    TxnHandler.closeStmt(pst);
                }
            }
            TxnHandler.close(commitIdRs, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.commitTxn(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent(value={"No-op if already replicated the writeid state"})
    public void replTableWriteIdState(ReplTblWriteIdStateRequest rqst) throws MetaException {
        String dbName = rqst.getDbName().toLowerCase();
        String tblName = rqst.getTableName().toLowerCase();
        ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(rqst.getValidWriteIdlist());
        List<Long> abortedWriteIds = this.getAbortedWriteIds((ValidWriteIdList)validWriteIdList);
        int numAbortedWrites = abortedWriteIds.size();
        try {
            TxnStore.MutexAPI.LockHandle handle;
            ResultSet rs;
            PreparedStatement pStmt;
            Statement stmt;
            Connection dbConn;
            block25: {
                Object sql;
                List<String> params;
                List<PreparedStatement> insertPreparedStmts;
                block23: {
                    block24: {
                        dbConn = null;
                        stmt = null;
                        pStmt = null;
                        insertPreparedStmts = null;
                        rs = null;
                        handle = null;
                        params = Arrays.asList(dbName, tblName);
                        this.lockInternal();
                        dbConn = this.getDbConn(2);
                        stmt = dbConn.createStatement();
                        sql = "select nwi_next from NEXT_WRITE_ID where nwi_database = ? and nwi_table = ?";
                        pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, (String)sql, params);
                        LOG.debug("Going to execute query <" + ((String)sql).replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                        rs = pStmt.executeQuery();
                        if (!rs.next()) break block23;
                        LOG.info("Idempotent flow: WriteId state <" + validWriteIdList + "> is already applied for the table: " + dbName + "." + tblName);
                        TxnHandler.rollbackDBConn(dbConn);
                        if (insertPreparedStmts == null) break block24;
                        for (PreparedStatement pst : insertPreparedStmts) {
                            TxnHandler.closeStmt(pst);
                        }
                    }
                    TxnHandler.closeStmt(pStmt);
                    TxnHandler.close(rs, stmt, dbConn);
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                    this.unlockInternal();
                    return;
                }
                try {
                    if (numAbortedWrites > 0) {
                        List<Long> txnIds = this.openTxns(dbConn, stmt, new OpenTxnRequest(numAbortedWrites, rqst.getUser(), rqst.getHostName()));
                        assert (numAbortedWrites == txnIds.size());
                        ArrayList<String> rows = new ArrayList<String>();
                        ArrayList<List<String>> paramsList = new ArrayList<List<String>>();
                        int i = 0;
                        Iterator<Object> iterator = txnIds.iterator();
                        while (iterator.hasNext()) {
                            long txn = iterator.next();
                            long writeId = abortedWriteIds.get(i++);
                            rows.add(txn + ", ?, ?, " + writeId);
                            paramsList.add(params);
                            LOG.info("Allocated writeID: " + writeId + " for txnId: " + txn);
                        }
                        insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "TXN_TO_WRITE_ID (t2w_txnid, t2w_database, t2w_table, t2w_writeid)", rows, paramsList);
                        for (PreparedStatement pst : insertPreparedStmts) {
                            pst.execute();
                        }
                        int numAborts = this.abortTxns(dbConn, txnIds, true);
                        assert (numAborts == numAbortedWrites);
                    }
                    handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.WriteIdAllocator.name());
                    long nextWriteId = validWriteIdList.getHighWatermark() + 1L;
                    sql = "insert into NEXT_WRITE_ID (nwi_database, nwi_table, nwi_next) values (?, ?, " + Long.toString(nextWriteId) + ")";
                    TxnHandler.closeStmt(pStmt);
                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, (String)sql, params);
                    LOG.debug("Going to execute insert <" + ((String)sql).replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                    pStmt.execute();
                    LOG.info("WriteId state <" + validWriteIdList + "> is applied for the table: " + dbName + "." + tblName);
                    LOG.debug("Going to commit");
                    dbConn.commit();
                    if (insertPreparedStmts == null) break block25;
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "replTableWriteIdState(" + rqst + ")");
                        throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        if (insertPreparedStmts != null) {
                            for (PreparedStatement pst : insertPreparedStmts) {
                                TxnHandler.closeStmt(pst);
                            }
                        }
                        TxnHandler.closeStmt(pStmt);
                        TxnHandler.close(rs, stmt, dbConn);
                        if (handle != null) {
                            handle.releaseLocks();
                        }
                        this.unlockInternal();
                        throw throwable;
                    }
                }
                for (PreparedStatement pst : insertPreparedStmts) {
                    TxnHandler.closeStmt(pst);
                }
            }
            TxnHandler.closeStmt(pStmt);
            TxnHandler.close(rs, stmt, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.replTableWriteIdState(rqst);
        }
        if (numAbortedWrites > 0) {
            CompactionRequest compactRqst = new CompactionRequest(rqst.getDbName(), rqst.getTableName(), CompactionType.MAJOR);
            if (rqst.isSetPartNames()) {
                for (String partName : rqst.getPartNames()) {
                    compactRqst.setPartitionname(partName);
                    this.compact(compactRqst);
                }
            } else {
                this.compact(compactRqst);
            }
        }
    }

    private List<Long> getAbortedWriteIds(ValidWriteIdList validWriteIdList) {
        ArrayList<Long> abortedWriteIds = new ArrayList<Long>();
        for (long writeId : validWriteIdList.getInvalidWriteIds()) {
            if (!validWriteIdList.isWriteIdAborted(writeId)) continue;
            abortedWriteIds.add(writeId);
        }
        return abortedWriteIds;
    }

    private ValidTxnList getValidTxnList(Connection dbConn, String fullTableName, Long writeId) throws MetaException, SQLException {
        block4: {
            ValidTxnList validTxnList;
            PreparedStatement pst = null;
            ResultSet rs = null;
            try {
                String[] names = TxnUtils.getDbTableName(fullTableName);
                assert (names.length == 2);
                String s = "select t2w_txnid from TXN_TO_WRITE_ID where  t2w_database = ? and t2w_table = ? and t2w_writeid = ?";
                pst = dbConn.prepareStatement(sqlGenerator.addEscapeCharacters(s));
                pst.setString(1, names[0]);
                pst.setString(2, names[1]);
                pst.setLong(3, writeId);
                LOG.debug("Going to execute query <" + s.replaceAll("\\?", "{}") + ">", new Object[]{TxnHandler.quoteString(names[0]), TxnHandler.quoteString(names[1]), writeId});
                rs = pst.executeQuery();
                if (!rs.next()) break block4;
                validTxnList = TxnUtils.createValidReadTxnList(this.getOpenTxns(), rs.getLong(1));
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, pst, null);
                throw throwable;
            }
            TxnHandler.close(rs, pst, null);
            return validTxnList;
        }
        throw new MetaException("invalid write id " + writeId + " for table " + fullTableName);
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetValidWriteIdsResponse getValidWriteIds(GetValidWriteIdsRequest rqst) throws MetaException {
        GetValidWriteIdsResponse getValidWriteIdsResponse;
        Connection dbConn = null;
        Object validTxnList = rqst.isSetValidTxnList() ? new ValidReadTxnList(rqst.getValidTxnList()) : TxnUtils.createValidReadTxnList(this.getOpenTxns(), 0L);
        try {
            GetValidWriteIdsResponse owr;
            dbConn = this.getDbConn(2);
            if (rqst.isSetValidTxnList()) {
                assert (!rqst.isSetWriteId());
                validTxnList = new ValidReadTxnList(rqst.getValidTxnList());
            } else {
                validTxnList = rqst.isSetWriteId() ? this.getValidTxnList(dbConn, rqst.getFullTableNames().get(0), rqst.getWriteId()) : TxnUtils.createValidReadTxnList(this.getOpenTxns(), 0L);
            }
            ArrayList<TableValidWriteIds> tblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
            for (String fullTableName : rqst.getFullTableNames()) {
                tblValidWriteIdsList.add(this.getValidWriteIdsForTable(dbConn, fullTableName, (ValidTxnList)validTxnList));
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            getValidWriteIdsResponse = owr = new GetValidWriteIdsResponse(tblValidWriteIdsList);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getValidWriteIds");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getValidWriteIds(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return getValidWriteIdsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableValidWriteIds getValidWriteIdsForTable(Connection dbConn, String fullTableName, ValidTxnList validTxnList) throws SQLException {
        TableValidWriteIds tableValidWriteIds;
        PreparedStatement pst = null;
        ResultSet rs = null;
        String[] names = TxnUtils.getDbTableName(fullTableName);
        assert (names.length == 2);
        List<String> params = Arrays.asList(names[0], names[1]);
        try {
            long writeIdHwm = 0L;
            ArrayList<Long> invalidWriteIdList = new ArrayList<Long>();
            long minOpenWriteId = Long.MAX_VALUE;
            BitSet abortedBits = new BitSet();
            long txnHwm = validTxnList.getHighWatermark();
            String s = "select max(t2w_writeid) from TXN_TO_WRITE_ID where t2w_txnid <= " + Long.toString(txnHwm) + " and t2w_database = ? and t2w_table = ?";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            LOG.debug("Going to execute query<" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
            rs = pst.executeQuery();
            if (rs.next()) {
                writeIdHwm = rs.getLong(1);
            }
            if (writeIdHwm <= 0L) {
                s = "select nwi_next-1 from NEXT_WRITE_ID where nwi_database = ? and nwi_table = ?";
                TxnHandler.closeStmt(pst);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute query<" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
                rs = pst.executeQuery();
                if (rs.next()) {
                    writeIdHwm = rs.getLong(1);
                }
            }
            boolean foundValidUncompactedWrite = false;
            s = "select t2w_txnid, t2w_writeid from TXN_TO_WRITE_ID where t2w_writeid <= " + Long.toString(writeIdHwm) + " and t2w_database = ? and t2w_table = ? order by t2w_writeid asc";
            TxnHandler.closeStmt(pst);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            LOG.debug("Going to execute query<" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
            rs = pst.executeQuery();
            while (rs.next()) {
                long txnId = rs.getLong(1);
                long writeId = rs.getLong(2);
                if (validTxnList.isTxnValid(txnId)) {
                    foundValidUncompactedWrite = true;
                    continue;
                }
                invalidWriteIdList.add(writeId);
                if (validTxnList.isTxnAborted(txnId)) {
                    abortedBits.set(invalidWriteIdList.size() - 1);
                    continue;
                }
                minOpenWriteId = Math.min(minOpenWriteId, writeId);
            }
            if (!foundValidUncompactedWrite) {
                long writeId = invalidWriteIdList.isEmpty() ? -1L : (Long)invalidWriteIdList.get(0);
                invalidWriteIdList = new ArrayList();
                abortedBits = new BitSet();
                if (writeId != -1L) {
                    invalidWriteIdList.add(writeId);
                    writeIdHwm = writeId;
                    if (writeId != minOpenWriteId) {
                        abortedBits.set(0);
                    }
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(abortedBits.toByteArray());
            TableValidWriteIds owi = new TableValidWriteIds(fullTableName, writeIdHwm, invalidWriteIdList, byteBuffer);
            if (minOpenWriteId < Long.MAX_VALUE) {
                owi.setMinOpenWriteId(minOpenWriteId);
            }
            tableValidWriteIds = owi;
        }
        catch (Throwable throwable) {
            TxnHandler.closeStmt(pst);
            TxnHandler.close(rs);
            throw throwable;
        }
        TxnHandler.closeStmt(pst);
        TxnHandler.close(rs);
        return tableValidWriteIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public AllocateTableWriteIdsResponse allocateTableWriteIds(AllocateTableWriteIdsRequest rqst) throws MetaException {
        String dbName = rqst.getDbName().toLowerCase();
        String tblName = rqst.getTableName().toLowerCase();
        try {
            Object object;
            TxnStore.MutexAPI.LockHandle handle;
            ResultSet rs;
            List<PreparedStatement> insertPreparedStmts;
            PreparedStatement pStmt;
            Statement stmt;
            Connection dbConn;
            block42: {
                AllocateTableWriteIdsResponse allocateTableWriteIdsResponse;
                block40: {
                    Iterator iterator;
                    block41: {
                        dbConn = null;
                        stmt = null;
                        pStmt = null;
                        insertPreparedStmts = null;
                        rs = null;
                        handle = null;
                        ArrayList<TxnToWriteId> txnToWriteIds = new ArrayList<TxnToWriteId>();
                        List<TxnToWriteId> srcTxnToWriteIds = null;
                        try {
                            List<Long> txnIds;
                            this.lockInternal();
                            dbConn = this.getDbConn(2);
                            stmt = dbConn.createStatement();
                            if (rqst.isSetReplPolicy()) {
                                srcTxnToWriteIds = rqst.getSrcTxnToWriteIdList();
                                ArrayList<Long> srcTxnIds = new ArrayList<Long>();
                                assert (rqst.isSetSrcTxnToWriteIdList());
                                assert (!rqst.isSetTxnIds());
                                assert (!srcTxnToWriteIds.isEmpty());
                                for (TxnToWriteId txnToWriteId : srcTxnToWriteIds) {
                                    srcTxnIds.add(txnToWriteId.getTxnId());
                                }
                                txnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), srcTxnIds, dbConn);
                                if (srcTxnIds.size() != txnIds.size()) {
                                    LOG.info("Idempotent case: Target txn id is missing for source txn id : " + ((Object)srcTxnIds).toString() + " and repl policy " + rqst.getReplPolicy());
                                    AllocateTableWriteIdsResponse allocateTableWriteIdsResponse2 = new AllocateTableWriteIdsResponse(txnToWriteIds);
                                    return allocateTableWriteIdsResponse2;
                                }
                            } else {
                                assert (!rqst.isSetSrcTxnToWriteIdList());
                                assert (rqst.isSetTxnIds());
                                txnIds = rqst.getTxnIds();
                            }
                            if (txnIds.size() > 1) {
                                Collections.sort(txnIds);
                            }
                            if (!this.isTxnsOpenAndNotReadOnly(txnIds, stmt)) {
                                String errorMsg = "Write ID allocation on " + TableName.getDbTable((String)dbName, (String)tblName) + " failed for input txns: " + this.getAbortedAndReadOnlyTxns(txnIds, stmt) + this.getCommittedTxns(txnIds, stmt);
                                LOG.error(errorMsg);
                                throw new IllegalStateException("Write ID allocation failed on " + TableName.getDbTable((String)dbName, (String)tblName) + " as not all input txns in open state or read-only");
                            }
                            ArrayList<String> queries = new ArrayList<String>();
                            StringBuilder prefix = new StringBuilder();
                            StringBuilder stringBuilder = new StringBuilder();
                            prefix.append("select t2w_txnid, t2w_writeid from TXN_TO_WRITE_ID where t2w_database = ? and t2w_table = ? and ");
                            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, stringBuilder, txnIds, "t2w_txnid", false, false);
                            long allocatedTxnsCount = 0L;
                            long writeId = 0L;
                            List<String> params = Arrays.asList(dbName, tblName);
                            for (String query : queries) {
                                pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                                LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                rs = pStmt.executeQuery();
                                while (rs.next()) {
                                    long txnId = rs.getLong(1);
                                    writeId = rs.getLong(2);
                                    txnToWriteIds.add(new TxnToWriteId(txnId, writeId));
                                    ++allocatedTxnsCount;
                                    LOG.info("Reused already allocated writeID: " + writeId + " for txnId: " + txnId);
                                }
                                TxnHandler.closeStmt(pStmt);
                            }
                            long numOfWriteIds = txnIds.size();
                            assert (allocatedTxnsCount == 0L || numOfWriteIds == allocatedTxnsCount);
                            if (allocatedTxnsCount == numOfWriteIds) {
                                allocateTableWriteIdsResponse = new AllocateTableWriteIdsResponse(txnToWriteIds);
                                if (insertPreparedStmts == null) break block40;
                                iterator = insertPreparedStmts.iterator();
                                break block41;
                            }
                            long srcWriteId = 0L;
                            if (rqst.isSetReplPolicy()) {
                                assert (srcTxnToWriteIds != null);
                                srcWriteId = srcTxnToWriteIds.get(0).getWriteId();
                            }
                            handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.WriteIdAllocator.name());
                            String s = sqlGenerator.addForUpdateClause("select nwi_next from NEXT_WRITE_ID where nwi_database = ? and nwi_table = ?");
                            TxnHandler.closeStmt(pStmt);
                            pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                            LOG.debug("Going to execute query <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                            rs = pStmt.executeQuery();
                            if (!rs.next()) {
                                writeId = srcWriteId > 0L ? srcWriteId : 1L;
                                s = "insert into NEXT_WRITE_ID (nwi_database, nwi_table, nwi_next) values (?, ?, " + Long.toString(writeId + numOfWriteIds) + ")";
                                TxnHandler.closeStmt(pStmt);
                                pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                                LOG.debug("Going to execute insert <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                pStmt.execute();
                            } else {
                                long nextWriteId = rs.getLong(1);
                                writeId = srcWriteId > 0L ? srcWriteId : nextWriteId;
                                s = "update NEXT_WRITE_ID set nwi_next = " + Long.toString(writeId + numOfWriteIds) + " where nwi_database = ? and nwi_table = ?";
                                TxnHandler.closeStmt(pStmt);
                                pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                                LOG.debug("Going to execute update <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                pStmt.executeUpdate();
                                if (srcWriteId > 0L && srcWriteId != nextWriteId) {
                                    s = "delete from TXN_TO_WRITE_ID where t2w_database = ? and t2w_table = ?";
                                    TxnHandler.closeStmt(pStmt);
                                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                                    LOG.debug("Going to execute delete <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                    pStmt.executeUpdate();
                                }
                            }
                            ArrayList<String> rows = new ArrayList<String>();
                            ArrayList<List<String>> paramsList = new ArrayList<List<String>>();
                            object = txnIds.iterator();
                            while (object.hasNext()) {
                                long txn = object.next();
                                rows.add(txn + ", ?, ?, " + writeId);
                                txnToWriteIds.add(new TxnToWriteId(txn, writeId));
                                paramsList.add(params);
                                LOG.info("Allocated writeID: " + writeId + " for txnId: " + txn);
                                ++writeId;
                            }
                            insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "TXN_TO_WRITE_ID (t2w_txnid, t2w_database, t2w_table, t2w_writeid)", rows, paramsList);
                            for (PreparedStatement pst : insertPreparedStmts) {
                                pst.execute();
                            }
                            if (this.transactionalListeners != null) {
                                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ALLOC_WRITE_ID, new AllocWriteIdEvent(txnToWriteIds, dbName, tblName), dbConn, sqlGenerator);
                            }
                            LOG.info("Allocated write ids for the table: " + dbName + "." + tblName);
                            LOG.debug("Going to commit");
                            dbConn.commit();
                            object = new AllocateTableWriteIdsResponse(txnToWriteIds);
                            if (insertPreparedStmts != null) {
                            }
                            break block42;
                        }
                        catch (SQLException e) {
                            LOG.debug("Going to rollback");
                            TxnHandler.rollbackDBConn(dbConn);
                            this.checkRetryable(dbConn, e, "allocateTableWriteIds(" + rqst + ")");
                            throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        }
                    }
                    while (iterator.hasNext()) {
                        PreparedStatement pst = (PreparedStatement)iterator.next();
                        TxnHandler.closeStmt(pst);
                    }
                }
                TxnHandler.closeStmt(pStmt);
                TxnHandler.close(rs, stmt, dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                return allocateTableWriteIdsResponse;
                for (PreparedStatement pst : insertPreparedStmts) {
                    TxnHandler.closeStmt(pst);
                }
            }
            TxnHandler.closeStmt(pStmt);
            TxnHandler.close(rs, stmt, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return object;
            finally {
                if (insertPreparedStmts != null) {
                    for (PreparedStatement pst : insertPreparedStmts) {
                        TxnHandler.closeStmt(pst);
                    }
                }
                TxnHandler.closeStmt(pStmt);
                TxnHandler.close(rs, stmt, dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
            }
        }
        catch (RetryException e) {
            return this.allocateTableWriteIds(rqst);
        }
    }

    @Override
    public void seedWriteIdOnAcidConversion(InitializeTableWriteIdsRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            PreparedStatement pst = null;
            TxnStore.MutexAPI.LockHandle handle = null;
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.WriteIdAllocator.name());
                String s = "insert into NEXT_WRITE_ID (nwi_database, nwi_table, nwi_next) values (?, ?, " + Long.toString(rqst.getSeeWriteId() + 1L) + ")";
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(rqst.getDbName(), rqst.getTblName()));
                LOG.debug("Going to execute insert <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(rqst.getDbName()), (Object)TxnHandler.quoteString(rqst.getTblName()));
                pst.execute();
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "seedWriteIdOnAcidConversion(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(null, pst, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.seedWriteIdOnAcidConversion(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void addWriteNotificationLog(AcidWriteEvent acidWriteEvent) throws MetaException {
        Connection dbConn = null;
        try {
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ACID_WRITE, acidWriteEvent, dbConn, sqlGenerator);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    if (this.isDuplicateKeyError(e)) {
                        if (this.waitForRetry("addWriteNotificationLog(" + acidWriteEvent + ")", e.getMessage())) {
                            throw new RetryException();
                        }
                        this.retryNum = 0;
                        throw new MetaException(e.getMessage());
                    }
                    this.checkRetryable(dbConn, e, "addWriteNotificationLog(" + acidWriteEvent + ")");
                    throw new MetaException("Unable to add write notification event " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
            return;
        }
        catch (RetryException e) {
            this.addWriteNotificationLog(acidWriteEvent);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.SafeToRetry
    public void performWriteSetGC() {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("select ntxn_next - 1 from NEXT_TXN_ID");
            if (!rs.next()) {
                throw new IllegalStateException("NEXT_TXN_ID is empty: DB is corrupted");
            }
            long highestAllocatedTxnId = rs.getLong(1);
            TxnHandler.close(rs);
            rs = stmt.executeQuery("select min(txn_id) from TXNS where txn_state=" + TxnHandler.quoteChar('o'));
            if (!rs.next()) {
                throw new IllegalStateException("Scalar query returned no rows?!?!!");
            }
            long lowestOpenTxnId = rs.getLong(1);
            long commitHighWaterMark = rs.wasNull() ? highestAllocatedTxnId + 1L : lowestOpenTxnId;
            int delCnt = stmt.executeUpdate("delete from WRITE_SET where ws_commit_id < " + commitHighWaterMark);
            LOG.info("Deleted " + delCnt + " obsolete rows from WRTIE_SET");
            dbConn.commit();
        }
        catch (SQLException ex) {
            try {
                LOG.warn("WriteSet GC failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, stmt, dbConn);
                throw throwable;
            }
            TxnHandler.close(rs, stmt, dbConn);
        }
        TxnHandler.close(rs, stmt, dbConn);
    }

    @Override
    @RetrySemantics.ReadOnly
    public Materialization getMaterializationInvalidationInfo(CreationMetadata creationMetadata, String validTxnListStr) throws MetaException {
        Materialization materialization;
        if (creationMetadata.getTablesUsed().isEmpty()) {
            LOG.warn("Materialization creation metadata does not contain any table");
            return null;
        }
        Connection dbConn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            ValidTxnWriteIdList validReaderWriteIdList = new ValidTxnWriteIdList(creationMetadata.getValidTxnList());
            ValidReadTxnList currentValidTxnList = new ValidReadTxnList(validTxnListStr);
            ArrayList<TableValidWriteIds> currentTblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
            for (String fullTableName : creationMetadata.getTablesUsed()) {
                currentTblValidWriteIdsList.add(this.getValidWriteIdsForTable(dbConn, fullTableName, (ValidTxnList)currentValidTxnList));
            }
            ValidTxnWriteIdList currentValidReaderWriteIdList = TxnUtils.createValidTxnWriteIdList(currentValidTxnList.getHighWatermark(), currentTblValidWriteIdsList);
            ArrayList<String> params = new ArrayList<String>();
            StringBuilder query = new StringBuilder();
            query.append("select ctc_update_delete from COMPLETED_TXN_COMPONENTS where ctc_update_delete='Y' AND (");
            int i = 0;
            for (String fullyQualifiedName : creationMetadata.getTablesUsed()) {
                Materialization materialization2;
                ValidWriteIdList tblValidWriteIdList = validReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
                if (tblValidWriteIdList == null) {
                    LOG.warn("ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                    Materialization materialization3 = null;
                    return materialization3;
                }
                ValidWriteIdList currentTblValidWriteIdList = currentValidReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
                if (currentTblValidWriteIdList == null) {
                    LOG.warn("Current ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                    materialization2 = null;
                    return materialization2;
                }
                if (!Objects.equals(currentTblValidWriteIdList.getMinOpenWriteId(), tblValidWriteIdList.getMinOpenWriteId())) {
                    LOG.debug("Minimum open write id do not match for table {}", (Object)fullyQualifiedName);
                    materialization2 = null;
                    TxnHandler.close(rs, pst, dbConn);
                    return materialization2;
                }
                if (i != 0) {
                    query.append("OR");
                }
                String[] names = TxnUtils.getDbTableName(fullyQualifiedName);
                assert (names.length == 2);
                query.append(" (ctc_database=? AND ctc_table=?");
                params.add(names[0]);
                params.add(names[1]);
                query.append(" AND (ctc_writeid > " + tblValidWriteIdList.getHighWatermark());
                query.append(tblValidWriteIdList.getInvalidWriteIds().length == 0 ? ") " : " OR ctc_writeid IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])tblValidWriteIdList.getInvalidWriteIds()))) + ") ");
                query.append(") ");
                ++i;
            }
            query.append(") AND ctc_txnid <= " + currentValidTxnList.getHighWatermark());
            query.append(currentValidTxnList.getInvalidTransactions().length == 0 ? " " : " AND ctc_txnid NOT IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])currentValidTxnList.getInvalidTransactions()))) + ") ");
            String s = query.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + s + ">");
            }
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            pst.setMaxRows(1);
            rs = pst.executeQuery();
            materialization = new Materialization(rs.next());
            TxnHandler.close(rs, pst, dbConn);
        }
        catch (SQLException ex) {
            LOG.warn("getMaterializationInvalidationInfo failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            throw new MetaException("Unable to retrieve materialization invalidation information due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
        }
        finally {
            TxnHandler.close(rs, pst, dbConn);
        }
        return materialization;
    }

    @Override
    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        LockResponse lockResponse;
        List<String> params;
        ResultSet rs;
        PreparedStatement pst;
        Connection dbConn;
        TxnStore.MutexAPI.LockHandle handle;
        block9: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquiring lock for materialization rebuild with txnId={} for {}", (Object)txnId, (Object)Warehouse.getQualifiedName(dbName, tableName));
            }
            handle = null;
            dbConn = null;
            pst = null;
            rs = null;
            this.lockInternal();
            handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.MaterializationRebuild.name());
            dbConn = this.getDbConn(2);
            params = Arrays.asList(dbName, tableName);
            String selectQ = "select mrl_txn_id from MATERIALIZATION_REBUILD_LOCKS where mrl_db_name = ? AND mrl_tbl_name = ?";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, selectQ, params);
            LOG.debug("Going to execute query <" + selectQ.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
            rs = pst.executeQuery();
            if (!rs.next()) break block9;
            LOG.info("Ignoring request to rebuild " + dbName + "/" + tableName + " since it is already being rebuilt");
            LockResponse lockResponse2 = new LockResponse(txnId, LockState.NOT_ACQUIRED);
            TxnHandler.close(rs, pst, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return lockResponse2;
        }
        try {
            String insertQ = "insert into MATERIALIZATION_REBUILD_LOCKS (mrl_txn_id, mrl_db_name, mrl_tbl_name, mrl_last_heartbeat) values (" + txnId + ", ?, ?, " + Instant.now().toEpochMilli() + ")";
            TxnHandler.closeStmt(pst);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, insertQ, params);
            LOG.debug("Going to execute update <" + insertQ.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
            pst.executeUpdate();
            LOG.debug("Going to commit");
            dbConn.commit();
            lockResponse = new LockResponse(txnId, LockState.ACQUIRED);
        }
        catch (SQLException ex) {
            try {
                LOG.warn("lockMaterializationRebuild failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
                throw new MetaException("Unable to retrieve materialization invalidation information due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, pst, dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                throw throwable;
            }
        }
        TxnHandler.close(rs, pst, dbConn);
        if (handle != null) {
            handle.releaseLocks();
        }
        this.unlockInternal();
        return lockResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        try {
            boolean bl;
            PreparedStatement pst;
            Connection dbConn;
            block7: {
                dbConn = null;
                pst = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                String s = "update MATERIALIZATION_REBUILD_LOCKS set mrl_last_heartbeat = " + Instant.now().toEpochMilli() + " where mrl_txn_id = " + txnId + " AND mrl_db_name = ?" + " AND mrl_tbl_name = ?";
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(dbName, tableName));
                LOG.debug("Going to execute update <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
                int rc = pst.executeUpdate();
                if (rc >= 1) break block7;
                LOG.debug("Going to rollback");
                dbConn.rollback();
                LOG.info("No lock found for rebuild of " + Warehouse.getQualifiedName(dbName, tableName) + " when trying to heartbeat");
                boolean bl2 = false;
                TxnHandler.close(null, pst, dbConn);
                this.unlockInternal();
                return bl2;
            }
            try {
                LOG.debug("Going to commit");
                dbConn.commit();
                bl = true;
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "heartbeatLockMaterializationRebuild(" + Warehouse.getQualifiedName(dbName, tableName) + ", " + txnId + ")");
                    throw new MetaException("Unable to heartbeat rebuild lock due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(null, pst, dbConn);
            this.unlockInternal();
            return bl;
        }
        catch (RetryException e2) {
            return this.heartbeatLockMaterializationRebuild(dbName, tableName, txnId);
        }
    }

    @Override
    public long cleanupMaterializationRebuildLocks(ValidTxnList validTxnList, long timeout) throws MetaException {
        long l;
        long cnt = 0L;
        ArrayList<Long> txnIds = new ArrayList<Long>();
        long timeoutTime = Instant.now().toEpochMilli() - timeout;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String selectQ = "select mrl_txn_id, mrl_last_heartbeat from MATERIALIZATION_REBUILD_LOCKS";
            LOG.debug("Going to execute query <" + selectQ + ">");
            rs = stmt.executeQuery(selectQ);
            while (rs.next()) {
                long txnId;
                long lastHeartbeat = rs.getLong(2);
                if (lastHeartbeat >= timeoutTime || !validTxnList.isTxnValid(txnId = rs.getLong(1)) && !validTxnList.isTxnAborted(txnId)) continue;
                txnIds.add(txnId);
            }
            if (!txnIds.isEmpty()) {
                String deleteQ = "delete from MATERIALIZATION_REBUILD_LOCKS where mrl_txn_id IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", txnIds) + ") ";
                LOG.debug("Going to execute update <" + deleteQ + ">");
                cnt = stmt.executeUpdate(deleteQ);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            l = cnt;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "cleanupMaterializationRebuildLocks");
                    throw new MetaException("Unable to clean rebuild locks due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.cleanupMaterializationRebuildLocks(validTxnList, timeout);
            }
        }
        TxnHandler.close(rs, stmt, dbConn);
        this.unlockInternal();
        return l;
    }

    @Override
    @RetrySemantics.CannotRetry
    public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connAndLockId = this.enqueueLockWithRetry(rqst);
        try {
            return this.checkLockWithRetry(connAndLockId.dbConn, connAndLockId.extLockId, rqst.getTxnid());
        }
        catch (NoSuchLockException e) {
            throw new MetaException("Couldn't find a lock we just created! " + e.getMessage());
        }
    }

    private TxnRecord lockTransactionRecord(Statement stmt, long txnId, Character txnState) throws SQLException, MetaException {
        String query = "select TXN_TYPE from TXNS where TXN_ID = " + txnId + (txnState != null ? " and TXN_STATE = " + TxnHandler.quoteChar(txnState.charValue()) : "");
        try (ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));){
            TxnRecord txnRecord = rs.next() ? new TxnRecord(rs.getInt(1)) : null;
            return txnRecord;
        }
    }

    private ConnectionLockIdPair enqueueLockWithRetry(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connectionLockIdPair;
        ResultSet rs;
        PreparedStatement pStmt;
        Statement stmt;
        Connection dbConn;
        boolean success;
        block42: {
            success = false;
            dbConn = null;
            stmt = null;
            pStmt = null;
            List<PreparedStatement> insertPreparedStmts = null;
            rs = null;
            try {
                ArrayList<List<String>> paramsList;
                ArrayList<String> rows;
                TxnRecord txnRecord;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                long txnid = rqst.getTxnid();
                stmt = dbConn.createStatement();
                if (TxnHandler.isValidTxn(txnid) && (txnRecord = this.lockTransactionRecord(stmt, txnid, Character.valueOf('o'))) == null) {
                    TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                    TxnHandler.shouldNeverHappen(txnid);
                }
                String s = sqlGenerator.addForUpdateClause("select nl_next from NEXT_LOCK_ID");
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                    throw new MetaException("Transaction tables not properly initialized, no record found in next_lock_id");
                }
                long extLockId = rs.getLong(1);
                s = "update NEXT_LOCK_ID set nl_next = " + (extLockId + 1L);
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                if (txnid > 0L) {
                    rows = new ArrayList<String>();
                    paramsList = new ArrayList<List<String>>();
                    for (LockComponent lc : rqst.getComponent()) {
                        boolean updateTxnComponents;
                        if (lc.isSetIsTransactional() && !lc.isIsTransactional()) continue;
                        if (!lc.isSetOperationType()) {
                            updateTxnComponents = true;
                        } else {
                            switch (lc.getOperationType()) {
                                case INSERT: 
                                case UPDATE: 
                                case DELETE: {
                                    if (!lc.isSetIsDynamicPartitionWrite()) {
                                        updateTxnComponents = true;
                                        break;
                                    }
                                    updateTxnComponents = !lc.isIsDynamicPartitionWrite();
                                    break;
                                }
                                case SELECT: {
                                    updateTxnComponents = false;
                                    break;
                                }
                                case NO_TXN: {
                                    updateTxnComponents = false;
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Unexpected DataOperationType: " + (Object)((Object)lc.getOperationType()) + " agentInfo=" + rqst.getAgentInfo() + " " + JavaUtils.txnIdToString(txnid));
                                }
                            }
                        }
                        if (!updateTxnComponents) continue;
                        String dbName = TxnHandler.normalizeCase(lc.getDbname());
                        String tblName = TxnHandler.normalizeCase(lc.getTablename());
                        String partName = TxnHandler.normalizeCase(lc.getPartitionname());
                        Long writeId = null;
                        if (tblName != null) {
                            s = "select t2w_writeid from TXN_TO_WRITE_ID where t2w_database = ? and t2w_table = ? and t2w_txnid = " + txnid;
                            pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(dbName, tblName));
                            LOG.debug("Going to execute query <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                            rs = pStmt.executeQuery();
                            if (rs.next()) {
                                writeId = rs.getLong(1);
                            }
                        }
                        rows.add(txnid + ", ?, " + (tblName == null ? "null" : "?") + ", " + (partName == null ? "null" : "?") + "," + TxnHandler.quoteString(OperationType.fromDataOperationType(lc.getOperationType()).toString()) + "," + (writeId == null ? "null" : writeId));
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(dbName);
                        if (tblName != null) {
                            params.add(tblName);
                        }
                        if (partName != null) {
                            params.add(partName);
                        }
                        paramsList.add(params);
                    }
                    insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "TXN_COMPONENTS (tc_txnid, tc_database, tc_table, tc_partition, tc_operation_type, tc_writeid)", rows, paramsList);
                    for (PreparedStatement pst : insertPreparedStmts) {
                        int modCount = pst.executeUpdate();
                        TxnHandler.closeStmt(pst);
                    }
                    insertPreparedStmts = null;
                }
                rows = new ArrayList();
                paramsList = new ArrayList();
                long intLockId = 0L;
                String lastHBString = TxnHandler.isValidTxn(txnid) ? "0" : this.getDbEpochString();
                for (LockComponent lc : rqst.getComponent()) {
                    if (lc.isSetOperationType() && lc.getOperationType() == DataOperationType.UNSET && (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST))) {
                        throw new IllegalStateException("Bug: operationType=" + (Object)((Object)lc.getOperationType()) + " for component " + lc + " agentInfo=" + rqst.getAgentInfo());
                    }
                    ++intLockId;
                    String dbName = TxnHandler.normalizeCase(lc.getDbname());
                    String tblName = TxnHandler.normalizeCase(lc.getTablename());
                    String partName = TxnHandler.normalizeCase(lc.getPartitionname());
                    LockType lockType = lc.getType();
                    char lockChar = 'z';
                    switch (lockType) {
                        case EXCLUSIVE: {
                            lockChar = 'e';
                            break;
                        }
                        case SHARED_READ: {
                            lockChar = 'r';
                            break;
                        }
                        case SHARED_WRITE: {
                            lockChar = 'w';
                        }
                    }
                    rows.add(extLockId + ", " + intLockId + "," + txnid + ", ?, " + (tblName == null ? "null" : "?") + ", " + (partName == null ? "null" : "?") + ", " + TxnHandler.quoteChar('w') + ", " + TxnHandler.quoteChar(lockChar) + ", " + lastHBString + ", " + (rqst.getUser() == null ? "null" : "?") + ", " + (rqst.getHostname() == null ? "null" : "?") + ", " + (rqst.getAgentInfo() == null ? "null" : "?"));
                    ArrayList<String> params = new ArrayList<String>();
                    params.add(dbName);
                    if (tblName != null) {
                        params.add(tblName);
                    }
                    if (partName != null) {
                        params.add(partName);
                    }
                    if (rqst.getUser() != null) {
                        params.add(rqst.getUser());
                    }
                    if (rqst.getHostname() != null) {
                        params.add(rqst.getHostname());
                    }
                    if (rqst.getAgentInfo() != null) {
                        params.add(rqst.getAgentInfo());
                    }
                    paramsList.add(params);
                }
                insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "HIVE_LOCKS (hl_lock_ext_id, hl_lock_int_id, hl_txnid, hl_db, hl_table, hl_partition,hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_user, hl_host, hl_agent_info)", rows, paramsList);
                for (PreparedStatement pst : insertPreparedStmts) {
                    int dbName = pst.executeUpdate();
                }
                dbConn.commit();
                success = true;
                connectionLockIdPair = new ConnectionLockIdPair(dbConn, extLockId);
                if (insertPreparedStmts == null) break block42;
            }
            catch (SQLException e) {
                try {
                    try {
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "enqueueLockWithRetry(" + rqst + ")");
                        throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        if (insertPreparedStmts != null) {
                            for (PreparedStatement pst : insertPreparedStmts) {
                                TxnHandler.closeStmt(pst);
                            }
                        }
                        TxnHandler.closeStmt(pStmt);
                        TxnHandler.close(rs, stmt, null);
                        if (!success) {
                            TxnHandler.closeDbConn(dbConn);
                        }
                        this.unlockInternal();
                        throw throwable;
                    }
                }
                catch (RetryException e2) {
                    return this.enqueueLockWithRetry(rqst);
                }
            }
            for (PreparedStatement pst : insertPreparedStmts) {
                TxnHandler.closeStmt(pst);
            }
        }
        TxnHandler.closeStmt(pStmt);
        TxnHandler.close(rs, stmt, null);
        if (!success) {
            TxnHandler.closeDbConn(dbConn);
        }
        this.unlockInternal();
        return connectionLockIdPair;
    }

    private static String normalizeCase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    private LockResponse checkLockWithRetry(Connection dbConn, long extLockId, long txnId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        try {
            this.lockInternal();
            if (dbConn.isClosed()) {
                dbConn = this.getDbConn(2);
            }
            lockResponse = this.checkLock(dbConn, extLockId);
            this.unlockInternal();
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "checkLockWithRetry(" + extLockId + "," + txnId + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.unlockInternal();
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.checkLockWithRetry(dbConn, extLockId, txnId);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return lockResponse;
    }

    @Override
    @RetrySemantics.SafeToRetry
    public LockResponse checkLock(CheckLockRequest rqst) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        Connection dbConn = null;
        long extLockId = rqst.getLockid();
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            LockInfo info = this.getTxnIdFromLockId(dbConn, extLockId);
            if (info == null) {
                throw new NoSuchLockException("No such lock " + JavaUtils.lockIdToString(extLockId));
            }
            if (info.txnId > 0L) {
                this.heartbeatTxn(dbConn, info.txnId);
            } else {
                this.heartbeatLock(dbConn, extLockId);
            }
            lockResponse = this.checkLock(dbConn, extLockId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "checkLock(" + rqst + " )");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.checkLock(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        this.unlockInternal();
        return lockResponse;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void unlock(UnlockRequest rqst) throws NoSuchLockException, TxnOpenException, MetaException {
        try {
            block9: {
                dbConn = null;
                stmt = null;
                extLockId = rqst.getLockid();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                s = "delete from HIVE_LOCKS where hl_lock_ext_id = " + extLockId + " AND (hl_txnid = 0 OR" + " (hl_txnid <> 0 AND hl_lock_state = '" + 'w' + "'))";
                TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                rc = stmt.executeUpdate(s);
                if (rc >= 1) ** GOTO lbl30
                TxnHandler.LOG.debug("Going to rollback");
                dbConn.rollback();
                info = this.getTxnIdFromLockId(dbConn, extLockId);
                if (info != null) break block9;
                TxnHandler.LOG.info("No lock in w mode found for unlock(" + JavaUtils.lockIdToString(rqst.getLockid()) + ")");
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                return;
            }
            try {
                if (LockInfo.access$600(info) != 0L) {
                    msg = "Unlocking locks associated with transaction not permitted.  " + info;
                    TxnHandler.LOG.error(msg);
                    throw new TxnOpenException(msg);
                }
                if (LockInfo.access$600(info) == 0L) {
                    msg = "Found lock in unexpected state " + info;
                    TxnHandler.LOG.error(msg);
                    throw new MetaException(msg);
                }
lbl30:
                // 3 sources

                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "unlock(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable var10_12) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw var10_12;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
        }
        catch (RetryException e) {
            this.unlock(rqst);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            ShowLocksResponse rsp = new ShowLocksResponse();
            ArrayList<ShowLocksResponseElement> elems = new ArrayList<ShowLocksResponseElement>();
            ArrayList<LockInfoExt> sortedList = new ArrayList<LockInfoExt>();
            PreparedStatement pst = null;
            try {
                String whereClause;
                dbConn = this.getDbConn(2);
                String s = "select hl_lock_ext_id, hl_txnid, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_acquired_at, hl_user, hl_host, hl_lock_int_id,hl_blockedby_ext_id, hl_blockedby_int_id, hl_agent_info from HIVE_LOCKS";
                String dbName = rqst.getDbname();
                String tableName = rqst.getTablename();
                String partName = rqst.getPartname();
                ArrayList<String> params = new ArrayList<String>();
                StringBuilder filter = new StringBuilder();
                if (dbName != null && !dbName.isEmpty()) {
                    filter.append("hl_db=?");
                    params.add(dbName);
                }
                if (tableName != null && !tableName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("hl_table=?");
                    params.add(tableName);
                }
                if (partName != null && !partName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("hl_partition=?");
                    params.add(partName);
                }
                if (!(whereClause = filter.toString()).isEmpty()) {
                    s = s + " where " + whereClause;
                }
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute query <" + s + ">");
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    ShowLocksResponseElement e = new ShowLocksResponseElement();
                    e.setLockid(rs.getLong(1));
                    long txnid = rs.getLong(2);
                    if (!rs.wasNull()) {
                        e.setTxnid(txnid);
                    }
                    e.setDbname(rs.getString(3));
                    e.setTablename(rs.getString(4));
                    String partition = rs.getString(5);
                    if (partition != null) {
                        e.setPartname(partition);
                    }
                    switch (rs.getString(6).charAt(0)) {
                        case 'a': {
                            e.setState(LockState.ACQUIRED);
                            break;
                        }
                        case 'w': {
                            e.setState(LockState.WAITING);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock state " + rs.getString(6).charAt(0));
                        }
                    }
                    switch (rs.getString(7).charAt(0)) {
                        case 'w': {
                            e.setType(LockType.SHARED_WRITE);
                            break;
                        }
                        case 'e': {
                            e.setType(LockType.EXCLUSIVE);
                            break;
                        }
                        case 'r': {
                            e.setType(LockType.SHARED_READ);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock type " + rs.getString(6).charAt(0));
                        }
                    }
                    e.setLastheartbeat(rs.getLong(8));
                    long acquiredAt = rs.getLong(9);
                    if (!rs.wasNull()) {
                        e.setAcquiredat(acquiredAt);
                    }
                    e.setUser(rs.getString(10));
                    e.setHostname(rs.getString(11));
                    e.setLockIdInternal(rs.getLong(12));
                    long id = rs.getLong(13);
                    if (!rs.wasNull()) {
                        e.setBlockedByExtId(id);
                    }
                    id = rs.getLong(14);
                    if (!rs.wasNull()) {
                        e.setBlockedByIntId(id);
                    }
                    e.setAgentInfo(rs.getString(15));
                    sortedList.add(new LockInfoExt(e));
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    this.checkRetryable(dbConn, e, "showLocks(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(pst);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(pst);
            TxnHandler.closeDbConn(dbConn);
            Collections.sort(sortedList, new LockInfoComparator());
            for (LockInfoExt lockInfoExt : sortedList) {
                elems.add(lockInfoExt.e);
            }
            rsp.setLocks(elems);
            return rsp;
        }
        catch (RetryException e) {
            return this.showLocks(rqst);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void heartbeat(HeartbeatRequest ids) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                this.heartbeatLock(dbConn, ids.getLockid());
                this.heartbeatTxn(dbConn, ids.getTxnid());
            }
            catch (SQLException e) {
                LOG.debug("Going to rollback");
                TxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "heartbeat(" + ids + ")");
                throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            finally {
                TxnHandler.closeDbConn(dbConn);
            }
        }
        catch (RetryException e) {
            this.heartbeat(ids);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.SafeToRetry
    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest rqst) throws MetaException {
        try {
            HeartbeatTxnRangeResponse heartbeatTxnRangeResponse;
            HashSet<Long> aborted;
            HashSet<Long> nosuch;
            HeartbeatTxnRangeResponse rsp;
            Statement stmt;
            Connection dbConn;
            block13: {
                dbConn = null;
                stmt = null;
                rsp = new HeartbeatTxnRangeResponse();
                nosuch = new HashSet<Long>();
                aborted = new HashSet<Long>();
                rsp.setNosuch(nosuch);
                rsp.setAborted(aborted);
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                ArrayList<String> queries = new ArrayList<String>();
                int numTxnsToHeartbeat = (int)(rqst.getMax() - rqst.getMin() + 1L);
                ArrayList<Long> txnIds = new ArrayList<Long>(numTxnsToHeartbeat);
                for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                    txnIds.add(txn);
                }
                TxnUtils.buildQueryWithINClause(this.conf, queries, new StringBuilder("update TXNS set txn_last_heartbeat = " + this.getDbEpochString() + " where txn_state = " + TxnHandler.quoteChar('o') + " and "), new StringBuilder(""), txnIds, "txn_id", true, false);
                int updateCnt = 0;
                for (String query : queries) {
                    LOG.debug("Going to execute update <" + query + ">");
                    updateCnt += stmt.executeUpdate(query);
                }
                if (updateCnt != numTxnsToHeartbeat) break block13;
                dbConn.commit();
                HeartbeatTxnRangeResponse heartbeatTxnRangeResponse2 = rsp;
                TxnHandler.close(null, stmt, dbConn);
                return heartbeatTxnRangeResponse2;
            }
            try {
                dbConn.rollback();
                for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                    try {
                        this.heartbeatTxn(dbConn, txn);
                        continue;
                    }
                    catch (NoSuchTxnException e) {
                        nosuch.add(txn);
                        continue;
                    }
                    catch (TxnAbortedException e) {
                        aborted.add(txn);
                    }
                }
                heartbeatTxnRangeResponse = rsp;
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "heartbeatTxnRange(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    throw throwable;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            return heartbeatTxnRangeResponse;
        }
        catch (RetryException e2) {
            return this.heartbeatTxnRange(rqst);
        }
    }

    long generateCompactionQueueId(Statement stmt) throws SQLException, MetaException {
        String s = sqlGenerator.addForUpdateClause("select ncq_next from NEXT_COMPACTION_QUEUE_ID");
        LOG.debug("going to execute query <" + s + ">");
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                throw new IllegalStateException("Transaction tables not properly initiated, no record found in next_compaction_queue_id");
            }
            long id = rs.getLong(1);
            s = "update NEXT_COMPACTION_QUEUE_ID set ncq_next = " + (id + 1L);
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            long l = id;
            return l;
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public long getTxnIdForWriteId(String dbName, String tblName, long writeId) throws MetaException {
        long l;
        Connection dbConn = null;
        PreparedStatement pst = null;
        try {
            dbConn = this.getDbConn(2);
            String query = "select t2w_txnid from TXN_TO_WRITE_ID where t2w_database = ? and t2w_table = ? and t2w_writeid = " + writeId;
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, Arrays.asList(dbName, tblName));
            LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
            ResultSet rs = pst.executeQuery();
            long txnId = -1L;
            if (rs.next()) {
                txnId = rs.getLong(1);
            }
            dbConn.rollback();
            l = txnId;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getTxnIdForWriteId");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getTxnIdForWriteId(dbName, tblName, writeId);
            }
        }
        TxnHandler.close(null, pst, dbConn);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public CompactionResponse compact(CompactionRequest rqst) throws MetaException {
        try {
            CompactionResponse compactionResponse;
            ResultSet rs;
            ArrayList<String> params;
            long id;
            TxnStore.MutexAPI.LockHandle handle;
            PreparedStatement pst;
            Statement stmt;
            Connection dbConn;
            block23: {
                dbConn = null;
                stmt = null;
                pst = null;
                handle = null;
                this.lockInternal();
                handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CompactionScheduler.name());
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                id = this.generateCompactionQueueId(stmt);
                params = new ArrayList<String>();
                StringBuilder sb = new StringBuilder("select cq_id, cq_state from COMPACTION_QUEUE where").append(" cq_state IN(").append(TxnHandler.quoteChar('i')).append(",").append(TxnHandler.quoteChar('w')).append(") AND cq_database=?").append(" AND cq_table=?").append(" AND ");
                params.add(rqst.getDbname());
                params.add(rqst.getTablename());
                if (rqst.getPartitionname() == null) {
                    sb.append("cq_partition is null");
                } else {
                    sb.append("cq_partition=?");
                    params.add(rqst.getPartitionname());
                }
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, sb.toString(), params);
                LOG.debug("Going to execute query <" + sb.toString() + ">");
                rs = pst.executeQuery();
                if (!rs.next()) break block23;
                long enqueuedId = rs.getLong(1);
                String state = TxnHandler.compactorStateToResponse(rs.getString(2).charAt(0));
                LOG.info("Ignoring request to compact " + rqst.getDbname() + "/" + rqst.getTablename() + "/" + rqst.getPartitionname() + " since it is already " + TxnHandler.quoteString(state) + " with id=" + enqueuedId);
                CompactionResponse compactionResponse2 = new CompactionResponse(enqueuedId, state, false);
                TxnHandler.closeStmt(pst);
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                return compactionResponse2;
            }
            try {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(pst);
                params.clear();
                StringBuilder buf = new StringBuilder("insert into COMPACTION_QUEUE (cq_id, cq_database, cq_table, ");
                String partName = rqst.getPartitionname();
                if (partName != null) {
                    buf.append("cq_partition, ");
                }
                buf.append("cq_state, cq_type");
                if (rqst.getProperties() != null) {
                    buf.append(", cq_tblproperties");
                }
                if (rqst.getRunas() != null) {
                    buf.append(", cq_run_as");
                }
                buf.append(") values (");
                buf.append(id);
                buf.append(", ?");
                buf.append(", ?");
                buf.append(", ");
                params.add(rqst.getDbname());
                params.add(rqst.getTablename());
                if (partName != null) {
                    buf.append("?, '");
                    params.add(partName);
                } else {
                    buf.append("'");
                }
                buf.append('i');
                buf.append("', '");
                switch (rqst.getType()) {
                    case MAJOR: {
                        buf.append('a');
                        break;
                    }
                    case MINOR: {
                        buf.append('i');
                        break;
                    }
                    default: {
                        LOG.debug("Going to rollback");
                        dbConn.rollback();
                        throw new MetaException("Unexpected compaction type " + rqst.getType().toString());
                    }
                }
                buf.append("'");
                if (rqst.getProperties() != null) {
                    buf.append(", ?");
                    params.add(new StringableMap(rqst.getProperties()).toString());
                }
                if (rqst.getRunas() != null) {
                    buf.append(", ?");
                    params.add(rqst.getRunas());
                }
                buf.append(")");
                String s = buf.toString();
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute update <" + s + ">");
                pst.executeUpdate();
                LOG.debug("Going to commit");
                dbConn.commit();
                compactionResponse = new CompactionResponse(id, "initiated", true);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "compact(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(pst);
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(pst);
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return compactionResponse;
        }
        catch (RetryException e2) {
            return this.compact(rqst);
        }
    }

    private static String compactorStateToResponse(char s) {
        switch (s) {
            case 'i': {
                return "initiated";
            }
            case 'w': {
                return "working";
            }
            case 'r': {
                return "ready for cleaning";
            }
            case 'f': {
                return "failed";
            }
            case 's': {
                return "succeeded";
            }
            case 'a': {
                return "attempted";
            }
        }
        return Character.toString(s);
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowCompactResponse showCompact(ShowCompactRequest rqst) throws MetaException {
        ShowCompactResponse response = new ShowCompactResponse(new ArrayList<ShowCompactResponseElement>());
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select cq_database, cq_table, cq_partition, cq_state, cq_type, cq_worker_id, cq_start, -1 cc_end, cq_run_as, cq_hadoop_job_id, cq_id, cq_error_message from COMPACTION_QUEUE union all select cc_database, cc_table, cc_partition, cc_state, cc_type, cc_worker_id, cc_start, cc_end, cc_run_as, cc_hadoop_job_id, cc_id, cc_error_message from COMPLETED_COMPACTIONS";
                LOG.debug("Going to execute query <" + s + ">");
                ResultSet rs = stmt.executeQuery(s);
                while (rs.next()) {
                    long endTime;
                    ShowCompactResponseElement e = new ShowCompactResponseElement();
                    e.setDbname(rs.getString(1));
                    e.setTablename(rs.getString(2));
                    e.setPartitionname(rs.getString(3));
                    e.setState(TxnHandler.compactorStateToResponse(rs.getString(4).charAt(0)));
                    switch (rs.getString(5).charAt(0)) {
                        case 'a': {
                            e.setType(CompactionType.MAJOR);
                            break;
                        }
                        case 'i': {
                            e.setType(CompactionType.MINOR);
                            break;
                        }
                    }
                    e.setWorkerid(rs.getString(6));
                    long start = rs.getLong(7);
                    if (!rs.wasNull()) {
                        e.setStart(start);
                    }
                    if ((endTime = rs.getLong(8)) != -1L) {
                        e.setEndTime(endTime);
                    }
                    e.setRunAs(rs.getString(9));
                    e.setHadoopJobId(rs.getString(10));
                    e.setId(rs.getLong(11));
                    e.setErrorMessage(rs.getString(12));
                    response.addToCompacts(e);
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "showCompact(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            return response;
        }
        catch (RetryException e) {
            return this.showCompact(rqst);
        }
    }

    private static void shouldNeverHappen(long txnid) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid));
    }

    private static void shouldNeverHappen(long txnid, long extLockId, long intLockId) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid) + " " + JavaUtils.lockIdToString(extLockId) + " " + intLockId);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void addDynamicPartitions(AddDynamicPartitions rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        List<PreparedStatement> insertPreparedStmts = null;
        try {
            block13: {
                try {
                    this.lockInternal();
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    TxnRecord txnRecord = this.lockTransactionRecord(stmt, rqst.getTxnid(), Character.valueOf('o'));
                    if (txnRecord == null) {
                        TxnHandler.ensureValidTxn(dbConn, rqst.getTxnid(), stmt);
                        TxnHandler.shouldNeverHappen(rqst.getTxnid());
                    }
                    OperationType ot = OperationType.UPDATE;
                    if (rqst.isSetOperationType()) {
                        ot = OperationType.fromDataOperationType(rqst.getOperationType());
                    }
                    Long writeId = rqst.getWriteid();
                    ArrayList<String> rows = new ArrayList<String>();
                    ArrayList<List<String>> paramsList = new ArrayList<List<String>>();
                    for (String partName : rqst.getPartitionnames()) {
                        rows.add(rqst.getTxnid() + ",?,?,?," + TxnHandler.quoteChar(ot.sqlConst) + "," + writeId);
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(TxnHandler.normalizeCase(rqst.getDbname()));
                        params.add(TxnHandler.normalizeCase(rqst.getTablename()));
                        params.add(partName);
                        paramsList.add(params);
                    }
                    int modCount = 0;
                    insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "TXN_COMPONENTS (tc_txnid, tc_database, tc_table, tc_partition, tc_operation_type, tc_writeid)", rows, paramsList);
                    for (PreparedStatement pst : insertPreparedStmts) {
                        modCount = pst.executeUpdate();
                    }
                    LOG.debug("Going to commit");
                    dbConn.commit();
                    if (insertPreparedStmts == null) break block13;
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "addDynamicPartitions(" + rqst + ")");
                        throw new MetaException("Unable to insert into from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        if (insertPreparedStmts != null) {
                            for (PreparedStatement pst : insertPreparedStmts) {
                                TxnHandler.closeStmt(pst);
                            }
                        }
                        TxnHandler.close(null, stmt, dbConn);
                        this.unlockInternal();
                        throw throwable;
                    }
                }
                for (PreparedStatement pst : insertPreparedStmts) {
                    TxnHandler.closeStmt(pst);
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.addDynamicPartitions(rqst);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRename(String oldCatName, String oldDbName, String oldTabName, String oldPartName, String newCatName, String newDbName, String newTabName, String newPartName) throws MetaException {
        block33: {
            String callSig = "onRename(" + oldCatName + "," + oldDbName + "," + oldTabName + "," + oldPartName + "," + newCatName + "," + newDbName + "," + newTabName + "," + newPartName + ")";
            if (newPartName != null) assert (oldPartName != null && oldTabName != null && oldDbName != null && oldCatName != null) : callSig;
            if (newTabName != null) assert (oldTabName != null && oldDbName != null && oldCatName != null) : callSig;
            if (newDbName != null) assert (oldDbName != null && oldCatName != null) : callSig;
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    ArrayList<String> queries = new ArrayList<String>();
                    String update = "update TXN_COMPONENTS set ";
                    String where = " where ";
                    if (oldPartName != null) {
                        update = update + "TC_PARTITION = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "TC_PARTITION = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "TC_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "TC_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "TC_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "TC_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "update COMPLETED_TXN_COMPONENTS set ";
                    where = " where ";
                    if (oldPartName != null) {
                        update = update + "CTC_PARTITION = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "CTC_PARTITION = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "CTC_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "CTC_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "CTC_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "CTC_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "update HIVE_LOCKS set ";
                    where = " where ";
                    if (oldPartName != null) {
                        update = update + "HL_PARTITION = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "HL_PARTITION = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "HL_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "HL_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "HL_DB = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "HL_DB = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "update COMPACTION_QUEUE set ";
                    where = " where ";
                    if (oldPartName != null) {
                        update = update + "CQ_PARTITION = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "CQ_PARTITION = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "CQ_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "CQ_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "CQ_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "CQ_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "update COMPLETED_COMPACTIONS set ";
                    where = " where ";
                    if (oldPartName != null) {
                        update = update + "CC_PARTITION = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "CC_PARTITION = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "CC_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "CC_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "CC_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "CC_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "update WRITE_SET set ";
                    where = " where ";
                    if (oldPartName != null) {
                        update = update + "WS_PARTITION = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "WS_PARTITION = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "WS_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "WS_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "WS_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "WS_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "update TXN_TO_WRITE_ID set ";
                    where = " where ";
                    if (oldTabName != null) {
                        update = update + "T2W_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "T2W_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "T2W_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "T2W_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "update NEXT_WRITE_ID set ";
                    where = " where ";
                    if (oldTabName != null) {
                        update = update + "NWI_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "NWI_TABLE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "NWI_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "NWI_DATABASE = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    for (String query : queries) {
                        LOG.debug("Going to execute update <" + query + ">");
                        stmt.executeUpdate(query);
                    }
                    LOG.debug("Going to commit: " + callSig);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback: " + callSig);
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, callSig);
                        if (!e.getMessage().contains("does not exist")) {
                            throw new MetaException("Unable to " + callSig + ":" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        }
                        LOG.warn("Cannot perform " + callSig + " since metastore table does not exist");
                    }
                    catch (Throwable throwable) {
                        TxnHandler.closeStmt(stmt);
                        TxnHandler.closeDbConn(dbConn);
                        throw throwable;
                    }
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    break block33;
                }
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
            }
            catch (RetryException e) {
                this.onRename(oldCatName, oldDbName, oldTabName, oldPartName, newCatName, newDbName, newTabName, newPartName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int numLocksInLockTable() throws SQLException, MetaException {
        int n;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select count(*) from HIVE_LOCKS";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            rs.next();
            int rc = rs.getInt(1);
            dbConn.rollback();
            n = rc;
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs, stmt, dbConn);
            throw throwable;
        }
        TxnHandler.close(rs, stmt, dbConn);
        return n;
    }

    @Override
    public long setTimeout(long milliseconds) {
        long previous_timeout = this.timeout;
        this.timeout = milliseconds;
        return previous_timeout;
    }

    Connection getDbConn(int isolationLevel) throws SQLException {
        return this.getDbConn(isolationLevel, connPool);
    }

    private Connection getDbConn(int isolationLevel, DataSource connPool) throws SQLException {
        int rc = doRetryOnConnPool ? 10 : 1;
        Connection dbConn = null;
        while (true) {
            try {
                dbConn = connPool.getConnection();
                dbConn.setAutoCommit(false);
                dbConn.setTransactionIsolation(isolationLevel);
                return dbConn;
            }
            catch (SQLException e) {
                TxnHandler.closeDbConn(dbConn);
                if (--rc <= 0) {
                    throw e;
                }
                LOG.error("There is a problem with a connection from the pool, retrying(rc=" + rc + "): " + TxnHandler.getMessage(e), (Throwable)e);
                continue;
            }
            break;
        }
    }

    static void rollbackDBConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.rollback();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to rollback db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeDbConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeStmt(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(e));
        }
    }

    static void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(ex));
        }
    }

    static void close(ResultSet rs, Statement stmt, Connection dbConn) {
        TxnHandler.close(rs);
        TxnHandler.closeStmt(stmt);
        TxnHandler.closeDbConn(dbConn);
    }

    private boolean waitForRetry(String caller, String errMsg) {
        if (this.retryNum++ < this.retryLimit) {
            LOG.warn("Retryable error detected in " + caller + ".  Will wait " + this.retryInterval + "ms and retry up to " + (this.retryLimit - this.retryNum + 1) + " times.  Error: " + errMsg);
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        LOG.error("Fatal error in " + caller + ". Retry limit (" + this.retryLimit + ") reached. Last error: " + errMsg);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRetryable(Connection conn, SQLException e, String caller) throws RetryException, MetaException {
        boolean sendRetrySignal;
        block12: {
            sendRetrySignal = false;
            try {
                if (dbProduct == null) {
                    throw new IllegalStateException("DB Type not determined yet.");
                }
                if (DatabaseProduct.isDeadlock(dbProduct, e)) {
                    if (this.deadlockCnt++ < 10) {
                        long waitInterval = this.deadlockRetryInterval * (long)this.deadlockCnt;
                        LOG.warn("Deadlock detected in " + caller + ". Will wait " + waitInterval + "ms try again up to " + (10 - this.deadlockCnt + 1) + " times.");
                        try {
                            Thread.sleep(waitInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        sendRetrySignal = true;
                        break block12;
                    }
                    LOG.error("Too many repeated deadlocks in " + caller + ", giving up.");
                    break block12;
                }
                if (TxnHandler.isRetryable(this.conf, e)) {
                    sendRetrySignal = this.waitForRetry(caller, e.getMessage());
                } else {
                    LOG.info("Non-retryable error in " + caller + " : " + TxnHandler.getMessage(e));
                }
            }
            finally {
                if (!sendRetrySignal) {
                    this.deadlockCnt = 0;
                    this.retryNum = 0;
                }
            }
        }
        if (sendRetrySignal) {
            throw new RetryException();
        }
    }

    protected String getDbEpochString() throws MetaException {
        switch (dbProduct) {
            case DERBY: {
                if (epochInCurrentTimezone == null) {
                    epochInCurrentTimezone = new Timestamp(0L).toString();
                }
                return "{ fn timestampdiff(sql_tsi_frac_second, timestamp('" + epochInCurrentTimezone + "'), current_timestamp) } / 1000000";
            }
            case MYSQL: {
                return "round(unix_timestamp(now(3)) * 1000)";
            }
            case POSTGRES: {
                return "round(extract(epoch from current_timestamp) * 1000)";
            }
            case ORACLE: {
                return "(cast(systimestamp at time zone 'UTC' as date) - date '1970-01-01')*24*60*60*1000 + cast(mod( extract( second from systimestamp ), 1 ) * 1000 as int)";
            }
            case SQLSERVER: {
                return "datediff_big(millisecond, '19700101', sysutcdatetime())";
            }
        }
        String msg = "Unknown database product: " + dbProduct.toString();
        LOG.error(msg);
        throw new MetaException(msg);
    }

    protected long getDbTime(Connection conn) throws MetaException {
        Statement stmt = null;
        try {
            String s;
            stmt = conn.createStatement();
            switch (dbProduct) {
                case DERBY: {
                    s = "values current_timestamp";
                    break;
                }
                case MYSQL: 
                case POSTGRES: 
                case SQLSERVER: {
                    s = "select current_timestamp";
                    break;
                }
                case ORACLE: {
                    s = "select current_timestamp from dual";
                    break;
                }
                default: {
                    String msg = "Unknown database product: " + dbProduct.toString();
                    LOG.error(msg);
                    throw new MetaException(msg);
                }
            }
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("No results from date query");
            }
            long l = rs.getTimestamp(1).getTime();
            return l;
        }
        catch (SQLException e) {
            String msg = "Unable to determine current time: " + e.getMessage();
            LOG.error(msg);
            throw new MetaException(msg);
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    protected String isWithinCheckInterval(String expr, long interval) throws MetaException {
        String condition;
        switch (dbProduct) {
            case DERBY: {
                condition = " {fn TIMESTAMPDIFF(sql_tsi_second, " + expr + ", current_timestamp)} <= " + interval;
                break;
            }
            case MYSQL: 
            case POSTGRES: {
                condition = expr + " >= current_timestamp - interval '" + interval + "' second";
                break;
            }
            case SQLSERVER: {
                condition = "DATEDIFF(second, " + expr + ", current_timestamp) <= " + interval;
                break;
            }
            case ORACLE: {
                condition = expr + " >= current_timestamp - numtodsinterval(" + interval + " , 'second')";
                break;
            }
            default: {
                String msg = "Unknown database product: " + dbProduct.toString();
                LOG.error(msg);
                throw new MetaException(msg);
            }
        }
        return condition;
    }

    protected String getIdentifierQuoteString(Connection conn) throws SQLException {
        if (this.identifierQuoteString == null) {
            this.identifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
        }
        return this.identifierQuoteString;
    }

    private void determineDatabaseProduct(Connection conn) {
        if (dbProduct != null) {
            return;
        }
        try {
            String s = conn.getMetaData().getDatabaseProductName();
            dbProduct = DatabaseProduct.determineDatabaseProduct(s);
            if (dbProduct == DatabaseProduct.OTHER) {
                String msg = "Unrecognized database product name <" + s + ">";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        catch (SQLException e) {
            String msg = "Unable to get database product name";
            LOG.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    private void checkQFileTestHack() {
        block3: {
            boolean hackOn;
            boolean bl = hackOn = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST);
            if (hackOn) {
                LOG.info("Hacking in canned values for transaction manager");
                TxnDbUtil.setConfValues(this.conf);
                try {
                    TxnDbUtil.prepDb(this.conf);
                }
                catch (Exception e) {
                    if (e.getMessage() == null || e.getMessage().contains("already exists")) break block3;
                    throw new RuntimeException("Unable to set up transaction database for testing: " + e.getMessage(), e);
                }
            }
        }
    }

    private int abortTxns(Connection dbConn, List<Long> txnids, boolean isStrict) throws SQLException, MetaException {
        return this.abortTxns(dbConn, txnids, false, isStrict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortTxns(Connection dbConn, List<Long> txnids, boolean checkHeartbeat, boolean isStrict) throws SQLException, MetaException {
        Statement stmt = null;
        int updateCnt = 0;
        if (txnids.isEmpty()) {
            return 0;
        }
        try {
            int rc;
            stmt = dbConn.createStatement();
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("update TXNS set txn_state = " + TxnHandler.quoteChar('a') + " where txn_state = " + TxnHandler.quoteChar('o') + " and ");
            if (checkHeartbeat) {
                suffix.append(" AND txn_last_heartbeat < ").append(this.getDbEpochString()).append("-").append(this.timeout);
            }
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "txn_id", true, false);
            for (String query : queries) {
                LOG.debug("Going to execute update <" + query + ">");
                updateCnt += stmt.executeUpdate(query);
            }
            queries.clear();
            prefix.setLength(0);
            suffix.setLength(0);
            prefix.append("delete from MIN_HISTORY_LEVEL where ");
            suffix.append("");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "mhl_txnid", false, false);
            for (String query : queries) {
                LOG.debug("Going to execute update <" + query + ">");
                rc = stmt.executeUpdate(query);
                LOG.debug("Deleted " + rc + " records from MIN_HISTORY_LEVEL");
            }
            LOG.info("Removed aborted transactions: (" + txnids + ") from MIN_HISTORY_LEVEL");
            if (updateCnt < txnids.size() && isStrict) {
                int n = updateCnt;
                return n;
            }
            queries.clear();
            prefix.setLength(0);
            suffix.setLength(0);
            prefix.append("delete from HIVE_LOCKS where ");
            suffix.append("");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "hl_txnid", false, false);
            for (String query : queries) {
                LOG.debug("Going to execute update <" + query + ">");
                rc = stmt.executeUpdate(query);
                LOG.debug("Removed " + rc + " records from HIVE_LOCKS");
            }
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
        return updateCnt;
    }

    private static boolean isValidTxn(long txnId) {
        return txnId != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RetrySemantics.SafeToRetry(value={"See @SafeToRetry"})
    private LockResponse checkLock(Connection dbConn, long extLockId) throws NoSuchLockException, TxnAbortedException, MetaException, SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        LockResponse response = new LockResponse();
        boolean isPartOfDynamicPartitionInsert = true;
        try {
            boolean bl;
            List<LockInfo> locksBeingChecked = this.getLockInfoFromLockId(dbConn, extLockId);
            response.setLockid(extLockId);
            LOG.debug("checkLock(): Setting savepoint. extLockId=" + JavaUtils.lockIdToString(extLockId));
            StringBuilder query = new StringBuilder("select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_db in (");
            HashSet<String> strings = new HashSet<String>(locksBeingChecked.size());
            ArrayList<LockInfo> writeSet = new ArrayList<LockInfo>();
            for (LockInfo lockInfo : locksBeingChecked) {
                strings.add(lockInfo.db);
                if (isPartOfDynamicPartitionInsert || lockInfo.type != LockType.SHARED_WRITE) continue;
                writeSet.add(lockInfo);
            }
            if (!writeSet.isEmpty()) {
                if (((LockInfo)writeSet.get(0)).txnId == 0L) {
                    throw new IllegalStateException("Found Write lock for " + JavaUtils.lockIdToString(extLockId) + " but no txnid");
                }
                stmt = dbConn.createStatement();
                StringBuilder sb = new StringBuilder(" ws_database, ws_table, ws_partition, ws_txnid, ws_commit_id from WRITE_SET where ws_commit_id >= " + ((LockInfo)writeSet.get(0)).txnId + " and (");
                for (LockInfo lockInfo : writeSet) {
                    sb.append("(ws_database = ").append(TxnHandler.quoteString(lockInfo.db)).append(" and ws_table = ").append(TxnHandler.quoteString(lockInfo.table)).append(" and ws_partition ").append(lockInfo.partition == null ? "is null" : "= " + TxnHandler.quoteString(lockInfo.partition)).append(") or ");
                }
                sb.setLength(sb.length() - 4);
                sb.append(")");
                rs = stmt.executeQuery(sqlGenerator.addLimitClause(1, sb.toString()));
                if (rs.next()) {
                    void var13_17;
                    String string = rs.getString(1) + '/' + rs.getString(2);
                    String string2 = rs.getString(3);
                    if (string2 != null) {
                        String string3 = string + '/' + string2;
                    }
                    String msg = "Aborting " + JavaUtils.txnIdToString(((LockInfo)writeSet.get(0)).txnId) + " since a concurrent committed transaction [" + JavaUtils.txnIdToString(rs.getLong(4)) + "," + rs.getLong(5) + "] has already updated resource '" + (String)var13_17 + "'";
                    LOG.info(msg);
                    if (this.abortTxns(dbConn, Collections.singletonList(((LockInfo)writeSet.get(0)).txnId), true) != 1) {
                        throw new IllegalStateException(msg + " FAILED!");
                    }
                    dbConn.commit();
                    throw new TxnAbortedException(msg);
                }
                TxnHandler.close(rs, stmt, null);
            }
            boolean first = true;
            for (String string : strings) {
                if (first) {
                    first = false;
                } else {
                    query.append(", ");
                }
                query.append('\'');
                query.append(string);
                query.append('\'');
            }
            query.append(")");
            boolean bl2 = false;
            strings.clear();
            for (LockInfo info : locksBeingChecked) {
                if (info.table == null) {
                    bl = true;
                    break;
                }
                strings.add(info.table);
            }
            if (!bl) {
                boolean bl3;
                query.append(" and (hl_table is null or hl_table in(");
                first = true;
                for (String s : strings) {
                    if (first) {
                        first = false;
                    } else {
                        query.append(", ");
                    }
                    query.append('\'');
                    query.append(s);
                    query.append('\'');
                }
                query.append("))");
                boolean bl4 = false;
                strings.clear();
                for (LockInfo info : locksBeingChecked) {
                    if (info.partition == null) {
                        bl3 = true;
                        break;
                    }
                    strings.add(info.partition);
                }
                if (!bl3) {
                    query.append(" and (hl_partition is null or hl_partition in(");
                    first = true;
                    for (String s : strings) {
                        if (first) {
                            first = false;
                        } else {
                            query.append(", ");
                        }
                        query.append('\'');
                        query.append(s);
                        query.append('\'');
                    }
                    query.append("))");
                }
            }
            query.append(" and hl_lock_ext_id < ").append(extLockId);
            LOG.debug("Going to execute query <" + query.toString() + ">");
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery(query.toString());
            TreeSet<LockInfo> treeSet = new TreeSet<LockInfo>(new LockInfoComparator());
            while (rs.next()) {
                treeSet.add(new LockInfo(rs));
            }
            LockInfo[] locks = treeSet.toArray(new LockInfo[treeSet.size()]);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Locks to check(full): ");
                for (LockInfo info : locks) {
                    LOG.trace("  " + info);
                }
            }
            LockInfo[] lockInfoArray = locksBeingChecked.iterator();
            block17: while (true) {
                LockInfo info;
                if (lockInfoArray.hasNext()) {
                    info = (LockInfo)lockInfoArray.next();
                    if (info.state == LockState.ACQUIRED) continue;
                } else {
                    this.acquire(dbConn, stmt, locksBeingChecked);
                    LOG.debug("Going to commit");
                    dbConn.commit();
                    response.setState(LockState.ACQUIRED);
                    TxnHandler.close(rs, stmt, null);
                    return response;
                }
                int i = locks.length - 1;
                while (true) {
                    block39: {
                        if (i < 0) continue block17;
                        if (!info.db.equals(locks[i].db) || info.table != null && locks[i].table != null && !info.table.equals(locks[i].table) || info.partition != null && locks[i].partition != null && !info.partition.equals(locks[i].partition)) break block39;
                        LockAction lockAction = jumpTable.get((Object)info.type).get((Object)locks[i].type).get((Object)locks[i].state);
                        LOG.debug("desired Lock: " + info + " checked Lock: " + locks[i] + " action: " + (Object)((Object)lockAction));
                        switch (lockAction) {
                            case WAIT: {
                                if (!this.ignoreConflict(info, locks[i])) {
                                    String sqlText = "update HIVE_LOCKS set HL_BLOCKEDBY_EXT_ID=" + locks[i].extLockId + ", HL_BLOCKEDBY_INT_ID=" + locks[i].intLockId + " where HL_LOCK_EXT_ID=" + info.extLockId + " and HL_LOCK_INT_ID=" + info.intLockId;
                                    LOG.debug("Executing sql: " + sqlText);
                                    int updCnt = stmt.executeUpdate(sqlText);
                                    if (updCnt != 1) {
                                        TxnHandler.shouldNeverHappen(info.txnId, info.extLockId, info.intLockId);
                                    }
                                    LOG.debug("Going to commit");
                                    dbConn.commit();
                                    response.setState(LockState.WAITING);
                                    LOG.debug("Lock(" + info + ") waiting for Lock(" + locks[i] + ")");
                                    LockResponse lockResponse = response;
                                    TxnHandler.close(rs, stmt, null);
                                    return lockResponse;
                                }
                            }
                            case ACQUIRE: {
                                break;
                            }
                            case KEEP_LOOKING: {
                                break block39;
                            }
                        }
                        continue block17;
                    }
                    --i;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs, stmt, null);
            throw throwable;
        }
    }

    private void acquire(Connection dbConn, Statement stmt, List<LockInfo> locksBeingChecked) throws SQLException, NoSuchLockException, MetaException {
        if (locksBeingChecked == null || locksBeingChecked.isEmpty()) {
            return;
        }
        long txnId = locksBeingChecked.get(0).txnId;
        long extLockId = locksBeingChecked.get(0).extLockId;
        String s = "update HIVE_LOCKS set hl_lock_state = 'a', hl_last_heartbeat = " + (TxnHandler.isValidTxn(txnId) ? Integer.valueOf(0) : this.getDbEpochString()) + ", hl_acquired_at = " + this.getDbEpochString() + ",HL_BLOCKEDBY_EXT_ID=NULL,HL_BLOCKEDBY_INT_ID=null" + " where hl_lock_ext_id = " + extLockId;
        LOG.debug("Going to execute update <" + s + ">");
        int rc = stmt.executeUpdate(s);
        if (rc < locksBeingChecked.size()) {
            LOG.debug("Going to rollback acquire(Connection dbConn, Statement stmt, List<LockInfo> locksBeingChecked)");
            dbConn.rollback();
            StringBuilder sb = new StringBuilder("No such lock(s): (" + JavaUtils.lockIdToString(extLockId) + ":");
            ResultSet rs = stmt.executeQuery("select hl_lock_int_id from HIVE_LOCKS where hl_lock_ext_id = " + extLockId);
            block0: while (rs.next()) {
                int intLockId = rs.getInt(1);
                for (int idx = 0; idx < locksBeingChecked.size(); ++idx) {
                    LockInfo expectedLock = locksBeingChecked.get(idx);
                    if (expectedLock == null || expectedLock.intLockId != (long)intLockId) continue;
                    locksBeingChecked.set(idx, null);
                    continue block0;
                }
            }
            for (LockInfo expectedLock : locksBeingChecked) {
                if (expectedLock == null) continue;
                sb.append(expectedLock.intLockId).append(",");
            }
            sb.append(") ").append(JavaUtils.txnIdToString(txnId));
            TxnHandler.close(rs);
            throw new NoSuchLockException(sb.toString());
        }
    }

    private boolean ignoreConflict(LockInfo desiredLock, LockInfo existingLock) {
        return desiredLock.isDbLock() && desiredLock.type == LockType.SHARED_READ && existingLock.isTableLock() && existingLock.type == LockType.EXCLUSIVE || existingLock.isDbLock() && existingLock.type == LockType.SHARED_READ && desiredLock.isTableLock() && desiredLock.type == LockType.EXCLUSIVE || desiredLock.isDbLock() && desiredLock.type == LockType.SHARED_READ && existingLock.isPartitionLock() && existingLock.type == LockType.EXCLUSIVE || existingLock.isDbLock() && existingLock.type == LockType.SHARED_READ && desiredLock.isPartitionLock() && desiredLock.type == LockType.EXCLUSIVE || desiredLock.txnId != 0L && desiredLock.txnId == existingLock.txnId || desiredLock.txnId == 0L && desiredLock.extLockId == existingLock.extLockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatLock(Connection dbConn, long extLockId) throws NoSuchLockException, SQLException, MetaException {
        if (extLockId == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "update HIVE_LOCKS set hl_last_heartbeat = " + this.getDbEpochString() + " where hl_lock_ext_id = " + extLockId;
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                LOG.debug("Going to rollback");
                dbConn.rollback();
                throw new NoSuchLockException("No such lock: " + JavaUtils.lockIdToString(extLockId));
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatTxn(Connection dbConn, long txnid) throws NoSuchTxnException, TxnAbortedException, SQLException, MetaException {
        if (txnid == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "update TXNS set txn_last_heartbeat = " + this.getDbEpochString() + " where txn_id = " + txnid + " and txn_state = '" + 'o' + "'";
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                LOG.warn("Can neither heartbeat txn nor confirm it as invalid.");
                dbConn.rollback();
                throw new NoSuchTxnException("No such txn: " + txnid);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    private TxnStatus findTxnState(long txnid, Statement stmt) throws SQLException, MetaException {
        String s = "select txn_state from TXNS where txn_id = " + txnid;
        LOG.debug("Going to execute query <" + s + ">");
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                s = sqlGenerator.addLimitClause(1, "1 from COMPLETED_TXN_COMPONENTS where CTC_TXNID = " + txnid);
                LOG.debug("Going to execute query <" + s + ">");
                try (Object rs2 = stmt.executeQuery(s);){
                    if (rs2.next()) {
                        TxnStatus txnStatus = TxnStatus.COMMITTED;
                        return txnStatus;
                    }
                }
                rs2 = TxnStatus.UNKNOWN;
                return rs2;
            }
            char txnState = rs.getString(1).charAt(0);
            if (txnState == 'a') {
                TxnStatus txnStatus = TxnStatus.ABORTED;
                return txnStatus;
            }
            assert (txnState == 'o') : "we found it in TXNS but it's not ABORTED, so must be OPEN";
        }
        return TxnStatus.OPEN;
    }

    private boolean isTxnsOpenAndNotReadOnly(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("select count(*) from TXNS where txn_state = 'o' and txn_type != " + TxnType.READ_ONLY.getValue() + " and ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "txn_id", false, false);
        long count = 0L;
        for (String query : queries) {
            LOG.debug("Going to execute query <" + query + ">");
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                if (!rs.next()) continue;
                count += rs.getLong(1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return count == (long)txnIds.size();
    }

    private String getAbortedAndReadOnlyTxns(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("select txn_id, txn_state, txn_type from TXNS where ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "txn_id", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <" + query + ">");
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    char txnState = rs.getString(2).charAt(0);
                    TxnType txnType = TxnType.findByValue(rs.getInt(3));
                    if (txnState != 'o') {
                        txnInfo.append("{").append(txnId).append(",").append(txnState).append("}");
                        continue;
                    }
                    if (txnType != TxnType.READ_ONLY) continue;
                    txnInfo.append("{").append(txnId).append(",read-only}");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return txnInfo.toString();
    }

    private String getCommittedTxns(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("select ctc_txnid from COMPLETED_TXN_COMPONENTS where ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "ctc_txnid", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <" + query + ">");
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    txnInfo.append("{").append(txnId).append(",c}");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return txnInfo.toString();
    }

    private static void raiseTxnUnexpectedState(TxnStatus actualStatus, long txnid) throws NoSuchTxnException, TxnAbortedException {
        switch (actualStatus) {
            case ABORTED: {
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
            }
            case COMMITTED: {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
            }
            case UNKNOWN: {
                throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
            }
            case OPEN: {
                throw new NoSuchTxnException(JavaUtils.txnIdToString(txnid) + " is " + (Object)((Object)TxnStatus.OPEN));
            }
        }
        throw new IllegalArgumentException("Unknown TxnStatus " + (Object)((Object)actualStatus));
    }

    private static void ensureValidTxn(Connection dbConn, long txnid, Statement stmt) throws SQLException, NoSuchTxnException, TxnAbortedException {
        String s = "select txn_state from TXNS where txn_id = " + txnid;
        LOG.debug("Going to execute query <" + s + ">");
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                s = "select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TXNID = " + txnid;
                ResultSet rs2 = stmt.executeQuery(s);
                Throwable throwable = null;
                try {
                    try {
                        boolean alreadyCommitted = rs2.next() && rs2.getInt(1) > 0;
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        if (alreadyCommitted) {
                            throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
                        }
                        throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                    throw throwable3;
                }
            }
            if (rs.getString(1).charAt(0) == 'a') {
                LOG.debug("Going to rollback");
                TxnHandler.rollbackDBConn(dbConn);
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockInfo getTxnIdFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        ResultSet rs;
        Statement stmt;
        block3: {
            LockInfo lockInfo;
            stmt = null;
            rs = null;
            try {
                stmt = dbConn.createStatement();
                String s = "select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next()) break block3;
                lockInfo = null;
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(stmt);
                throw throwable;
            }
            TxnHandler.close(rs);
            TxnHandler.closeStmt(stmt);
            return lockInfo;
        }
        LockInfo info = new LockInfo(rs);
        LOG.debug("getTxnIdFromLockId(" + extLockId + ") Return " + JavaUtils.txnIdToString(info.txnId));
        LockInfo lockInfo = info;
        TxnHandler.close(rs);
        TxnHandler.closeStmt(stmt);
        return lockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LockInfo> getLockInfoFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            boolean sawAtLeastOne = false;
            ArrayList<LockInfo> ourLockInfo = new ArrayList<LockInfo>();
            while (rs.next()) {
                ourLockInfo.add(new LockInfo(rs));
                sawAtLeastOne = true;
            }
            if (!sawAtLeastOne) {
                throw new MetaException("This should never happen!  We already checked the lock(" + JavaUtils.lockIdToString(extLockId) + ") existed but now we can't find it!");
            }
            ArrayList<LockInfo> arrayList = ourLockInfo;
            return arrayList;
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void timeOutLocks(Connection dbConn) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            String s = "select distinct hl_lock_ext_id from HIVE_LOCKS where hl_last_heartbeat < " + this.getDbEpochString() + "-" + this.timeout + " and hl_txnid = 0";
            ArrayList<Long> extLockIDs = new ArrayList<Long>();
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                extLockIDs.add(rs.getLong(1));
            }
            rs.close();
            dbConn.commit();
            if (extLockIDs.size() <= 0) {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(stmt);
                return;
            }
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("delete from HIVE_LOCKS where hl_last_heartbeat < ");
            prefix.append(this.getDbEpochString()).append("-").append(this.timeout);
            prefix.append(" and hl_txnid = 0 and ");
            suffix.append("");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, extLockIDs, "hl_lock_ext_id", true, false);
            int deletedLocks = 0;
            for (String query : queries) {
                LOG.debug("Removing expired locks via: " + query);
                deletedLocks += stmt.executeUpdate(query);
            }
            if (deletedLocks > 0) {
                Collections.sort(extLockIDs);
                LOG.info("Deleted " + deletedLocks + " int locks from HIVE_LOCKS due to timeout (" + "HL_LOCK_EXT_ID list:  " + extLockIDs + ")");
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            TxnHandler.close(rs);
        }
        catch (SQLException ex) {
            LOG.error("Failed to purge timedout locks due to: " + TxnHandler.getMessage(ex), (Throwable)ex);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                LOG.error("Failed to purge timedout locks due to: " + ex2.getMessage(), (Throwable)ex2);
                return;
            }
        }
        finally {
            TxnHandler.close(rs);
            TxnHandler.closeStmt(stmt);
        }
        TxnHandler.closeStmt(stmt);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public void performTimeOuts() {
        dbConn = null;
        stmt = null;
        rs = null;
        try {
            dbConn = this.getDbConn(2);
            this.timeOutLocks(dbConn);
lbl7:
            // 2 sources

            while (true) {
                stmt = dbConn.createStatement();
                s = " txn_id from TXNS where txn_state = 'o' and txn_last_heartbeat <  " + this.getDbEpochString() + "-" + this.timeout + " and txn_type != " + TxnType.REPL_CREATED.getValue();
                s = TxnHandler.sqlGenerator.addLimitClause(500000, s);
                TxnHandler.LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next()) ** GOTO lbl-1000
                ** GOTO lbl26
                break;
            }
        }
        catch (SQLException ex) {
            TxnHandler.LOG.warn("Aborting timed out transactions failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
        catch (MetaException e) {
            try {
                TxnHandler.LOG.warn("Aborting timed out transactions failed due to " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable var10_12) {
                TxnHandler.close(rs, stmt, dbConn);
                throw var10_12;
            }
lbl26:
            // 1 sources

            TxnHandler.close(rs, stmt, dbConn);
            return;
lbl-1000:
            // 1 sources

            {
                timedOutTxns = new ArrayList<ArrayList<E>>();
                currentBatch = new ArrayList<Long>(50000);
                timedOutTxns.add(currentBatch);
                do {
                    if (currentBatch.size() == 50000) {
                        currentBatch = new ArrayList<E>(50000);
                        timedOutTxns.add(currentBatch);
                    }
                    currentBatch.add(rs.getLong(1));
                } while (rs.next());
                dbConn.commit();
                TxnHandler.close(rs, stmt, null);
                numTxnsAborted = 0;
                for (List var9_11 : timedOutTxns) {
                    if (this.abortTxns(dbConn, var9_11, true, true) == var9_11.size()) {
                        dbConn.commit();
                        numTxnsAborted += var9_11.size();
                        Collections.sort(var9_11);
                        TxnHandler.LOG.info("Aborted the following transactions due to timeout: " + var9_11.toString());
                        continue;
                    }
                    dbConn.rollback();
                }
                TxnHandler.LOG.info("Aborted " + numTxnsAborted + " transactions due to timeout");
                ** continue;
            }
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public void countOpenTxns() throws MetaException {
        block9: {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                block8: {
                    try {
                        dbConn = this.getDbConn(2);
                        stmt = dbConn.createStatement();
                        String s = "select count(*) from TXNS where txn_state = 'o'";
                        LOG.debug("Going to execute query <" + s + ">");
                        rs = stmt.executeQuery(s);
                        if (!rs.next()) {
                            LOG.error("Transaction database not properly configured, can't find txn_state from TXNS.");
                            break block8;
                        }
                        Long numOpen = rs.getLong(1);
                        if (numOpen > Integer.MAX_VALUE) {
                            LOG.error("Open transaction count above 2147483647, can't count that high!");
                            break block8;
                        }
                        this.numOpenTxns.set(numOpen.intValue());
                    }
                    catch (SQLException e) {
                        try {
                            LOG.debug("Going to rollback");
                            TxnHandler.rollbackDBConn(dbConn);
                            LOG.info("Failed to update number of open transactions");
                            this.checkRetryable(dbConn, e, "countOpenTxns()");
                        }
                        catch (Throwable throwable) {
                            TxnHandler.close(rs, stmt, dbConn);
                            throw throwable;
                        }
                        TxnHandler.close(rs, stmt, dbConn);
                        break block9;
                    }
                }
                TxnHandler.close(rs, stmt, dbConn);
            }
            catch (RetryException e) {
                this.countOpenTxns();
            }
        }
    }

    private static synchronized DataSource setupJdbcConnectionPool(Configuration conf, int maxPoolSize, long getConnectionTimeoutMs) throws SQLException {
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider(conf);
        if (dsp != null) {
            doRetryOnConnPool = dsp.mayReturnClosedConnection();
            return dsp.create(conf);
        }
        String connectionPooler = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE).toLowerCase();
        if ("none".equals(connectionPooler)) {
            LOG.info("Choosing not to pool JDBC connections");
            return new NoPoolConnectionPool(conf);
        }
        throw new RuntimeException("Unknown JDBC connection pooling " + connectionPooler);
    }

    private static synchronized void buildJumpTable() {
        if (jumpTable != null) {
            return;
        }
        jumpTable = new HashMap<LockType, Map<LockType, Map<LockState, LockAction>>>(3);
        HashMap m = new HashMap(3);
        jumpTable.put(LockType.SHARED_READ, m);
        HashMap<LockState, LockAction> m2 = new HashMap<LockState, LockAction>(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.SHARED_WRITE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.KEEP_LOOKING);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.EXCLUSIVE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
    }

    static boolean isRetryable(Configuration conf, Exception ex) {
        if (ex instanceof SQLException) {
            SQLException sqlException = (SQLException)ex;
            if ("08S01".equalsIgnoreCase(sqlException.getSQLState())) {
                return true;
            }
            if ("ORA-08176".equalsIgnoreCase(sqlException.getSQLState()) || sqlException.getMessage().contains("consistent read failure; rollback data not available")) {
                return true;
            }
            String regex = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.TXN_RETRYABLE_SQLEX_REGEX);
            if (regex != null && !regex.isEmpty()) {
                String[] patterns = regex.split(",(?=\\S)");
                String message = TxnHandler.getMessage((SQLException)ex);
                for (String p : patterns) {
                    if (!Pattern.matches(p, message)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDuplicateKeyError(SQLException ex) {
        switch (dbProduct) {
            case DERBY: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            case MYSQL: {
                if (ex.getErrorCode() != 1022 && ex.getErrorCode() != 1062 && ex.getErrorCode() != 1586 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case SQLSERVER: {
                if (ex.getErrorCode() != 2627 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case ORACLE: {
                if (ex.getErrorCode() != 1 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case POSTGRES: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unexpected DB type: " + (Object)((Object)dbProduct) + "; " + TxnHandler.getMessage(ex));
            }
        }
        return false;
    }

    private static String getMessage(SQLException ex) {
        return ex.getMessage() + " (SQLState=" + ex.getSQLState() + ", ErrorCode=" + ex.getErrorCode() + ")";
    }

    private static String valueOrNullLiteral(String value) {
        return value == null ? "null" : TxnHandler.quoteString(value);
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    static String quoteChar(char c) {
        return "'" + c + "'";
    }

    static CompactionType dbCompactionType2ThriftType(char dbValue) {
        switch (dbValue) {
            case 'a': {
                return CompactionType.MAJOR;
            }
            case 'i': {
                return CompactionType.MINOR;
            }
        }
        LOG.warn("Unexpected compaction type " + dbValue);
        return null;
    }

    static Character thriftCompactionType2DbType(CompactionType ct) {
        switch (ct) {
            case MAJOR: {
                return Character.valueOf('a');
            }
            case MINOR: {
                return Character.valueOf('i');
            }
        }
        LOG.warn("Unexpected compaction type " + (Object)((Object)ct));
        return null;
    }

    private void lockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.lock();
        }
    }

    private void unlockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.unlock();
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public TxnStore.MutexAPI getMutexAPI() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TxnStore.MutexAPI.LockHandle acquireLock(String key) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String sqlStmt = sqlGenerator.addForUpdateClause("select MT_COMMENT from AUX_TABLE where MT_KEY1=" + TxnHandler.quoteString(key) + " and MT_KEY2=0");
                this.lockInternal();
                dbConn = this.getDbConn(2, connPoolMutex);
                stmt = dbConn.createStatement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("About to execute SQL: " + sqlStmt);
                }
                if (!(rs = stmt.executeQuery(sqlStmt)).next()) {
                    TxnHandler.close(rs);
                    try {
                        stmt.executeUpdate("insert into AUX_TABLE(MT_KEY1,MT_KEY2) values(" + TxnHandler.quoteString(key) + ", 0)");
                        dbConn.commit();
                    }
                    catch (SQLException ex) {
                        if (!this.isDuplicateKeyError(ex)) {
                            throw new RuntimeException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex), ex);
                        }
                        dbConn.rollback();
                    }
                    rs = stmt.executeQuery(sqlStmt);
                    if (!rs.next()) {
                        throw new IllegalStateException("Unable to lock " + TxnHandler.quoteString(key) + ".  Expected row in AUX_TABLE is missing.");
                    }
                }
                Semaphore derbySemaphore = null;
                if (dbProduct == DatabaseProduct.DERBY) {
                    derbyKey2Lock.putIfAbsent(key, new Semaphore(1));
                    derbySemaphore = derbyKey2Lock.get(key);
                    derbySemaphore.acquire();
                }
                LOG.debug(TxnHandler.quoteString(key) + " locked by " + TxnHandler.quoteString(hostname));
                LockHandleImpl lockHandleImpl = new LockHandleImpl(dbConn, stmt, rs, key, derbySemaphore);
                return lockHandleImpl;
            }
            catch (SQLException ex) {
                TxnHandler.rollbackDBConn(dbConn);
                TxnHandler.close(rs, stmt, dbConn);
                this.checkRetryable(dbConn, ex, "acquireLock(" + key + ")");
                throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex) + "; " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            }
            catch (InterruptedException ex) {
                TxnHandler.rollbackDBConn(dbConn);
                TxnHandler.close(rs, stmt, dbConn);
                throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + ex.getMessage() + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            }
            finally {
                this.unlockInternal();
            }
        }
        catch (RetryException ex) {
            return this.acquireLock(key);
        }
    }

    @Override
    public void acquireLock(String key, TxnStore.MutexAPI.LockHandle handle) {
        throw new NotImplementedException();
    }

    static {
        doRetryOnConnPool = false;
        maxOpenTxns = 0;
        tooManyOpenTxns = false;
        derbyLock = new ReentrantLock(true);
        derbyKey2Lock = new ConcurrentHashMap();
        hostname = JavaUtils.hostname();
        epochInCurrentTimezone = null;
    }

    private static class NoPoolConnectionPool
    implements DataSource {
        private final Configuration conf;
        private Driver driver;
        private String connString;
        private String user;
        private String passwd;

        public NoPoolConnectionPool(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.user == null) {
                this.user = DataSourceProvider.getMetastoreJdbcUser(this.conf);
                this.passwd = DataSourceProvider.getMetastoreJdbcPasswd(this.conf);
            }
            return this.getConnection(this.user, this.passwd);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            if (this.driver == null) {
                String driverName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.CONNECTION_DRIVER);
                if (driverName == null || driverName.equals("")) {
                    String msg = "JDBC driver for transaction db not set in configuration file, need to set " + MetastoreConf.ConfVars.CONNECTION_DRIVER.getVarname();
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
                try {
                    LOG.info("Going to load JDBC driver " + driverName);
                    this.driver = (Driver)Class.forName(driverName).newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Unable to instantiate driver " + driverName + ", " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to access driver " + driverName + ", " + e.getMessage(), e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to find driver " + driverName + ", " + e.getMessage(), e);
                }
                this.connString = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.CONNECT_URL_KEY);
            }
            try {
                LOG.info("Connecting to transaction db with connection string " + this.connString);
                Properties connectionProps = new Properties();
                connectionProps.setProperty("user", username);
                connectionProps.setProperty("password", password);
                Connection conn = this.driver.connect(this.connString, connectionProps);
                conn.setAutoCommit(false);
                return conn;
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to connect to transaction manager using " + this.connString + ", " + e.getMessage(), e);
            }
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LockHandleImpl
    implements TxnStore.MutexAPI.LockHandle {
        private final Connection dbConn;
        private final Statement stmt;
        private final ResultSet rs;
        private final Semaphore derbySemaphore;
        private final List<String> keys = new ArrayList<String>();

        LockHandleImpl(Connection conn, Statement stmt, ResultSet rs, String key, Semaphore derbySemaphore) {
            this.dbConn = conn;
            this.stmt = stmt;
            this.rs = rs;
            this.derbySemaphore = derbySemaphore;
            if (derbySemaphore != null) assert (derbySemaphore.availablePermits() == 0) : "Expected locked Semaphore";
            this.keys.add(key);
        }

        void addKey(String key) {
            throw new NotImplementedException();
        }

        @Override
        public void releaseLocks() {
            TxnHandler.rollbackDBConn(this.dbConn);
            TxnHandler.close(this.rs, this.stmt, this.dbConn);
            if (this.derbySemaphore != null) {
                this.derbySemaphore.release();
            }
            for (String key : this.keys) {
                LOG.debug(TxnHandler.quoteString(key) + " unlocked by " + TxnHandler.quoteString(hostname));
            }
        }
    }

    private static enum LockAction {
        ACQUIRE,
        WAIT,
        KEEP_LOOKING;

    }

    private static final class LockTypeComparator
    implements Comparator<LockType> {
        private LockTypeComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockType t1, LockType t2) {
            switch (t1) {
                case EXCLUSIVE: {
                    if (t2 == LockType.EXCLUSIVE) {
                        return 0;
                    }
                    return 1;
                }
                case SHARED_WRITE: {
                    switch (t2) {
                        case EXCLUSIVE: {
                            return -1;
                        }
                        case SHARED_WRITE: {
                            return 0;
                        }
                        case SHARED_READ: {
                            return 1;
                        }
                    }
                    throw new RuntimeException("Unexpected LockType: " + (Object)((Object)t2));
                }
                case SHARED_READ: {
                    if (t2 == LockType.SHARED_READ) {
                        return 0;
                    }
                    return -1;
                }
            }
            throw new RuntimeException("Unexpected LockType: " + (Object)((Object)t1));
        }
    }

    private static class LockInfoComparator
    implements Comparator<LockInfo> {
        private static final LockTypeComparator lockTypeComparator = new LockTypeComparator();

        private LockInfoComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockInfo info1, LockInfo info2) {
            if (info1.state == LockState.ACQUIRED && info2.state != LockState.ACQUIRED) {
                return -1;
            }
            if (info1.state != LockState.ACQUIRED && info2.state == LockState.ACQUIRED) {
                return 1;
            }
            int sortByType = lockTypeComparator.compare(info1.type, info2.type);
            if (sortByType != 0) {
                return sortByType;
            }
            if (info1.extLockId < info2.extLockId) {
                return -1;
            }
            if (info1.extLockId > info2.extLockId) {
                return 1;
            }
            if (info1.intLockId < info2.intLockId) {
                return -1;
            }
            if (info1.intLockId > info2.intLockId) {
                return 1;
            }
            return 0;
        }
    }

    private static class LockInfo {
        private final long extLockId;
        private final long intLockId;
        private final long txnId;
        private final String db;
        private final String table;
        private final String partition;
        private final LockState state;
        private final LockType type;

        LockInfo(ResultSet rs) throws SQLException, MetaException {
            this.extLockId = rs.getLong("hl_lock_ext_id");
            this.intLockId = rs.getLong("hl_lock_int_id");
            this.db = rs.getString("hl_db");
            String t = rs.getString("hl_table");
            this.table = rs.wasNull() ? null : t;
            String p = rs.getString("hl_partition");
            this.partition = rs.wasNull() ? null : p;
            switch (rs.getString("hl_lock_state").charAt(0)) {
                case 'w': {
                    this.state = LockState.WAITING;
                    break;
                }
                case 'a': {
                    this.state = LockState.ACQUIRED;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock state " + rs.getString("hl_lock_state").charAt(0));
                }
            }
            switch (rs.getString("hl_lock_type").charAt(0)) {
                case 'e': {
                    this.type = LockType.EXCLUSIVE;
                    break;
                }
                case 'r': {
                    this.type = LockType.SHARED_READ;
                    break;
                }
                case 'w': {
                    this.type = LockType.SHARED_WRITE;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock type " + rs.getString("hl_lock_type").charAt(0));
                }
            }
            this.txnId = rs.getLong("hl_txnid");
        }

        LockInfo(ShowLocksResponseElement e) {
            this.extLockId = e.getLockid();
            this.intLockId = e.getLockIdInternal();
            this.txnId = e.getTxnid();
            this.db = e.getDbname();
            this.table = e.getTablename();
            this.partition = e.getPartname();
            this.state = e.getState();
            this.type = e.getType();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LockInfo)) {
                return false;
            }
            LockInfo o = (LockInfo)other;
            return this.extLockId == o.extLockId && this.intLockId == o.intLockId;
        }

        public String toString() {
            return JavaUtils.lockIdToString(this.extLockId) + " intLockId:" + this.intLockId + " " + JavaUtils.txnIdToString(this.txnId) + " db:" + this.db + " table:" + this.table + " partition:" + this.partition + " state:" + (this.state == null ? "null" : this.state.toString()) + " type:" + (this.type == null ? "null" : this.type.toString());
        }

        private boolean isDbLock() {
            return this.db != null && this.table == null && this.partition == null;
        }

        private boolean isTableLock() {
            return this.db != null && this.table != null && this.partition == null;
        }

        private boolean isPartitionLock() {
            return !this.isDbLock() && !this.isTableLock();
        }
    }

    protected class RetryException
    extends Exception {
        protected RetryException() {
        }
    }

    private static class LockInfoExt
    extends LockInfo {
        private final ShowLocksResponseElement e;

        LockInfoExt(ShowLocksResponseElement e) {
            super(e);
            this.e = e;
        }
    }

    private static final class TxnRecord {
        private final TxnType type;

        private TxnRecord(int txnType) {
            this.type = TxnType.findByValue(txnType);
        }

        static /* synthetic */ TxnType access$000(TxnRecord x0) {
            return x0.type;
        }
    }

    private static final class ConnectionLockIdPair {
        private final Connection dbConn;
        private final long extLockId;

        private ConnectionLockIdPair(Connection dbConn, long extLockId) {
            this.dbConn = dbConn;
            this.extLockId = extLockId;
        }
    }

    static enum OperationType {
        SELECT('s'),
        INSERT('i'),
        UPDATE('u'),
        DELETE('d'),
        COMPACT('c');

        private final char sqlConst;

        private OperationType(char sqlConst) {
            this.sqlConst = sqlConst;
        }

        public String toString() {
            return Character.toString(this.sqlConst);
        }

        public static OperationType fromString(char sqlConst) {
            switch (sqlConst) {
                case 's': {
                    return SELECT;
                }
                case 'i': {
                    return INSERT;
                }
                case 'u': {
                    return UPDATE;
                }
                case 'd': {
                    return DELETE;
                }
                case 'c': {
                    return COMPACT;
                }
            }
            throw new IllegalArgumentException(TxnHandler.quoteChar(sqlConst));
        }

        public static OperationType fromDataOperationType(DataOperationType dop) {
            switch (dop) {
                case SELECT: {
                    return SELECT;
                }
                case INSERT: {
                    return INSERT;
                }
                case UPDATE: {
                    return UPDATE;
                }
                case DELETE: {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)dop));
        }

        char getSqlConst() {
            return this.sqlConst;
        }
    }

    static enum TxnStatus {
        OPEN,
        ABORTED,
        COMMITTED,
        UNKNOWN;

    }
}

