/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;

public class CompactionInfo
implements Comparable<CompactionInfo> {
    public long id;
    public String dbname;
    public String tableName;
    public String partName;
    public char state;
    public CompactionType type;
    public String workerId;
    public long start;
    public String runAs;
    public String properties;
    public boolean tooManyAborts = false;
    public long highestWriteId;
    byte[] metaInfo;
    String hadoopJobId;
    public String errorMessage;
    private String fullPartitionName = null;
    private String fullTableName = null;

    public CompactionInfo(String dbname, String tableName, String partName, CompactionType type) {
        this.dbname = dbname;
        this.tableName = tableName;
        this.partName = partName;
        this.type = type;
    }

    CompactionInfo(long id, String dbname, String tableName, String partName, char state) {
        this(dbname, tableName, partName, null);
        this.id = id;
        this.state = state;
    }

    CompactionInfo() {
    }

    public String getFullPartitionName() {
        if (this.fullPartitionName == null) {
            StringBuilder buf = new StringBuilder(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            if (this.partName != null) {
                buf.append('.');
                buf.append(this.partName);
            }
            this.fullPartitionName = buf.toString();
        }
        return this.fullPartitionName;
    }

    public String getFullTableName() {
        if (this.fullTableName == null) {
            StringBuilder buf = new StringBuilder(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            this.fullTableName = buf.toString();
        }
        return this.fullTableName;
    }

    public boolean isMajorCompaction() {
        return CompactionType.MAJOR == this.type;
    }

    @Override
    public int compareTo(CompactionInfo o) {
        return this.getFullPartitionName().compareTo(o.getFullPartitionName());
    }

    public String toString() {
        return "id:" + this.id + "," + "dbname:" + this.dbname + "," + "tableName:" + this.tableName + "," + "partName:" + this.partName + "," + "state:" + this.state + "," + "type:" + (Object)((Object)this.type) + "," + "properties:" + this.properties + "," + "runAs:" + this.runAs + "," + "tooManyAborts:" + this.tooManyAborts + "," + "highestWriteId:" + this.highestWriteId + "," + "errorMessage:" + this.errorMessage;
    }

    static CompactionInfo loadFullFromCompactionQueue(ResultSet rs) throws SQLException {
        CompactionInfo fullCi = new CompactionInfo();
        fullCi.id = rs.getLong(1);
        fullCi.dbname = rs.getString(2);
        fullCi.tableName = rs.getString(3);
        fullCi.partName = rs.getString(4);
        fullCi.state = rs.getString(5).charAt(0);
        fullCi.type = TxnHandler.dbCompactionType2ThriftType(rs.getString(6).charAt(0));
        fullCi.properties = rs.getString(7);
        fullCi.workerId = rs.getString(8);
        fullCi.start = rs.getLong(9);
        fullCi.runAs = rs.getString(10);
        fullCi.highestWriteId = rs.getLong(11);
        fullCi.metaInfo = rs.getBytes(12);
        fullCi.hadoopJobId = rs.getString(13);
        fullCi.errorMessage = rs.getString(14);
        return fullCi;
    }

    static void insertIntoCompletedCompactions(PreparedStatement pStmt, CompactionInfo ci, long endTime) throws SQLException {
        pStmt.setLong(1, ci.id);
        pStmt.setString(2, ci.dbname);
        pStmt.setString(3, ci.tableName);
        pStmt.setString(4, ci.partName);
        pStmt.setString(5, Character.toString(ci.state));
        pStmt.setString(6, Character.toString(TxnHandler.thriftCompactionType2DbType(ci.type).charValue()));
        pStmt.setString(7, ci.properties);
        pStmt.setString(8, ci.workerId);
        pStmt.setLong(9, ci.start);
        pStmt.setLong(10, endTime);
        pStmt.setString(11, ci.runAs);
        pStmt.setLong(12, ci.highestWriteId);
        pStmt.setBytes(13, ci.metaInfo);
        pStmt.setString(14, ci.hadoopJobId);
        pStmt.setString(15, ci.errorMessage);
    }

    public static CompactionInfo compactionStructToInfo(CompactionInfoStruct cr) {
        if (cr == null) {
            return null;
        }
        CompactionInfo ci = new CompactionInfo(cr.getDbname(), cr.getTablename(), cr.getPartitionname(), cr.getType());
        ci.id = cr.getId();
        ci.runAs = cr.getRunas();
        ci.properties = cr.getProperties();
        if (cr.isSetToomanyaborts()) {
            ci.tooManyAborts = cr.isToomanyaborts();
        }
        if (cr.isSetState() && cr.getState().length() != 1) {
            throw new IllegalStateException("State should only be one character but it was set to " + cr.getState());
        }
        if (cr.isSetState()) {
            ci.state = cr.getState().charAt(0);
        }
        ci.workerId = cr.getWorkerId();
        if (cr.isSetStart()) {
            ci.start = cr.getStart();
        }
        if (cr.isSetHighestWriteId()) {
            ci.highestWriteId = cr.getHighestWriteId();
        }
        if (cr.isSetErrorMessage()) {
            ci.errorMessage = cr.getErrorMessage();
        }
        return ci;
    }

    public static CompactionInfoStruct compactionInfoToStruct(CompactionInfo ci) {
        if (ci == null) {
            return null;
        }
        CompactionInfoStruct cr = new CompactionInfoStruct(ci.id, ci.dbname, ci.tableName, ci.type);
        cr.setPartitionname(ci.partName);
        cr.setRunas(ci.runAs);
        cr.setProperties(ci.properties);
        cr.setToomanyaborts(ci.tooManyAborts);
        cr.setStart(ci.start);
        cr.setState(Character.toString(ci.state));
        cr.setWorkerId(ci.workerId);
        cr.setHighestWriteId(ci.highestWriteId);
        cr.setErrorMessage(ci.errorMessage);
        return cr;
    }

    public static OptionalCompactionInfoStruct compactionInfoToOptionalStruct(CompactionInfo ci) {
        CompactionInfoStruct cis = CompactionInfo.compactionInfoToStruct(ci);
        OptionalCompactionInfoStruct ocis = new OptionalCompactionInfoStruct();
        if (cis != null) {
            ocis.setCi(cis);
        }
        return ocis;
    }

    public static CompactionInfo optionalCompactionInfoStructToInfo(OptionalCompactionInfoStruct ocis) {
        if (ocis.isSetCi()) {
            return CompactionInfo.compactionStructToInfo(ocis.getCi());
        }
        return null;
    }
}

