/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.util.Collection;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;

class MetaToolTaskExecuteJDOQLQuery
extends MetaToolTask {
    MetaToolTaskExecuteJDOQLQuery() {
    }

    @Override
    void execute() {
        String query = this.getCl().getJDOQLQuery();
        if (query.toLowerCase().trim().startsWith("select")) {
            this.executeJDOQLSelect(query);
        } else if (query.toLowerCase().trim().startsWith("update")) {
            this.executeJDOQLUpdate(query);
        } else {
            throw new IllegalArgumentException("HiveMetaTool:Unsupported statement type, only select and update supported");
        }
    }

    private void executeJDOQLSelect(String query) {
        System.out.println("Executing query: " + query);
        try (ObjectStore.QueryWrapper queryWrapper = new ObjectStore.QueryWrapper();){
            Collection<?> result = this.getObjectStore().executeJDOQLSelect(query, queryWrapper);
            if (result != null) {
                for (Object o : result) {
                    System.out.println(o.toString());
                }
            } else {
                System.err.println("Encountered error during executeJDOQLSelect");
            }
        }
    }

    private void executeJDOQLUpdate(String query) {
        System.out.println("Executing query: " + query);
        long numUpdated = this.getObjectStore().executeJDOQLUpdate(query);
        if (numUpdated >= 0L) {
            System.out.println("Number of records updated: " + numUpdated);
        } else {
            System.err.println("Encountered error during executeJDOQL - commit of JDO transaction failed.");
        }
    }
}

