/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.metatool.HiveMetaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskExecuteJDOQLQuery;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskListFSRoot;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskUpdateLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveMetaTool {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HiveMetaTool.class.getName());

    private HiveMetaTool() {
        throw new UnsupportedOperationException("HiveMetaTool should not be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HiveMetaToolCommandLine cl = HiveMetaToolCommandLine.parseArguments(args);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(MetastoreConf.newMetastoreConf());
        MetaToolTask task = null;
        try {
            if (cl.isListFSRoot()) {
                task = new MetaToolTaskListFSRoot();
            } else if (cl.isExecuteJDOQL()) {
                task = new MetaToolTaskExecuteJDOQLQuery();
            } else if (cl.isUpdateLocation()) {
                task = new MetaToolTaskUpdateLocation();
            } else {
                throw new IllegalArgumentException("No task was specified!");
            }
            task.setObjectStore(objectStore);
            task.setCommandLine(cl);
            task.execute();
        }
        catch (Exception e) {
            LOGGER.error("Exception occured", (Throwable)e);
        }
        finally {
            objectStore.shutdown();
        }
    }
}

