/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.Query;

final class QueryFactory {
    private static final String[] USER_OBJECT_CLASSES = new String[]{"person", "user", "inetOrgPerson"};
    private final String guidAttr;
    private final String groupClassAttr;
    private final String groupMembershipAttr;
    private final String userMembershipAttr;

    public QueryFactory(Configuration conf) {
        this.guidAttr = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GUIDKEY);
        this.groupClassAttr = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPCLASS_KEY);
        this.groupMembershipAttr = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPMEMBERSHIP_KEY);
        this.userMembershipAttr = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY);
    }

    public Query findGroupDnById(String groupId) {
        return Query.builder().filter("(&(objectClass=<groupClassAttr>)(<guidAttr>=<groupID>))").map("guidAttr", this.guidAttr).map("groupClassAttr", this.groupClassAttr).map("groupID", groupId).limit(2).build();
    }

    public Query findUserDnByRdn(String userRdn) {
        return Query.builder().filter("(&(|<classes:{ class |(objectClass=<class>)}>)(<userRdn>))").limit(2).map("classes", USER_OBJECT_CLASSES).map("userRdn", userRdn).build();
    }

    public Query findDnByPattern(String rdn) {
        return Query.builder().filter("(<rdn>)").map("rdn", rdn).limit(2).build();
    }

    public Query findUserDnByName(String userName) {
        return Query.builder().filter("(&(|<classes:{ class |(objectClass=<class>)}>)(|(uid=<userName>)(sAMAccountName=<userName>)))").map("classes", USER_OBJECT_CLASSES).map("userName", userName).limit(2).build();
    }

    public Query findGroupsForUser(String userName, String userDn) {
        return Query.builder().filter("(&(objectClass=<groupClassAttr>)(|(<groupMembershipAttr>=<userDn>)(<groupMembershipAttr>=<userName>)))").map("groupClassAttr", this.groupClassAttr).map("groupMembershipAttr", this.groupMembershipAttr).map("userName", userName).map("userDn", userDn).build();
    }

    public Query isUserMemberOfGroup(String userId, String groupDn) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.userMembershipAttr) ? 1 : 0) != 0, (Object)"metastore.authentication.ldap.userMembershipKey is not configured.");
        return Query.builder().filter("(&(|<classes:{ class |(objectClass=<class>)}>)(<userMembershipAttr>=<groupDn>)(<guidAttr>=<userId>))").map("classes", USER_OBJECT_CLASSES).map("guidAttr", this.guidAttr).map("userMembershipAttr", this.userMembershipAttr).map("userId", userId).map("groupDn", groupDn).limit(2).build();
    }

    public Query customQuery(String searchFilter) {
        Query.QueryBuilder builder = Query.builder();
        builder.filter(searchFilter);
        if (!Strings.isNullOrEmpty((String)this.groupMembershipAttr)) {
            builder.returnAttribute(this.groupMembershipAttr);
        }
        return builder.build();
    }
}

