/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.BoneCPDataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DbCPDataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.HikariCPDataSourceProvider;

public abstract class DataSourceProviderFactory {
    private static final ImmutableList<DataSourceProvider> FACTORIES = ImmutableList.builder().add((Object[])new DataSourceProvider[]{new HikariCPDataSourceProvider(), new BoneCPDataSourceProvider(), new DbCPDataSourceProvider()}).build();

    public static DataSourceProvider getDataSourceProvider(Configuration hdpConfig) {
        for (DataSourceProvider factory : FACTORIES) {
            if (!factory.supports(hdpConfig)) continue;
            return factory;
        }
        return null;
    }

    public static boolean hasProviderSpecificConfigurations(Configuration hdpConfig) {
        String poolingType = MetastoreConf.getVar(hdpConfig, MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE).toLowerCase();
        return Iterables.any((Iterable)hdpConfig, entry -> {
            String key = (String)entry.getKey();
            return key != null && key.startsWith(poolingType);
        });
    }
}

