/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledQueryExecutionsMaintTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledQueryExecutionsMaintTask.class);
    private Configuration conf;

    @Override
    public long initialDelay(TimeUnit unit) {
        return 0L;
    }

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.SCHEDULED_QUERIES_EXECUTION_MAINT_TASK_FREQUENCY, unit);
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void run() {
        try {
            int maxRetainSecs;
            int deleteCnt;
            int timeoutSecs;
            if (!MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED)) {
                return;
            }
            RawStore ms = HiveMetaStore.HMSHandler.getMSForConf(this.conf);
            int timedOutCnt = ms.markScheduledExecutionsTimedOut(timeoutSecs = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.SCHEDULED_QUERIES_EXECUTION_PROGRESS_TIMEOUT, TimeUnit.SECONDS));
            if ((long)timedOutCnt > 0L) {
                LOG.info("Number of timed out scheduled query executions:" + timedOutCnt);
            }
            if ((long)(deleteCnt = ms.deleteScheduledExecutions(maxRetainSecs = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.SCHEDULED_QUERIES_EXECUTION_MAX_AGE, TimeUnit.SECONDS))) > 0L) {
                LOG.info("Number of deleted entries: " + deleteCnt);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to delete: " + e.getMessage(), (Throwable)e);
        }
    }
}

