/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockType;

public class LockRequestBuilder {
    private LockRequest req = new LockRequest();
    private LockTrie trie = new LockTrie();
    private boolean userSet = false;

    public LockRequestBuilder() {
        this(null);
    }

    public LockRequestBuilder(String agentInfo) {
        if (agentInfo != null) {
            this.req.setAgentInfo(agentInfo);
        }
    }

    public LockRequest build() {
        if (!this.userSet) {
            throw new RuntimeException("Cannot build a lock without giving a user");
        }
        this.trie.addLocksToRequest(this.req);
        try {
            this.req.setHostname(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to determine our local host!");
        }
        return this.req;
    }

    public LockRequestBuilder setTransactionId(long txnid) {
        this.req.setTxnid(txnid);
        return this;
    }

    public LockRequestBuilder setUser(String user) {
        if (user == null) {
            user = "unknown";
        }
        this.req.setUser(user);
        this.userSet = true;
        return this;
    }

    public LockRequestBuilder addLockComponent(LockComponent component) {
        this.trie.add(component);
        return this;
    }

    public LockRequestBuilder addLockComponents(Collection<LockComponent> components) {
        this.trie.addAll(components);
        return this;
    }

    private static class LockTrie {
        Map<String, TableTrie> trie = new LinkedHashMap<String, TableTrie>();

        LockTrie() {
        }

        public void add(LockComponent comp) {
            TableTrie tabs = this.trie.get(comp.getDbname());
            if (tabs == null) {
                tabs = new TableTrie();
                this.trie.put(comp.getDbname(), tabs);
            }
            this.setTable(comp, tabs);
        }

        public void addAll(Collection<LockComponent> components) {
            for (LockComponent component : components) {
                this.add(component);
            }
        }

        public void addLocksToRequest(LockRequest request) {
            for (TableTrie tab : this.trie.values()) {
                for (PartTrie part : tab.values()) {
                    for (LockComponent lock2 : part.values()) {
                        request.addToComponent(lock2);
                    }
                }
            }
        }

        private void setTable(LockComponent comp, TableTrie tabs) {
            PartTrie parts = (PartTrie)tabs.get(comp.getTablename());
            if (parts == null) {
                parts = new PartTrie();
                tabs.put(comp.getTablename(), parts);
            }
            this.setPart(comp, parts);
        }

        private void setPart(LockComponent comp, PartTrie parts) {
            LockComponent existing = (LockComponent)parts.get(comp.getPartitionname());
            if (existing == null) {
                parts.put(comp.getPartitionname(), comp);
            } else if (existing.getType() != LockType.EXCLUSIVE && (comp.getType() == LockType.EXCLUSIVE || comp.getType() == LockType.SHARED_WRITE)) {
                parts.put(comp.getPartitionname(), comp);
            }
        }

        private static class PartTrie
        extends LinkedHashMap<String, LockComponent> {
            private PartTrie() {
            }
        }

        private static class TableTrie
        extends LinkedHashMap<String, PartTrie> {
            private TableTrie() {
            }
        }
    }
}

